/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.data.IntList;
import processing.data.StringList;
import processing.data.Table;
import processing.data.TableRow;
import processing.data.XML;
import processing.event.MouseEvent;
import processing.serial.Serial;

public class ProcessingGrapherexp3
extends PApplet {
    final String versionNumber = "0.1";
    float uimult = 1.2f;
    final String programFont = "Lucida Sans";
    final String terminalFont = "Inconsolata-SemiBold.ttf";
    final int c_white = this.color(255, 255, 255);
    final int c_blue = this.color(96, 200, 220);
    final int c_purple = this.color(147, 111, 212);
    final int c_red = this.color(208, 38, 98);
    final int c_yellow = this.color(215, 196, 96);
    final int c_green = this.color(35, 205, 65);
    final int c_orange = this.color(230, 85, 37);
    final int c_lightgrey = this.color(134, 134, 138);
    final int c_grey = this.color(111, 108, 90);
    final int c_darkgrey = this.color(49, 50, 44);
    final int c_black = this.color(0, 0, 0);
    int colorScheme = 2;
    int[] c_colorlist = new int[]{this.c_blue, this.c_purple, this.c_red, this.c_yellow, this.c_green, this.c_orange};
    int lastWidth = 1000;
    int lastHeight = 700;
    final int tabWidth = 90;
    final int tabHeight = 30;
    final int sidebarWidth = 150;
    final int sideItemHeight = 30;
    final int bottombarHeight = 22;
    int c_background;
    int c_tabbar;
    int c_tabbar_h;
    int c_idletab;
    int c_tabbar_text;
    int c_idletab_text;
    int c_sidebar;
    int c_sidebar_h;
    int c_sidebar_heading;
    int c_sidebar_text;
    int c_sidebar_button;
    int c_sidebar_divider;
    int c_sidebar_accent;
    int c_terminal_text;
    int c_message_text;
    int c_graph_axis;
    int c_graph_gridlines;
    int c_graph_border;
    int c_serial_message_box;
    int c_message_box_outline;
    int c_alert_message_box;
    int c_info_message_box;
    int c_status_bar;
    int c_highlight_background;
    Serial myPort;
    int portNumber = 0;
    int baudRate = 115200;
    char lineEnding = (char)10;
    boolean serialConnected = false;
    String currentPort = "";
    String[] portList;
    char serialParity = (char)78;
    int serialDatabits = 8;
    float serialStopbits = 1.0f;
    char separator = (char)32;
    boolean recoo;
    boolean redrawUI = true;
    boolean redrawAlert = false;
    boolean redrawContent = true;
    boolean drawNewData = false;
    boolean drawFPS = false;
    boolean preventDrawing = false;
    boolean settingsMenuActive = false;
    boolean showInstructions = true;
    boolean programActive = true;
    int state = 0;
    boolean textInput = false;
    boolean controlKey = false;
    boolean scrollingActive = false;
    boolean contentScrolling = false;
    ArrayList<TabAPI> tabObjects = new ArrayList();
    TabAPI settings;
    int currentTab = 0;
    int tabTop = ProcessingGrapherexp3.round((float)(30.0f * this.uimult));
    PFont base_font;
    PFont mono_font;
    final int alertWidth = 300;
    final int alertHeight = 150;
    String alertHeading = "";
    boolean alertActive = false;
    DisposeHandler dh;
    Stage stage;
    FileChooser fileChooser;
    File currentDirectory = null;
    String userInputString = null;
    int startTime;
    PGraphics mainCanvas;
    final String activeRenderer = "processing.javafx.PGraphicsFX2D";

    public void setup() {
        this.loadColorScheme(this.colorScheme);
        this.background(this.c_background);
        this.frameRate(60.0f);
    }

    public void setupProgram() {
        this.startTime = this.millis();
        this.stage = (Stage)((Canvas)this.surface.getNative()).getScene().getWindow();
        this.fileChooser = new FileChooser();
        this.stage.setMinWidth(600.0);
        this.stage.setMinHeight(350.0);
        this.dh = new DisposeHandler(this);
        this.surface.setIcon(this.loadImage("icon-48.png"));
        this.surface.setTitle("LDperformance DBW controller");
        this.mainCanvas = this.g;
        this.surface.setResizable(true);
        this.base_font = this.createFont("Lucida Sans", PApplet.parseInt((float)(13.0f * this.uimult)), true);
        this.mono_font = this.createFont("Inconsolata-SemiBold.ttf", PApplet.parseInt((float)(14.0f * this.uimult)), true);
        this.textFont(this.base_font);
        int tabWidth2 = ProcessingGrapherexp3.round((float)((float)this.width - 150.0f * this.uimult));
        int tabBottom = ProcessingGrapherexp3.round((float)((float)this.height - 22.0f * this.uimult));
        this.settings = new Settings("Settings", 0, tabWidth2, this.tabTop, tabBottom);
        this.settings.drawContent();
        tabWidth2 = ProcessingGrapherexp3.round((float)((float)this.width - 150.0f * this.uimult));
        tabBottom = ProcessingGrapherexp3.round((float)((float)this.height - 22.0f * this.uimult));
        this.tabObjects.add(new SerialMonitor("Serial", 0, tabWidth2, this.tabTop, tabBottom));
        this.tabObjects.add(new LiveGraph("Live Graph", 0, tabWidth2, this.tabTop, tabBottom));
        this.tabObjects.add(new FileGraph("File Graph", 0, tabWidth2, this.tabTop, tabBottom));
        this.tabObjects.get(0).setVisibility(true);
        this.portList = Serial.list();
        if (this.portList.length > 0) {
            this.currentPort = this.portList[this.portList.length - 1];
        }
        this.thread("checkSerialPortList");
    }

    public void uiResize(float amount) {
        this.uimult += amount;
        this.uiResize();
    }

    public void uiResize() {
        this.base_font = this.createFont("Lucida Sans", PApplet.parseInt((float)(13.0f * this.uimult)), true);
        this.mono_font = this.createFont("Inconsolata-SemiBold.ttf", PApplet.parseInt((float)(14.0f * this.uimult)), true);
        this.tabTop = ProcessingGrapherexp3.round((float)(30.0f * this.uimult));
        for (TabAPI curTab : this.tabObjects) {
            curTab.changeSize(0, ProcessingGrapherexp3.round((float)((float)this.width - 150.0f * this.uimult)), ProcessingGrapherexp3.round((float)(30.0f * this.uimult)), ProcessingGrapherexp3.round((float)((float)this.height - 22.0f * this.uimult)));
        }
        this.settings.changeSize(0, ProcessingGrapherexp3.round((float)((float)this.width - 150.0f * this.uimult)), ProcessingGrapherexp3.round((float)(30.0f * this.uimult)), ProcessingGrapherexp3.round((float)((float)this.height - 22.0f * this.uimult)));
        this.redrawUI = true;
        this.redrawContent = true;
    }

    public void exit() {
        for (TabAPI curTab : this.tabObjects) {
            curTab.performExit();
        }
        this.programActive = false;
        ProcessingGrapherexp3.println((String)"Exiting program - exit()");
        this.exitActual();
    }

    public void draw() {
        switch (this.state) {
            case 0: {
                this.drawLoadingScreen();
                if (this.millis() <= this.startTime + 2000) break;
                ++this.state;
                break;
            }
            case 1: {
                this.setupProgram();
                ++this.state;
                break;
            }
            default: {
                this.drawProgram();
            }
        }
    }

    public void drawProgram() {
        if (this.alertActive && (this.redrawContent || this.drawNewData || this.redrawUI)) {
            this.redrawContent = true;
            this.redrawUI = true;
            this.redrawAlert = true;
        }
        if (this.lastWidth != this.width || this.lastHeight != this.height) {
            if (this.width < 400 || this.height < 300) {
                this.background(this.c_background);
                this.textAlign(3, 3);
                this.text("Window Size too small !", this.width / 2, this.height / 2);
                this.lastWidth = this.width;
                this.lastHeight = this.height;
                this.preventDrawing = true;
            } else {
                this.redrawUI = true;
                this.redrawContent = true;
                this.preventDrawing = false;
                this.lastWidth = this.width;
                this.lastHeight = this.height;
                if (this.alertActive) {
                    this.redrawAlert = true;
                }
                for (TabAPI curTab : this.tabObjects) {
                    curTab.changeSize(0, ProcessingGrapherexp3.round((float)((float)this.width - 150.0f * this.uimult)), ProcessingGrapherexp3.round((float)(30.0f * this.uimult)), ProcessingGrapherexp3.round((float)((float)this.height - 22.0f * this.uimult)));
                }
                this.settings.changeSize(0, ProcessingGrapherexp3.round((float)((float)this.width - 150.0f * this.uimult)), ProcessingGrapherexp3.round((float)(30.0f * this.uimult)), ProcessingGrapherexp3.round((float)((float)this.height - 22.0f * this.uimult)));
            }
        }
        if (!this.preventDrawing) {
            TabAPI curTab;
            if (this.scrollingActive) {
                if (this.settingsMenuActive && !this.contentScrolling) {
                    this.settings.scrollBarUpdate(this.mouseX, this.mouseY);
                } else {
                    curTab = this.tabObjects.get(this.currentTab);
                    curTab.scrollBarUpdate(this.mouseX, this.mouseY);
                }
            }
            if (this.redrawContent) {
                if (this.tabObjects.size() > this.currentTab) {
                    curTab = this.tabObjects.get(this.currentTab);
                    curTab.drawContent();
                    this.redrawContent = false;
                } else {
                    this.currentTab = 0;
                }
            }
            if (this.drawNewData) {
                if (this.tabObjects.size() > this.currentTab) {
                    curTab = this.tabObjects.get(this.currentTab);
                    curTab.drawNewData();
                    this.drawNewData = false;
                } else {
                    this.currentTab = 0;
                }
            }
            if (this.redrawUI) {
                this.drawTabs(this.currentTab);
                this.drawSidebar();
                this.drawInfoBar();
                this.redrawUI = false;
            }
            if (this.drawFPS) {
                this.rectMode(1);
                this.noStroke();
                this.textAlign(3, 3);
                String frameRateText = "FPS: " + ProcessingGrapherexp3.round((float)this.frameRate);
                this.fill(this.c_tabbar);
                int cL = this.width - ProcessingGrapherexp3.round((float)(329.0f * this.uimult + this.textWidth(frameRateText)));
                int cR = this.width - ProcessingGrapherexp3.round((float)(327.0f * this.uimult));
                this.rect(cL, (float)this.height - 22.0f * this.uimult, cR, this.height);
                this.fill(this.c_idletab_text);
                this.text(frameRateText, cL, (float)this.height - 22.0f * this.uimult, cR, this.height - ProcessingGrapherexp3.round((float)(4.0f * this.uimult)));
                if (this.alertActive && !this.redrawAlert) {
                    this.fill(this.c_white, 80.0f);
                    this.rect(cL, (float)this.height - 22.0f * this.uimult, cR, this.height);
                }
            }
            if (this.redrawAlert) {
                this.drawAlert();
                this.redrawAlert = false;
            }
        }
    }

    public void drawTabs(int highlight) {
        this.rectMode(0);
        this.noStroke();
        this.textAlign(3, 3);
        this.fill(this.c_tabbar);
        this.rect(0.0f, 0.0f, this.width, 30.0f * this.uimult);
        this.fill(this.c_tabbar_h);
        this.rect(0.0f, 29.0f * this.uimult, this.width, 1.0f * this.uimult);
        int i = 0;
        int calcWidth = PApplet.parseInt((float)(89.0f * this.uimult));
        for (TabAPI curTab : this.tabObjects) {
            int calcXpos = PApplet.parseInt((float)((float)(i * 90) * this.uimult));
            if (highlight == i) {
                this.fill(this.c_background);
                this.rect(calcXpos, 0.0f, calcWidth, 30.0f * this.uimult);
                this.fill(this.c_red);
                this.rect(calcXpos, 0.0f, calcWidth, 4.0f * this.uimult);
                this.fill(this.c_tabbar_text);
            } else {
                this.fill(this.c_idletab);
                this.rect(calcXpos, 0.0f, calcWidth, 29.0f * this.uimult);
                this.fill(this.c_idletab_text);
            }
            this.text(curTab.getName(), calcXpos, 0.0f, calcWidth, 30.0f * this.uimult);
            ++i;
        }
        if (!this.settingsMenuActive) {
            this.fill(this.c_idletab);
            this.rect(this.width - PApplet.parseInt((float)(40.0f * this.uimult)), 0.0f, 40.0f * this.uimult, 29.0f * this.uimult);
            this.fill(this.c_idletab_text);
            this.rect(this.width - PApplet.parseInt((float)(28.0f * this.uimult)), 30.0f * this.uimult * 2.0f / 6.0f - 1.0f * this.uimult, 10.0f * this.uimult, 1.5f * this.uimult);
            this.circle(this.width - PApplet.parseInt((float)(14.0f * this.uimult)), 30.0f * this.uimult * 2.0f / 6.0f, 4.0f * this.uimult);
            this.rect(this.width - PApplet.parseInt((float)(28.0f * this.uimult)), 30.0f * this.uimult * 3.0f / 6.0f - 1.0f * this.uimult, 2.0f * this.uimult, 1.5f * this.uimult);
            this.circle(this.width - PApplet.parseInt((float)(22.0f * this.uimult)), 30.0f * this.uimult * 3.0f / 6.0f, 4.0f * this.uimult);
            this.rect(this.width - PApplet.parseInt((float)(18.0f * this.uimult)), 30.0f * this.uimult * 3.0f / 6.0f - 1.0f * this.uimult, 6.0f * this.uimult, 1.5f * this.uimult);
            this.rect(this.width - PApplet.parseInt((float)(28.0f * this.uimult)), 30.0f * this.uimult * 4.0f / 6.0f - 1.0f * this.uimult, 10.0f * this.uimult, 1.5f * this.uimult);
            this.circle(this.width - PApplet.parseInt((float)(14.0f * this.uimult)), 30.0f * this.uimult * 4.0f / 6.0f, 4.0f * this.uimult);
        } else {
            this.fill(this.c_background);
            this.rect(ProcessingGrapherexp3.round((float)((float)this.width - 150.0f * this.uimult + 1.0f)), 0.0f, 150.0f * this.uimult, 29.0f * this.uimult);
            this.fill(this.c_tabbar_text);
            this.text("Settings", (float)this.width - 170.0f * this.uimult / 2.0f, 14.0f * this.uimult);
            this.fill(this.c_background);
            this.rect(this.width - PApplet.parseInt((float)(40.0f * this.uimult)), 0.0f, 40.0f * this.uimult, 29.0f * this.uimult);
            this.fill(this.c_tabbar_text);
            this.stroke(this.c_tabbar_text);
            this.strokeWeight(1.5f * this.uimult);
            this.line(this.width - PApplet.parseInt((float)(25.0f * this.uimult)), 30.0f * this.uimult / 3.0f, this.width - PApplet.parseInt((float)(15.0f * this.uimult)), 30.0f * this.uimult * 2.0f / 3.0f);
            this.line(this.width - PApplet.parseInt((float)(15.0f * this.uimult)), 30.0f * this.uimult / 3.0f, this.width - PApplet.parseInt((float)(25.0f * this.uimult)), 30.0f * this.uimult * 2.0f / 3.0f);
        }
    }

    public void drawSidebar() {
        this.rectMode(0);
        this.noStroke();
        this.textAlign(3, 3);
        int sT = ProcessingGrapherexp3.round((float)(30.0f * this.uimult));
        int sL = ProcessingGrapherexp3.round((float)((float)this.width - 150.0f * this.uimult + 1.0f));
        int sW = ProcessingGrapherexp3.round((float)(150.0f * this.uimult));
        int sH = this.height - sT;
        this.fill(this.c_tabbar);
        this.rect(0.0f, (float)this.height - 22.0f * this.uimult, this.width - sW + 1, 22.0f * this.uimult);
        this.fill(this.c_tabbar_h);
        this.rect(0.0f, (float)this.height - 22.0f * this.uimult, this.width - sW + 1, 1.0f * this.uimult);
        this.fill(this.c_sidebar);
        this.rect(sL, sT, sW, sH);
        this.fill(this.c_sidebar_h);
        this.rect(sL - 1, sT, 1.0f * this.uimult, sH);
        if (this.settingsMenuActive) {
            this.settings.drawSidebar();
        } else if (this.tabObjects.size() > this.currentTab) {
            TabAPI curTab = this.tabObjects.get(this.currentTab);
            curTab.drawSidebar();
        } else {
            this.currentTab = 0;
        }
    }

    public void drawInfoBar() {
        this.rectMode(0);
        this.noStroke();
        this.textAlign(3, 3);
        int sW = ProcessingGrapherexp3.round((float)(150.0f * this.uimult));
        int bW = ProcessingGrapherexp3.round((float)(70.0f * this.uimult));
        int pW = ProcessingGrapherexp3.round((float)(70.0f * this.uimult));
        int cW = ProcessingGrapherexp3.round((float)(22.0f * this.uimult));
        int bH = ProcessingGrapherexp3.round((float)(22.0f * this.uimult));
        int cL = this.width - sW - pW - cW - bW - ProcessingGrapherexp3.round((float)(4.0f * this.uimult));
        int cR = this.width - sW - pW - bW - ProcessingGrapherexp3.round((float)(4.0f * this.uimult));
        int pL = this.width - sW - pW - bW - ProcessingGrapherexp3.round((float)(2.0f * this.uimult));
        ProcessingGrapherexp3.round((float)(2.0f * this.uimult));
        int bL = this.width - sW - bW - ProcessingGrapherexp3.round((float)(0.0f * this.uimult));
        ProcessingGrapherexp3.round((float)(0.0f * this.uimult));
        this.fill(this.c_tabbar);
        this.rect(0.0f, this.height - bH, this.width - sW + 1, bH);
        if (this.serialConnected) {
            this.fill(this.c_status_bar);
            this.rect(cL, this.height - bH, cW, bH);
            this.fill(this.c_idletab);
            this.circle(cL + cW / 2 + ProcessingGrapherexp3.round((float)(1.0f * this.uimult)), this.height - bH / 2 - ProcessingGrapherexp3.round((float)(1.0f * this.uimult)), ProcessingGrapherexp3.round((float)(6.0f * this.uimult)));
            this.circle(cL + cW / 2 - ProcessingGrapherexp3.round((float)(1.0f * this.uimult)), this.height - bH / 2 + ProcessingGrapherexp3.round((float)(1.0f * this.uimult)), ProcessingGrapherexp3.round((float)(6.0f * this.uimult)));
            this.stroke(this.c_idletab);
            this.strokeWeight(1.0f * this.uimult);
            this.line(cL + ProcessingGrapherexp3.round((float)(5.0f * this.uimult)), this.height - ProcessingGrapherexp3.round((float)(5.0f * this.uimult)), cR - ProcessingGrapherexp3.round((float)(5.0f * this.uimult)), this.height - bH + ProcessingGrapherexp3.round((float)(5.0f * this.uimult)));
            this.stroke(this.c_status_bar);
            this.strokeWeight(1.0f * this.uimult);
            this.line(cL + ProcessingGrapherexp3.round((float)(1.0f * this.uimult)), this.height - bH + ProcessingGrapherexp3.round((float)(1.0f * this.uimult)), cR - ProcessingGrapherexp3.round((float)(1.0f * this.uimult)), this.height - ProcessingGrapherexp3.round((float)(1.0f * this.uimult)));
            this.noStroke();
        } else {
            this.fill(this.c_idletab);
            this.rect(cL, this.height - bH, cW, bH);
            this.fill(this.c_status_bar);
            this.circle(cL + cW / 2 + ProcessingGrapherexp3.round((float)(2.0f * this.uimult)), this.height - bH / 2 - ProcessingGrapherexp3.round((float)(2.0f * this.uimult)), ProcessingGrapherexp3.round((float)(6.0f * this.uimult)));
            this.circle(cL + cW / 2 - ProcessingGrapherexp3.round((float)(2.0f * this.uimult)), this.height - bH / 2 + ProcessingGrapherexp3.round((float)(2.0f * this.uimult)), ProcessingGrapherexp3.round((float)(6.0f * this.uimult)));
            this.stroke(this.c_status_bar);
            this.strokeWeight(1.0f * this.uimult);
            this.line(cL + ProcessingGrapherexp3.round((float)(5.0f * this.uimult)), this.height - ProcessingGrapherexp3.round((float)(5.0f * this.uimult)), cR - ProcessingGrapherexp3.round((float)(5.0f * this.uimult)), this.height - bH + ProcessingGrapherexp3.round((float)(5.0f * this.uimult)));
            this.stroke(this.c_idletab);
            this.strokeWeight(5.0f * this.uimult);
            this.line(cL + ProcessingGrapherexp3.round((float)(2.0f * this.uimult)), this.height - bH + ProcessingGrapherexp3.round((float)(2.0f * this.uimult)), cR - ProcessingGrapherexp3.round((float)(2.0f * this.uimult)), this.height - ProcessingGrapherexp3.round((float)(2.0f * this.uimult)));
            this.stroke(this.c_status_bar);
            this.strokeWeight(1.0f * this.uimult);
            this.line(cL + ProcessingGrapherexp3.round((float)(7.0f * this.uimult)), this.height - bH + ProcessingGrapherexp3.round((float)(7.0f * this.uimult)), cR - ProcessingGrapherexp3.round((float)(7.0f * this.uimult)), this.height - ProcessingGrapherexp3.round((float)(7.0f * this.uimult)));
            this.noStroke();
        }
        String[] ports = Serial.list();
        this.fill(this.c_idletab);
        this.rect(pL, this.height - bH, pW, bH);
        this.textAlign(3, 101);
        this.textFont(this.base_font);
        this.fill(this.c_status_bar);
        String portString = "Invalid";
        if (this.portNumber < ports.length) {
            portString = ports[this.portNumber];
        }
        portString = this.constrainString(portString, pW * 3 / 4);
        this.text(portString, pL + pW / 2, this.height - bH + ProcessingGrapherexp3.round((float)(2.0f * this.uimult)));
        this.fill(this.c_idletab);
        this.rect(bL, this.height - bH, bW, bH);
        this.textAlign(3, 101);
        this.textFont(this.base_font);
        this.fill(this.c_status_bar);
        this.text(ProcessingGrapherexp3.str((int)this.baudRate), bL + bW / 2, this.height - bH + ProcessingGrapherexp3.round((float)(2.0f * this.uimult)));
        this.fill(this.c_tabbar_h);
        this.rect(0.0f, this.height - bH, this.width - sW + ProcessingGrapherexp3.round((float)(1.0f * this.uimult)), ProcessingGrapherexp3.round((float)(1.0f * this.uimult)));
        if (this.tabObjects.size() > this.currentTab) {
            TabAPI curTab = this.tabObjects.get(this.currentTab);
            curTab.drawInfoBar();
        } else {
            this.currentTab = 0;
        }
    }

    public void drawLoadingScreen() {
        this.background(this.c_background);
        this.rectMode(3);
        this.noStroke();
        this.fill(this.c_tabbar);
        this.rect(this.width / 2, this.height / 2 - PApplet.parseInt((float)(15.0f * this.uimult)), PApplet.parseInt((float)(400.0f * this.uimult)), PApplet.parseInt((float)(340.0f * this.uimult)));
        this.fill(this.c_tabbar_h);
        this.rect(this.width / 2, this.height / 2 - PApplet.parseInt((float)(10.0f * this.uimult)), PApplet.parseInt((float)(400.0f * this.uimult)), PApplet.parseInt((float)(2.0f * this.uimult)));
        this.textAlign(3, 3);
        this.textSize(PApplet.parseInt((float)(20.0f * this.uimult)));
        this.fill(this.c_tabbar_text);
        this.image(this.loadImage("icon-48.png"), this.width / 2 - 24, this.height / 2 - PApplet.parseInt((float)(130.0f * this.uimult)));
        this.text("DBW Throttle Controller", this.width / 2, this.height / 2 - PApplet.parseInt((float)(50.0f * this.uimult)));
        this.textSize(PApplet.parseInt((float)(14.0f * this.uimult)));
        this.text("Loading v0.1", this.width / 2, this.height / 2 + PApplet.parseInt((float)(20.0f * this.uimult)));
        this.fill(this.c_terminal_text);
    }

    public void drawText(String text, int textcolor, float lS, float tS, float iW, float tH) {
        if (tS >= (float)this.tabTop && tS <= (float)this.height) {
            this.textAlign(37, 3);
            this.textFont(this.base_font);
            this.fill(textcolor);
            this.text(text, lS, tS, iW, tH);
        }
    }

    public void drawHeading(String text, float lS, float tS, float iW, float tH) {
        if (tS >= (float)this.tabTop && tS <= (float)this.height) {
            this.textAlign(3, 3);
            this.textFont(this.base_font);
            this.fill(this.c_sidebar_heading);
            this.text(text, lS, tS, iW, tH);
        }
    }

    public void drawButton(String text, int boxcolor, float lS, float tS, float iW, float iH, float tH) {
        this.drawButton(text, this.c_sidebar_text, boxcolor, lS, tS, iW, iH, tH);
    }

    public void drawButton(String text, int textcolor, int boxcolor, float lS, float tS, float iW, float iH, float tH) {
        if (tS >= (float)this.tabTop && tS <= (float)this.height) {
            this.rectMode(0);
            this.noStroke();
            this.textAlign(3, 3);
            this.textFont(this.base_font);
            this.fill(boxcolor);
            this.rect(lS, tS, iW, iH);
            this.fill(textcolor);
            this.text(text, lS, tS, iW, tH);
        }
    }

    public void drawDatabox(String text, float lS, float tS, float iW, float iH, float tH) {
        this.drawDatabox(text, this.c_sidebar_text, lS, tS, iW, iH, tH);
    }

    public void drawDatabox(String text, int textcolor, float lS, float tS, float iW, float iH, float tH) {
        if (tS >= (float)this.tabTop && tS <= (float)this.height) {
            this.rectMode(0);
            this.noStroke();
            this.textAlign(3, 3);
            this.textFont(this.base_font);
            this.fill(this.c_sidebar_button);
            this.rect(lS, tS, iW, iH);
            this.fill(this.c_sidebar);
            this.rect(lS + 1.0f * this.uimult, tS + 1.0f * this.uimult, iW - 2.0f * this.uimult, iH - 2.0f * this.uimult);
            this.fill(textcolor);
            this.text(this.constrainString(text, iW - 10.0f * this.uimult), lS, tS, iW, tH);
        }
    }

    public void drawRectangle(int boxcolor, float lS, float tS, float iW, float iH) {
        if (tS >= (float)this.tabTop && tS <= (float)this.height) {
            this.rectMode(0);
            this.noStroke();
            this.fill(boxcolor);
            this.rect(lS, tS, iW, iH);
        }
    }

    public void drawTriangle(int itemcolor, float x1, float y1, float x2, float y2, float x3, float y3) {
        if (y1 >= (float)this.tabTop && y1 <= (float)this.height && y2 >= (float)this.tabTop && y2 <= (float)this.height && y3 >= (float)this.tabTop && y3 <= (float)this.height) {
            this.noStroke();
            this.fill(itemcolor);
            this.triangle(x1, y1, x2, y2, x3, y3);
        }
    }

    public boolean menuYclick(int yPos, int topPos, int unitH, int itemH, float n) {
        return (float)yPos >= (float)topPos + (float)unitH * n && (float)yPos <= (float)topPos + (float)unitH * n + (float)itemH;
    }

    public boolean menuXclick(int xPos, int leftPos, int itemW) {
        return xPos >= leftPos && xPos <= leftPos + itemW;
    }

    public boolean menuXYclick(int xPos, int yPos, int topPos, int unitH, int itemH, float n, int leftPos, int unitW) {
        return (float)yPos >= (float)topPos + (float)unitH * n && (float)yPos <= (float)topPos + (float)unitH * n + (float)itemH && xPos >= leftPos && xPos <= leftPos + unitW;
    }

    public void drawMessageArea(String heading, String[] text, float lS, float rS, float tS, boolean alert) {
        this.rectMode(0);
        this.noStroke();
        this.textAlign(3, 3);
        this.textFont(this.base_font);
        int border = PApplet.parseInt((float)(this.uimult * 15.0f));
        int boxHeight = PApplet.parseInt((float)(30.0f * this.uimult)) + 2 * border;
        int boxWidth = PApplet.parseInt((float)(rS - lS));
        int[] itemHeight = new int[text.length];
        int largestWidth = 0;
        int i = 0;
        while (i < text.length) {
            itemHeight[i] = PApplet.parseInt((float)(22.0f * this.uimult));
            boxHeight += PApplet.parseInt((float)(22.0f * this.uimult));
            int textW = PApplet.parseInt((float)this.textWidth(text[i]));
            if (textW + 2 * border > largestWidth && textW + 2 * border < boxWidth) {
                largestWidth = PApplet.parseInt((float)((float)(textW + 2 * border) + 2.0f * this.uimult));
            } else if (textW + 2 * border > boxWidth) {
                largestWidth = boxWidth;
                boxHeight += PApplet.parseInt((float)(22.0f * this.uimult * (float)ProcessingGrapherexp3.ceil((float)(textW / (boxWidth - 2 * border)))));
                int n = i;
                itemHeight[n] = itemHeight[n] + PApplet.parseInt((float)(22.0f * this.uimult * (float)ProcessingGrapherexp3.ceil((float)(textW / (boxWidth - 2 * border)))));
            }
            ++i;
        }
        boxWidth = largestWidth;
        int verticalSum = PApplet.parseInt((float)(tS + (float)border + 25.0f * this.uimult));
        if (alert) {
            this.fill(this.c_white, 80.0f);
            this.rect(0.0f, 0.0f, this.width, this.height);
            if ((float)boxWidth < 300.0f * this.uimult) {
                boxWidth = PApplet.parseInt((float)(300.0f * this.uimult));
            }
            if ((float)boxHeight < 150.0f * this.uimult) {
                verticalSum += PApplet.parseInt((float)((150.0f * this.uimult - (float)boxHeight) / 2.0f));
                boxHeight = PApplet.parseInt((float)(150.0f * this.uimult));
            }
        }
        this.fill(this.c_message_box_outline);
        this.rect(PApplet.parseInt((float)((lS + rS) / 2.0f - (float)boxWidth / 2.0f - this.uimult * 2.0f)), tS - (float)PApplet.parseInt((float)(this.uimult * 2.0f)), boxWidth + PApplet.parseInt((float)(this.uimult * 4.0f)), boxHeight + PApplet.parseInt((float)(this.uimult * 4.0f)));
        if (alert) {
            this.fill(this.c_alert_message_box);
        } else {
            this.fill(this.c_info_message_box);
        }
        this.rect((lS + rS) / 2.0f - (float)boxWidth / 2.0f, tS, boxWidth, boxHeight);
        this.rectMode(0);
        this.fill(this.c_sidebar_heading);
        this.text(heading, PApplet.parseInt((float)((lS + rS) / 2.0f - (float)boxWidth / 2.0f + (float)border)), PApplet.parseInt((float)(tS + (float)border)), boxWidth - 2 * border, 20.0f * this.uimult);
        this.fill(this.c_sidebar_text);
        int i2 = 0;
        while (i2 < text.length) {
            if (alert && i2 == text.length - 1) {
                this.fill(this.c_lightgrey);
            }
            this.text(text[i2], PApplet.parseInt((float)((lS + rS) / 2.0f - (float)boxWidth / 2.0f + (float)border)), verticalSum, boxWidth - 2 * border, itemHeight[i2]);
            verticalSum += itemHeight[i2];
            ++i2;
        }
    }

    public void drawMessageArea(String heading, String[] text, float lS, float rS, float tS) {
        this.drawMessageArea(heading, text, lS, rS, tS, false);
    }

    public void drawAlert() {
        this.alertActive = true;
        String heading = "Info Message";
        String[] messages = ProcessingGrapherexp3.split((String)this.alertHeading, (char)'\n');
        if (messages.length > 1) {
            heading = messages[0];
            messages = this.remove(messages, 0);
        }
        messages = ProcessingGrapherexp3.append((String[])messages, (String)"");
        messages = ProcessingGrapherexp3.append((String[])messages, (String)"[Click to dismiss]");
        this.drawMessageArea(heading, messages, 50.0f * this.uimult, (float)this.width - 50.0f * this.uimult, (float)this.height / 2.5f - 150.0f * this.uimult / 2.0f, true);
    }

    public void alertMessage(String message) {
        if (message != null) {
            this.alertHeading = message;
            this.redrawAlert = true;
        }
    }

    public void mousePressed() {
        if (!this.alertActive) {
            if (this.mouseX > 0 && this.mouseX < PApplet.parseInt((float)((float)this.width - 150.0f * this.uimult)) && this.mouseY > PApplet.parseInt((float)(30.0f * this.uimult)) && this.mouseY < PApplet.parseInt((float)((float)this.height - 22.0f * this.uimult))) {
                if (this.tabObjects.size() > this.currentTab) {
                    TabAPI curTab = this.tabObjects.get(this.currentTab);
                    curTab.contentClick(this.mouseX, this.mouseY);
                } else {
                    this.currentTab = 0;
                }
            } else {
                this.cursor(0);
            }
            if (this.mouseY > 0 && (float)this.mouseY < 30.0f * this.uimult) {
                if (!this.settingsMenuActive && this.mouseX > this.width - PApplet.parseInt((float)(40.0f * this.uimult))) {
                    this.settingsMenuActive = true;
                    this.redrawUI = true;
                    this.settings.setVisibility(true);
                } else if (this.settingsMenuActive && this.mouseX > this.width - PApplet.parseInt((float)(150.0f * this.uimult))) {
                    this.settingsMenuActive = false;
                    this.settings.drawNewData();
                    this.settings.setVisibility(false);
                    this.redrawUI = true;
                } else {
                    int i = 0;
                    while (i < this.tabObjects.size()) {
                        if ((float)this.mouseX > (float)(i * 90) * this.uimult && (float)this.mouseX < (float)((i + 1) * 90) * this.uimult) {
                            this.tabObjects.get(this.currentTab).setVisibility(false);
                            this.tabObjects.get(i).setVisibility(true);
                            this.currentTab = i;
                            this.redrawContent = true;
                            this.redrawUI = true;
                        }
                        ++i;
                    }
                }
            } else if ((float)this.mouseY > (float)this.height - 22.0f * this.uimult && (float)this.mouseX < (float)this.width - 150.0f * this.uimult) {
                int sW = ProcessingGrapherexp3.round((float)(150.0f * this.uimult));
                int bW = ProcessingGrapherexp3.round((float)(70.0f * this.uimult));
                int pW = ProcessingGrapherexp3.round((float)(70.0f * this.uimult));
                int cW = ProcessingGrapherexp3.round((float)(22.0f * this.uimult));
                int cL = this.width - sW - pW - cW - bW - ProcessingGrapherexp3.round((float)(4.0f * this.uimult));
                int cR = this.width - sW - pW - bW - ProcessingGrapherexp3.round((float)(4.0f * this.uimult));
                int pL = this.width - sW - pW - bW - ProcessingGrapherexp3.round((float)(2.0f * this.uimult));
                int pR = this.width - sW - bW - ProcessingGrapherexp3.round((float)(2.0f * this.uimult));
                int bL = this.width - sW - bW - ProcessingGrapherexp3.round((float)(0.0f * this.uimult));
                int bR = this.width - sW - ProcessingGrapherexp3.round((float)(0.0f * this.uimult));
                if (this.mouseX >= cL && this.mouseX <= cR) {
                    ProcessingGrapherexp3.println((String)"conn/disc");
                    this.setupSerial();
                    this.redrawUI = true;
                    this.redrawContent = true;
                } else if (this.mouseX >= pL && this.mouseX <= pR) {
                    ProcessingGrapherexp3.println((String)"portsel");
                    this.currentTab = 0;
                    this.tabObjects.get(this.currentTab).setMenuLevel(1);
                    this.settingsMenuActive = false;
                    this.redrawContent = true;
                    this.redrawUI = true;
                } else if (this.mouseX >= bL && this.mouseX <= bR) {
                    ProcessingGrapherexp3.println((String)"baudr");
                    this.currentTab = 0;
                    this.tabObjects.get(this.currentTab).setMenuLevel(2);
                    this.settingsMenuActive = false;
                    this.redrawContent = true;
                    this.redrawUI = true;
                }
            } else if ((float)this.mouseX > (float)this.width - 150.0f * this.uimult && this.mouseX < this.width) {
                this.thread("menuClickEvent");
            }
        } else {
            this.alertActive = false;
            this.redrawUI = true;
            this.redrawContent = true;
        }
    }

    public void menuClickEvent() {
        if (this.settingsMenuActive) {
            this.settings.menuClick(this.mouseX, this.mouseY);
        } else if (this.tabObjects.size() > this.currentTab) {
            TabAPI curTab = this.tabObjects.get(this.currentTab);
            curTab.menuClick(this.mouseX, this.mouseY);
        } else {
            this.currentTab = 0;
        }
    }

    public void mouseReleased() {
        if (this.scrollingActive) {
            this.scrollingActive = false;
            this.cursor(0);
        }
    }

    public void mouseWheel(MouseEvent event) {
        int e = event.getCount();
        if (ProcessingGrapherexp3.abs((int)e) > 0) {
            TabAPI curTab;
            if (this.mouseX > 0 && this.mouseX < ProcessingGrapherexp3.round((float)((float)this.width - 150.0f * this.uimult)) && this.mouseY > ProcessingGrapherexp3.round((float)(30.0f * this.uimult)) && this.mouseY < ProcessingGrapherexp3.round((float)((float)this.height - 22.0f * this.uimult))) {
                if (this.tabObjects.size() > this.currentTab) {
                    curTab = this.tabObjects.get(this.currentTab);
                    curTab.scrollWheel(e);
                } else {
                    this.currentTab = 0;
                }
            }
            if ((float)this.mouseX > (float)this.width - 150.0f * this.uimult && this.mouseX < this.width) {
                if (this.settingsMenuActive) {
                    this.settings.scrollWheel(e);
                } else if (this.tabObjects.size() > this.currentTab) {
                    curTab = this.tabObjects.get(this.currentTab);
                    curTab.scrollWheel(e);
                } else {
                    this.currentTab = 0;
                }
            }
        }
    }

    public void startScrolling(boolean content, int cursorType) {
        this.scrollingActive = true;
        this.contentScrolling = content;
        if (cursorType == 1) {
            this.cursor(2);
        } else {
            this.cursor(12);
        }
    }

    public void startScrolling(boolean content) {
        this.startScrolling(content, 0);
    }

    public void keyTyped() {
        if (this.key == '\n' || this.key == '\r' || this.key == '\b' || this.key == '\u007f' || this.key == '\u001b') {
            return;
        }
        if (!this.controlKey) {
            if (this.settingsMenuActive && (float)this.mouseX >= (float)this.width - 150.0f * this.uimult) {
                this.settings.keyboardInput(this.key, this.keyCode == 0 ? this.key : this.keyCode, false);
            } else if (this.tabObjects.size() > this.currentTab) {
                TabAPI curTab = this.tabObjects.get(this.currentTab);
                curTab.keyboardInput(this.key, this.keyCode == 0 ? this.key : this.keyCode, false);
            } else {
                this.currentTab = 0;
            }
        }
    }

    public void keyPressed() {
        boolean coded;
        boolean bl = coded = this.key == '\uffff';
        if (this.keyCode == 10 || this.keyCode == 8 || this.keyCode == 27 || this.keyCode == 127) {
            coded = true;
        }
        if (this.keyCode == 27 && this.alertActive) {
            this.key = '\u0000';
            this.alertActive = false;
            this.redrawUI = true;
            this.redrawContent = true;
            return;
        }
        if (coded && this.keyCode == 17) {
            this.controlKey = true;
        } else if (this.controlKey && (this.key == '-' || this.key == '_' || this.keyCode == 45)) {
            if (this.uimult > 0.5f) {
                this.uiResize(-0.1f);
            }
        } else if (this.controlKey && (this.key == '=' || this.key == '+' || this.keyCode == 61)) {
            if (this.uimult < 2.0f) {
                this.uiResize(0.1f);
            }
        } else if (this.controlKey && (this.key == 'm' || this.key == 'M' || this.keyCode == 77) && this.serialConnected) {
            this.thread("serialSendDialog");
        } else if (this.controlKey && (this.key == 's' || this.key == 'S' || this.keyCode == 83)) {
            if (this.tabObjects.size() > this.currentTab) {
                TabAPI curTab = this.tabObjects.get(this.currentTab);
                curTab.keyboardInput(this.key, 115, true);
                this.controlKey = false;
            } else {
                this.currentTab = 0;
            }
        } else if (this.controlKey && (this.key == 'o' || this.key == 'O' || this.keyCode == 79)) {
            if (this.tabObjects.size() > this.currentTab) {
                TabAPI curTab = this.tabObjects.get(this.currentTab);
                curTab.keyboardInput(this.key, 116, true);
                this.controlKey = false;
            } else {
                this.currentTab = 0;
            }
        } else if (this.controlKey && (this.key == 'r' || this.key == 'R' || this.keyCode == 82)) {
            if (this.tabObjects.size() > this.currentTab) {
                TabAPI curTab = this.tabObjects.get(this.currentTab);
                curTab.keyboardInput(this.key, 117, true);
            } else {
                this.currentTab = 0;
            }
        } else if (this.controlKey && (this.key == 'q' || this.key == 'Q' || this.keyCode == 81)) {
            this.setupSerial();
            this.redrawUI = true;
            this.redrawContent = true;
        } else if (this.controlKey && (this.key == 'c' || this.key == 'C' || this.keyCode == 67)) {
            if (this.tabObjects.size() > this.currentTab) {
                TabAPI curTab = this.tabObjects.get(this.currentTab);
                curTab.keyboardInput(this.key, 65485, true);
            } else {
                this.currentTab = 0;
            }
        } else if (this.controlKey && (this.key == 'v' || this.key == 'V' || this.keyCode == 86)) {
            if (this.tabObjects.size() > this.currentTab) {
                TabAPI curTab = this.tabObjects.get(this.currentTab);
                curTab.keyboardInput(this.key, 65487, true);
            } else {
                this.currentTab = 0;
            }
        } else if (this.controlKey && (this.key == 'a' || this.key == 'A' || this.keyCode == 65)) {
            if (this.tabObjects.size() > this.currentTab) {
                TabAPI curTab = this.tabObjects.get(this.currentTab);
                curTab.keyboardInput(this.key, 256, true);
            } else {
                this.currentTab = 0;
            }
        } else if (this.controlKey && this.keyCode == 9) {
            ++this.currentTab;
            if (this.currentTab >= this.tabObjects.size()) {
                this.currentTab = 0;
            }
            this.redrawUI = true;
            this.redrawContent = true;
        } else if (coded) {
            if (this.settingsMenuActive && (this.keyCode == 27 || (float)this.mouseX >= (float)this.width - 150.0f * this.uimult)) {
                this.settings.keyboardInput(this.key, this.keyCode, true);
            } else if (this.tabObjects.size() > this.currentTab) {
                TabAPI curTab = this.tabObjects.get(this.currentTab);
                curTab.keyboardInput(this.key, this.keyCode, true);
            } else {
                this.currentTab = 0;
            }
        }
        if (this.keyCode == 27) {
            this.key = '\u0000';
        }
    }

    public void keyReleased() {
        if (this.key == '\uffff' && this.keyCode == 17) {
            this.controlKey = false;
        }
    }

    public String getStringClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        Object object = null;
        DataFlavor flavor = DataFlavor.stringFlavor;
        String clipboardText = "";
        if (contents != null && contents.isDataFlavorSupported(flavor)) {
            try {
                object = contents.getTransferData(flavor);
                clipboardText = (String)object;
            }
            catch (UnsupportedFlavorException e1) {
                ProcessingGrapherexp3.println((String)("Clipboard.getFromClipboard() >> Unsupported flavour: " + e1));
            }
            catch (IOException e2) {
                ProcessingGrapherexp3.println((String)("Clipboard.getFromClipboard() >> Unavailable data: " + e2));
            }
        }
        return clipboardText;
    }

    public void setupSerial() {
        if (!this.serialConnected) {
            String[] ports = Serial.list();
            if (ports.length == 0) {
                this.alertMessage("Error\nNo serial ports available");
            } else if (this.portNumber < 0 || ports.length <= this.portNumber) {
                this.alertMessage("Error\nInvalid port number selected");
            } else {
                try {
                    this.myPort = new Serial((PApplet)this, Serial.list()[this.portNumber], this.baudRate, this.serialParity, this.serialDatabits, this.serialStopbits);
                    this.currentPort = Serial.list()[this.portNumber];
                    if (this.lineEnding != '\u0000') {
                        this.myPort.bufferUntil((int)this.lineEnding);
                    } else {
                        this.myPort.buffer(1);
                    }
                    this.serialConnected = true;
                    for (TabAPI curTab : this.tabObjects) {
                        curTab.connectionEvent(true);
                    }
                    this.redrawUI = true;
                }
                catch (Exception e) {
                    this.alertMessage("Error\nUnable to connect to the port:\n" + e);
                }
            }
        } else {
            this.myPort.clear();
            this.myPort.stop();
            this.currentPort = "";
            this.serialConnected = false;
            for (TabAPI curTab : this.tabObjects) {
                curTab.connectionEvent(false);
            }
            this.redrawUI = true;
        }
    }

    public void serialEvent(Serial myPort) {
        try {
            if (this.recoo) {
                ProcessingGrapherexp3.println((String)"serev");
            } else {
                String inString = this.lineEnding != '\u0000' ? myPort.readStringUntil((int)this.lineEnding) : myPort.readString();
                ProcessingGrapherexp3.println((String)"ev");
                if (inString == null) {
                    return;
                }
                if ((inString = ProcessingGrapherexp3.trim((String)inString)).length() == 0) {
                    return;
                }
                boolean graphable = this.numberMessage(inString);
                for (TabAPI curTab : this.tabObjects) {
                    curTab.parsePortData(inString, graphable);
                }
            }
        }
        catch (Exception e) {
            this.alertMessage("Error\nUnable to read data from serial port:\n" + e);
        }
    }

    public void serialSend(String message) {
        if (this.serialConnected) {
            try {
                this.myPort.write(String.valueOf(message) + this.lineEnding);
            }
            catch (Exception e) {
                this.alertMessage("Error\nUnable to write to the serial port:\n" + e);
            }
        }
    }

    public void serialSendDialog() {
        String message = this.myShowInputDialog("Send a Serial Message", "", "");
        if (message != null) {
            this.serialSend(message);
        }
    }

    public void checkSerialPortList() {
        while (this.programActive) {
            try {
                boolean different = false;
                boolean currentPortExists = false;
                String[] currentList = Serial.list();
                if (currentList.length != this.portList.length) {
                    different = true;
                }
                int i = 0;
                while (i < currentList.length) {
                    if (i < this.portList.length && !currentList[i].equals(this.portList[i])) {
                        different = true;
                    }
                    if (this.currentPort.equals(currentList[i])) {
                        currentPortExists = true;
                        this.portNumber = i;
                    }
                    ++i;
                }
                if (this.serialConnected && !currentPortExists) {
                    this.setupSerial();
                    this.alertMessage("Error\nThe serial port has been disconnected");
                }
                if (different) {
                    this.redrawUI = true;
                }
                this.portList = currentList;
            }
            catch (Exception e) {
                ProcessingGrapherexp3.println((String)("Error in checkSerialPortList: " + e));
            }
            this.delay(1000);
        }
    }

    public String myShowInputDialog(final String heading, final String message, final String defaultText) {
        this.userInputString = "";
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ProcessingGrapherexp3.this.userInputString = ProcessingGrapherexp3.trim((String)FxDialogs.showTextInput(heading, message, defaultText));
            }
        });
        while (this.programActive && this.userInputString == "" && this.userInputString != null) {
            this.delay(200);
        }
        return this.userInputString;
    }

    public void fileSelected(File selection) {
        if (selection != null) {
            for (TabAPI curTab : this.tabObjects) {
                if (curTab.getOutput() != "") continue;
                String newFile = ProcessingGrapherexp3.join((String[])ProcessingGrapherexp3.split((String)selection.getAbsolutePath(), (char)'\\'), (String)"/");
                curTab.setOutput(newFile);
            }
        } else {
            for (TabAPI curTab : this.tabObjects) {
                if (curTab.getOutput() != "") continue;
                curTab.setOutput("No File Set");
            }
        }
        this.redrawUI = true;
    }

    public void selectOutput(String message, final String callbackMethod) {
        this.fileChooser.setTitle(message);
        if (this.currentDirectory != null) {
            this.fileChooser.setInitialDirectory(this.currentDirectory);
        }
        this.fileChooser.getExtensionFilters().clear();
        if (message.contains("CSV")) {
            this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Comma Separated", new String[]{"*.csv"}));
        } else if (message.contains("TXT")) {
            this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Text File", new String[]{"*.txt"}));
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                File file = ProcessingGrapherexp3.this.fileChooser.showSaveDialog((Window)ProcessingGrapherexp3.this.stage);
                ProcessingGrapherexp3.this.mySelectCallback(file, callbackMethod);
            }
        });
    }

    public void selectInput(String message, final String callbackMethod) {
        this.fileChooser.setTitle(message);
        if (this.currentDirectory != null) {
            this.fileChooser.setInitialDirectory(this.currentDirectory);
        }
        this.fileChooser.getExtensionFilters().clear();
        if (message.contains("CSV")) {
            this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Comma Separated", new String[]{"*.csv"}));
        } else if (message.contains("TXT")) {
            this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Text File", new String[]{"*.txt"}));
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                File file = ProcessingGrapherexp3.this.fileChooser.showOpenDialog((Window)ProcessingGrapherexp3.this.stage);
                ProcessingGrapherexp3.this.mySelectCallback(file, callbackMethod);
            }
        });
    }

    public void mySelectCallback(File selectedFile, String callbackMethod) {
        try {
            Class<?> callbackClass = ((Object)((Object)this)).getClass();
            Method selectMethod = callbackClass.getMethod(callbackMethod, File.class);
            selectMethod.invoke((Object)this, selectedFile);
            if (selectedFile != null) {
                this.currentDirectory = selectedFile.getParentFile();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(String.valueOf(callbackMethod) + "() must be public");
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(String.valueOf(callbackMethod) + "() could not be found");
        }
    }

    public float ceilToSigFig(float num, int n) {
        return (float)this.ceilToSigFig((double)num, n);
    }

    public double ceilToSigFig(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = (long)Math.ceil(num * magnitude);
        return (double)shifted / magnitude;
    }

    public float floorToSigFig(float num, int n) {
        return (float)this.floorToSigFig((double)num, n);
    }

    public double floorToSigFig(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = (long)Math.floor(num * magnitude);
        return (double)shifted / magnitude;
    }

    public float roundToSigFig(float num, int n) {
        return (float)this.roundToSigFig((double)num, n);
    }

    public double roundToSigFig(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public String[] remove(String[] a, int index) {
        int i = index + 1;
        while (i < a.length) {
            a[i - 1] = a[i];
            ++i;
        }
        return ProcessingGrapherexp3.shorten((String[])a);
    }

    public boolean numberMessage(String msg) {
        int i = 0;
        while (i < msg.length() - 1) {
            char j = msg.charAt(i);
            if ((j < '+' && j != ' ' || j > '9' || j == '/') && j != this.separator) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String constrainString(String inputText, float maxWidth) {
        if (this.textWidth(inputText) > maxWidth) {
            while (this.textWidth(".." + inputText) > maxWidth && inputText.length() > 1) {
                inputText = inputText.substring(1, inputText.length());
            }
            inputText = ".." + inputText;
        }
        return inputText;
    }

    public void loadColorScheme(int mode) {
        switch (mode) {
            case 0: {
                this.c_background = this.color(255, 255, 255);
                this.c_tabbar = this.color(229, 229, 229);
                this.c_tabbar_h = this.color(217, 217, 217);
                this.c_idletab = this.color(240, 240, 240);
                this.c_tabbar_text = this.color(50, 50, 50);
                this.c_idletab_text = this.color(140, 140, 140);
                this.c_sidebar = this.color(229, 229, 229);
                this.c_sidebar_h = this.color(217, 217, 217);
                this.c_sidebar_heading = this.color(34, 142, 195);
                this.c_sidebar_text = this.color(50, 50, 50);
                this.c_sidebar_button = this.color(255, 255, 255);
                this.c_sidebar_divider = this.color(217, 217, 217);
                this.c_sidebar_accent = this.color(255, 108, 160);
                this.c_terminal_text = this.color(136, 136, 136);
                this.c_message_text = this.c_grey;
                this.c_graph_axis = this.color(150, 150, 150);
                this.c_graph_border = this.c_graph_gridlines = this.color(229, 229, 229);
                this.c_serial_message_box = this.c_idletab;
                this.c_message_box_outline = this.c_tabbar_h;
                this.c_alert_message_box = this.c_tabbar;
                this.c_info_message_box = this.color(229, 229, 229);
                this.c_status_bar = this.c_message_text;
                this.c_highlight_background = this.c_tabbar;
                break;
            }
            case 1: {
                this.c_background = this.color(40, 44, 52);
                this.c_tabbar = this.color(24, 26, 31);
                this.c_tabbar_h = this.color(19, 19, 28);
                this.c_idletab = this.color(33, 36, 43);
                this.c_tabbar_text = this.c_white;
                this.c_idletab_text = this.color(152, 152, 152);
                this.c_sidebar = this.color(24, 26, 31);
                this.c_sidebar_h = this.color(55, 56, 60);
                this.c_sidebar_heading = this.color(97, 175, 239);
                this.c_sidebar_text = this.c_white;
                this.c_sidebar_button = this.color(76, 77, 81);
                this.c_sidebar_divider = this.c_grey;
                this.c_sidebar_accent = this.c_red;
                this.c_terminal_text = this.color(171, 178, 191);
                this.c_message_text = this.c_white;
                this.c_graph_axis = this.c_lightgrey;
                this.c_graph_gridlines = this.c_darkgrey;
                this.c_graph_border = this.color(60, 64, 73);
                this.c_serial_message_box = this.c_idletab;
                this.c_message_box_outline = this.c_tabbar_h;
                this.c_alert_message_box = this.c_tabbar;
                this.c_info_message_box = this.c_tabbar;
                this.c_status_bar = this.c_terminal_text;
                this.c_highlight_background = this.color(61, 67, 80);
                break;
            }
            default: {
                this.c_background = this.color(40, 41, 35);
                this.c_tabbar = this.color(24, 25, 21);
                this.c_tabbar_h = this.color(19, 19, 18);
                this.c_idletab = this.color(32, 33, 28);
                this.c_tabbar_text = this.c_white;
                this.c_idletab_text = this.color(152, 152, 152);
                this.c_sidebar = this.c_tabbar;
                this.c_sidebar_h = this.c_tabbar_h;
                this.c_sidebar_heading = this.color(103, 216, 239);
                this.c_sidebar_text = this.c_white;
                this.c_sidebar_button = this.color(92, 93, 90);
                this.c_sidebar_divider = this.c_grey;
                this.c_sidebar_accent = this.c_red;
                this.c_terminal_text = this.c_lightgrey;
                this.c_message_text = this.c_white;
                this.c_graph_axis = this.c_lightgrey;
                this.c_graph_border = this.c_graph_gridlines = this.c_darkgrey;
                this.c_serial_message_box = this.c_darkgrey;
                this.c_message_box_outline = this.c_tabbar_h;
                this.c_alert_message_box = this.c_tabbar;
                this.c_info_message_box = this.c_darkgrey;
                this.c_status_bar = this.c_lightgrey;
                this.c_highlight_background = this.c_tabbar;
            }
        }
        this.redrawUI = true;
        this.redrawContent = true;
    }

    public void settings() {
        this.size(1000, 700, "processing.javafx.PGraphicsFX2D");
        this.smooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"ProcessingGrapherexp3"};
        if (passedArgs != null) {
            PApplet.main((String[])ProcessingGrapherexp3.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class CustomTable
    extends Table {
        protected boolean csvStreamActive = false;
        protected PrintWriter csvWriter;

        CustomTable() {
        }

        public boolean openCSVoutput(String filename) {
            try {
                File outputFile = ProcessingGrapherexp3.this.saveFile(filename);
                this.csvWriter = PApplet.createWriter((File)outputFile);
                if (this.hasColumnTitles()) {
                    int col = 0;
                    while (col < this.getColumnCount()) {
                        if (col != 0) {
                            this.csvWriter.print(',');
                        }
                        try {
                            if (this.getColumnTitle(col) != null) {
                                this.writeEntryCSV(this.csvWriter, this.getColumnTitle(col));
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            PApplet.printArray((Object)this.getColumnTitles());
                            PApplet.printArray((Object)this.columns);
                            throw e;
                        }
                        ++col;
                    }
                    this.csvWriter.println();
                }
                this.csvStreamActive = true;
                return true;
            }
            catch (Exception e) {
                ProcessingGrapherexp3.println((String)("Error opening up CSV output file stream: " + e));
                ProcessingGrapherexp3.this.printStackTrace(e);
                return false;
            }
        }

        public boolean saveCSVentries(int indexA, int indexB) {
            if (!this.csvStreamActive) {
                ProcessingGrapherexp3.println((String)"Error saving CSV entries; the output stream hasn't been initialised");
                return false;
            }
            if (indexA < 0 || indexB >= this.rowCount || indexA > indexB) {
                ProcessingGrapherexp3.println((String)"Error saving CSV entries; the index parameters are out of bounds");
                return false;
            }
            try {
                int row = indexA;
                while (row < indexB + 1) {
                    int col = 0;
                    while (col < this.getColumnCount()) {
                        String entry;
                        if (col != 0) {
                            this.csvWriter.print(',');
                        }
                        if ((entry = this.getString(row, col)) != null) {
                            this.writeEntryCSV(this.csvWriter, entry);
                        }
                        ++col;
                    }
                    this.csvWriter.println();
                    ++row;
                }
                return !this.csvWriter.checkError();
            }
            catch (Exception e) {
                ProcessingGrapherexp3.println((String)("Error saving CSV entries " + e));
                ProcessingGrapherexp3.this.printStackTrace(e);
                return false;
            }
        }

        public boolean closeCSVoutput() {
            if (this.csvStreamActive) {
                this.csvStreamActive = false;
                if (this.csvWriter.checkError()) {
                    this.csvWriter.close();
                    return false;
                }
                this.csvWriter.close();
            }
            return true;
        }
    }

    public class DisposeHandler {
        DisposeHandler(PApplet pa) {
            pa.registerMethod("dispose", (Object)this);
        }

        public void dispose() {
            ProcessingGrapherexp3.this.exit();
        }
    }

    class FileGraph
    implements TabAPI {
        int cL;
        int cR;
        int cT;
        int cB;
        int xData;
        Graph graph;
        int menuScroll;
        int menuHeight;
        int menuLevel;
        ScrollBar sidebarScroll;
        String name;
        String outputfile;
        String currentfile;
        Table dataTable;
        ArrayList<DataSignal> dataSignals;
        int previousColor;
        int hueColor;
        int newColor;
        int colorSelector;
        boolean saveFilePath;
        boolean changesMade;
        boolean labelling;
        boolean zoomActive;
        boolean workerActive;
        boolean tabIsVisible;
        int setZoomSize;
        int selectedSignal;
        float[] zoomCoordOne;

        FileGraph(String setname, int left, int right, int top, int bottom) {
            this.sidebarScroll = new ScrollBar(false, false);
            this.dataSignals = new ArrayList();
            this.previousColor = ProcessingGrapherexp3.this.c_red;
            this.hueColor = ProcessingGrapherexp3.this.c_red;
            this.newColor = ProcessingGrapherexp3.this.c_red;
            this.colorSelector = 0;
            this.saveFilePath = false;
            this.zoomCoordOne = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            this.name = setname;
            this.cL = left;
            this.cR = right;
            this.cT = top;
            this.cB = bottom;
            this.xData = -1;
            this.graph = new Graph(this.cL, this.cR, this.cT, this.cB, 0.0f, 100.0f, 0.0f, 10.0f, "Graph 1");
            this.graph.scale(ProcessingGrapherexp3.this.uimult);
            this.graph.selected(true);
            this.outputfile = "No File Set";
            this.currentfile = "No File Set";
            this.tabIsVisible = false;
            this.zoomActive = false;
            this.setZoomSize = -1;
            this.labelling = false;
            this.menuScroll = 0;
            this.menuHeight = this.cB - this.cT - 1;
            this.menuLevel = 0;
            this.changesMade = false;
            this.selectedSignal = 0;
            this.workerActive = false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setVisibility(boolean newState) {
            this.tabIsVisible = newState;
        }

        @Override
        public void setMenuLevel(int newLevel) {
            this.menuLevel = newLevel;
        }

        @Override
        public void drawContent() {
            if (this.workerActive) {
                String[] message = new String[]{"Loading in progress!"};
                ProcessingGrapherexp3.this.drawMessageArea("Please Standby", message, (float)this.cL + 60.0f * ProcessingGrapherexp3.this.uimult, (float)this.cR - 60.0f * ProcessingGrapherexp3.this.uimult, (float)this.cT + 30.0f * ProcessingGrapherexp3.this.uimult);
            } else if (this.currentfile == "No File Set") {
                this.graph.drawGrid();
                if (ProcessingGrapherexp3.this.showInstructions) {
                    String[] message = new String[]{"1. Click 'Open CSV File' to open and plot the signals from a *.CSV file", "2. The first row of the file should contain headings for each of the signal", "3. If the heading starts with 'x:', this column will be used as the x-axis"};
                    ProcessingGrapherexp3.this.drawMessageArea("Getting Started", message, (float)this.cL + 60.0f * ProcessingGrapherexp3.this.uimult, (float)this.cR - 60.0f * ProcessingGrapherexp3.this.uimult, (float)this.cT + 30.0f * ProcessingGrapherexp3.this.uimult);
                }
            } else {
                this.plotFileData();
            }
        }

        @Override
        public void drawNewData() {
        }

        @Override
        public void changeSize(int newL, int newR, int newT, int newB) {
            this.cL = newL;
            this.cR = newR;
            this.cT = newT;
            this.cB = newB;
            this.graph.scale(ProcessingGrapherexp3.this.uimult);
            this.graph.setSize(this.cL, this.cR, this.cT, this.cB);
        }

        @Override
        public void setOutput(String newoutput) {
            if (newoutput != "No File Set") {
                if (this.saveFilePath) {
                    int dotPos = newoutput.lastIndexOf(".");
                    if (dotPos > 0) {
                        newoutput = newoutput.substring(0, dotPos);
                    }
                    if (ProcessingGrapherexp3.this.saveFile(newoutput = String.valueOf(newoutput) + ".csv") == null) {
                        ProcessingGrapherexp3.this.alertMessage("Error\nUnable to access the selected output file location; perhaps this location is write-protected?\n" + newoutput);
                        newoutput = "No File Set";
                    }
                    this.outputfile = newoutput;
                    this.saveData();
                } else if (newoutput.contains(".csv")) {
                    this.currentfile = newoutput;
                    this.outputfile = "No File Set";
                    this.xData = -1;
                    this.workerActive = true;
                    WorkerThread loadingThread = new WorkerThread();
                    loadingThread.loadFile();
                    this.zoomActive = false;
                    this.changesMade = false;
                } else {
                    ProcessingGrapherexp3.this.alertMessage("Error\nInvalid file type; it must be *.csv");
                    this.outputfile = "No File Set";
                    this.zoomActive = false;
                }
            } else {
                this.outputfile = newoutput;
                this.zoomActive = false;
            }
            ProcessingGrapherexp3.this.redrawContent = true;
        }

        public void plotFileData() {
            if (this.currentfile != "No File Set" && this.currentfile != "" && this.dataTable.getColumnCount() > 0) {
                this.xData = -1;
                int i = 0;
                while (i < this.dataTable.getColumnCount()) {
                    String columnTitle = this.dataTable.getColumnTitle(i);
                    if (columnTitle.contains("x:") || columnTitle.contains("X:")) {
                        this.xData = i;
                    } else if (columnTitle.contains("l:")) {
                        columnTitle = ProcessingGrapherexp3.split((String)columnTitle, (char)':')[1];
                    }
                    boolean signalCheck = false;
                    for (DataSignal curSig : this.dataSignals) {
                        if (!curSig.signalText.equals(columnTitle)) continue;
                        signalCheck = true;
                    }
                    if (!signalCheck) {
                        this.dataSignals.add(new DataSignal(columnTitle, ProcessingGrapherexp3.this.c_colorlist[i % ProcessingGrapherexp3.this.c_colorlist.length]));
                    }
                    ++i;
                }
                ProcessingGrapherexp3.this.redrawUI = true;
                if (this.xData == -1) {
                    this.graph.xAxisTitle("Time (s)");
                } else {
                    try {
                        String xAxisName = ProcessingGrapherexp3.split((String)this.dataTable.getColumnTitle(this.xData), (char)':')[1];
                        this.graph.xAxisTitle(xAxisName);
                    }
                    catch (Exception e) {
                        ProcessingGrapherexp3.println((String)("Error when trying to set X-axis name: " + e));
                    }
                }
                if (this.dataTable.getRowCount() > 0 && (this.xData != 0 || this.dataTable.getColumnCount() != 1)) {
                    double maxy;
                    double miny;
                    double maxx;
                    double minx;
                    if (this.xData == -1) {
                        minx = 0.0;
                        maxx = 0.0;
                        miny = this.dataTable.getDouble(0, 0);
                        maxy = this.dataTable.getDouble(0, 0);
                    } else {
                        minx = this.dataTable.getDouble(0, this.xData);
                        maxx = this.dataTable.getDouble(0, this.xData);
                        if (this.xData == 0) {
                            miny = this.dataTable.getDouble(0, 1);
                            maxy = this.dataTable.getDouble(0, 1);
                        } else {
                            miny = this.dataTable.getDouble(0, 0);
                            maxy = this.dataTable.getDouble(0, 0);
                        }
                    }
                    for (TableRow row : this.dataTable.rows()) {
                        if (this.xData != -1) {
                            if (minx > row.getDouble(this.xData)) {
                                minx = row.getDouble(this.xData);
                            }
                            if (maxx < row.getDouble(this.xData)) {
                                maxx = row.getDouble(this.xData);
                            }
                        } else {
                            maxx += (double)(1.0f / this.graph.frequency());
                        }
                        int i2 = 0;
                        while (i2 < this.dataTable.getColumnCount()) {
                            if (i2 != this.xData && !this.dataTable.getColumnTitle(i2).contains("l:")) {
                                if (miny > row.getDouble(i2)) {
                                    miny = row.getDouble(i2);
                                }
                                if (maxy < row.getDouble(i2)) {
                                    maxy = row.getDouble(i2);
                                }
                            }
                            ++i2;
                        }
                    }
                    if (!this.zoomActive) {
                        this.graph.limits((float)ProcessingGrapherexp3.this.floorToSigFig(minx, 2), (float)ProcessingGrapherexp3.this.ceilToSigFig(maxx, 2), (float)ProcessingGrapherexp3.this.floorToSigFig(miny, 2), (float)ProcessingGrapherexp3.this.ceilToSigFig(maxy, 2));
                    }
                    this.graph.reset();
                    this.graph.drawGrid();
                    int counter = 0;
                    int percentage = 0;
                    for (TableRow row : this.dataTable.rows()) {
                        int i3;
                        float value = (float)counter / PApplet.parseFloat((int)this.dataTable.getRowCount());
                        if (percentage < PApplet.parseInt((float)(value * 100.0f))) {
                            percentage = PApplet.parseInt((float)(value * 100.0f));
                        }
                        if (this.xData != -1) {
                            i3 = 0;
                            while (i3 < this.dataTable.getColumnCount()) {
                                if (i3 != this.xData) {
                                    try {
                                        double dataX = row.getDouble(this.xData);
                                        double dataPoint = row.getDouble(i3);
                                        if (Double.isNaN(dataX) || Double.isNaN(dataPoint)) {
                                            dataX = 3.4028234663852886E38;
                                            dataPoint = 3.4028234663852886E38;
                                        }
                                        if (dataX >= (double)this.graph.xMin() && dataX <= (double)this.graph.xMax()) {
                                            if (this.dataTable.getColumnTitle(i3).contains("l:")) {
                                                if (dataPoint == 1.0) {
                                                    this.graph.xLabel((float)dataX, this.dataSignals.get((int)i3).signalColor);
                                                }
                                            } else {
                                                this.graph.plotData((float)dataX, (float)dataPoint, i3, this.dataSignals.get((int)i3).signalColor);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        ProcessingGrapherexp3.println((String)"Error trying to plot file data.");
                                        ProcessingGrapherexp3.println((Object)e);
                                    }
                                }
                                ++i3;
                            }
                        } else {
                            i3 = 0;
                            while (i3 < this.dataTable.getColumnCount()) {
                                try {
                                    float currentX = (float)counter / this.graph.frequency();
                                    if (currentX >= this.graph.xMin() && currentX <= this.graph.xMax()) {
                                        double dataPoint = row.getDouble(i3);
                                        if (Double.isNaN(dataPoint)) {
                                            dataPoint = 3.4028234663852886E38;
                                        }
                                        if (this.dataTable.getColumnTitle(i3).contains("l:")) {
                                            if (dataPoint == 1.0) {
                                                this.graph.xLabel(currentX, this.dataSignals.get((int)i3).signalColor);
                                            }
                                        } else {
                                            this.graph.plotData(currentX, (float)dataPoint, i3, this.dataSignals.get((int)i3).signalColor);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    ProcessingGrapherexp3.println((String)"Error trying to plot file data.");
                                    ProcessingGrapherexp3.println((Object)e);
                                }
                                ++i3;
                            }
                        }
                        ++counter;
                    }
                }
            }
        }

        @Override
        public String getOutput() {
            return this.outputfile;
        }

        public void saveData() {
            if (this.outputfile != "No File Set" && this.outputfile != "" && this.currentfile != "No File Set") {
                try {
                    ProcessingGrapherexp3.this.saveTable(this.dataTable, this.outputfile, "csv");
                    this.currentfile = this.outputfile;
                    this.saveFilePath = false;
                    ProcessingGrapherexp3.this.redrawUI = true;
                    ProcessingGrapherexp3.this.alertMessage("Success!\nThe data has been saved to the file");
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.this.alertMessage("Error\nUnable to save file:\n" + e);
                }
                this.outputfile = "No File Set";
            }
        }

        @Override
        public void drawSidebar() {
            int i;
            int sT = this.cT;
            int sL = this.cR;
            int sW = ProcessingGrapherexp3.this.width - this.cR;
            int sH = ProcessingGrapherexp3.this.height - sT;
            int uH = ProcessingGrapherexp3.round((float)(30.0f * ProcessingGrapherexp3.this.uimult));
            int tH = ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult));
            int iH = ProcessingGrapherexp3.round((float)(25.0f * ProcessingGrapherexp3.this.uimult));
            int iL = ProcessingGrapherexp3.round((float)((float)sL + 10.0f * ProcessingGrapherexp3.this.uimult));
            int iW = ProcessingGrapherexp3.round((float)((float)sW - 20.0f * ProcessingGrapherexp3.this.uimult));
            Filters filterClass = new Filters();
            if (this.menuLevel == 0) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((15 + this.dataSignals.size()) * uH));
                if (this.xData != -1) {
                    this.menuHeight -= uH;
                }
            } else if (this.menuLevel == 1) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((3 + this.dataSignals.size()) * uH));
                if (this.xData != -1) {
                    this.menuHeight -= uH;
                }
            } else if (this.menuLevel == 2) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((3 + filterClass.filterList.length) * uH));
            } else if (this.menuLevel == 3) {
                this.menuHeight = ProcessingGrapherexp3.round((float)(9 * uH + iW));
            }
            if (this.menuHeight > sH) {
                if (this.menuScroll == -1) {
                    this.menuScroll = 0;
                } else if (this.menuScroll > this.menuHeight - sH) {
                    this.menuScroll = this.menuHeight - sH;
                }
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_serial_message_box);
                ProcessingGrapherexp3.this.rect(ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sH);
                int scrollbarSize = sH - ProcessingGrapherexp3.round((float)((float)sH * PApplet.parseFloat((int)(this.menuHeight - sH)) / (float)this.menuHeight));
                if (scrollbarSize < uH) {
                    scrollbarSize = uH;
                }
                int scrollbarOffset = ProcessingGrapherexp3.round((float)((float)(sH - scrollbarSize) * ((float)this.menuScroll / PApplet.parseFloat((int)(this.menuHeight - sH)))));
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.rect(ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT + scrollbarOffset, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, scrollbarSize);
                this.sidebarScroll.update(this.menuHeight, sH, ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT + scrollbarOffset, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, scrollbarSize);
                sT -= this.menuScroll;
                sL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
                iL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
            } else {
                this.menuScroll = -1;
            }
            if (this.menuLevel == 0) {
                ProcessingGrapherexp3.this.drawHeading("Analyse Data", iL, sT + uH * 0, iW, tH);
                ProcessingGrapherexp3.this.drawButton("Open CSV File", ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 1, iW, iH, tH);
                if (this.currentfile != "" && this.currentfile != "No File Set" && this.changesMade) {
                    ProcessingGrapherexp3.this.drawButton("Save Changes", ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 2, iW, iH, tH);
                } else {
                    ProcessingGrapherexp3.this.drawDatabox("Save Changes", ProcessingGrapherexp3.this.c_idletab_text, iL, sT + uH * 2, iW, iH, tH);
                }
                ProcessingGrapherexp3.this.drawHeading("Data Manipulation", iL, (float)sT + (float)uH * 3.5f, iW, tH);
                if (this.currentfile != "" && this.currentfile != "No File Set") {
                    ProcessingGrapherexp3.this.drawButton("Add a Label", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 4.5f, iW, iH, tH);
                    ProcessingGrapherexp3.this.drawButton("Apply a Filter", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 5.5f, iW, iH, tH);
                } else {
                    ProcessingGrapherexp3.this.drawDatabox("Add a Label", ProcessingGrapherexp3.this.c_idletab_text, iL, (float)sT + (float)uH * 4.5f, iW, iH, tH);
                    ProcessingGrapherexp3.this.drawDatabox("Apply a Filter", ProcessingGrapherexp3.this.c_idletab_text, iL, (float)sT + (float)uH * 5.5f, iW, iH, tH);
                }
                ProcessingGrapherexp3.this.drawHeading("Graph Options", iL, sT + uH * 7, iW, tH);
                ProcessingGrapherexp3.this.drawButton("Line", this.graph.graphType() == 0 ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 8, iW / 3, iH, tH);
                ProcessingGrapherexp3.this.drawButton("Dots", this.graph.graphType() == 1 ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL + iW / 3, sT + uH * 8, iW / 3, iH, tH);
                ProcessingGrapherexp3.this.drawButton("Bar", this.graph.graphType() == 2 ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL + iW * 2 / 3, sT + uH * 8, iW / 3, iH, tH);
                ProcessingGrapherexp3.this.drawRectangle(ProcessingGrapherexp3.this.c_sidebar_divider, iL + iW / 3, (float)(sT + uH * 8) + 1.0f * ProcessingGrapherexp3.this.uimult, 1.0f * ProcessingGrapherexp3.this.uimult, (float)iH - 2.0f * ProcessingGrapherexp3.this.uimult);
                ProcessingGrapherexp3.this.drawRectangle(ProcessingGrapherexp3.this.c_sidebar_divider, iL + iW * 2 / 3, (float)(sT + uH * 8) + 1.0f * ProcessingGrapherexp3.this.uimult, 1.0f * ProcessingGrapherexp3.this.uimult, (float)iH - 2.0f * ProcessingGrapherexp3.this.uimult);
                ProcessingGrapherexp3.this.drawDatabox(ProcessingGrapherexp3.str((float)this.graph.xMin()).replaceAll("[0]+$", "").replaceAll("[.]+$", ""), iL, sT + uH * 9, (float)(iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                ProcessingGrapherexp3.this.drawButton("x", ProcessingGrapherexp3.this.c_sidebar_button, (float)(iL + iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, sT + uH * 9, 12.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox(ProcessingGrapherexp3.str((float)this.graph.xMax()).replaceAll("[0]+$", "").replaceAll("[.]+$", ""), (float)(iL + iW / 2) + 6.0f * ProcessingGrapherexp3.this.uimult, sT + uH * 9, (float)(iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox(ProcessingGrapherexp3.str((float)this.graph.yMin()).replaceAll("[0]+$", "").replaceAll("[.]+$", ""), iL, sT + uH * 10, (float)(iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                ProcessingGrapherexp3.this.drawButton("y", ProcessingGrapherexp3.this.c_sidebar_button, (float)(iL + iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, sT + uH * 10, 12.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox(ProcessingGrapherexp3.str((float)this.graph.yMax()).replaceAll("[0]+$", "").replaceAll("[.]+$", ""), (float)(iL + iW / 2) + 6.0f * ProcessingGrapherexp3.this.uimult, sT + uH * 10, (float)(iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                if (this.currentfile != "" && this.currentfile != "No File Set") {
                    ProcessingGrapherexp3.this.drawButton("Zoom", this.setZoomSize >= 0 ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 11, iW / 2, iH, tH);
                    ProcessingGrapherexp3.this.drawButton("Reset", this.zoomActive ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL + iW / 2, sT + uH * 11, iW / 2, iH, tH);
                    ProcessingGrapherexp3.this.drawRectangle(ProcessingGrapherexp3.this.c_sidebar_divider, iL + iW / 2, (float)(sT + uH * 11) + 1.0f * ProcessingGrapherexp3.this.uimult, 1.0f * ProcessingGrapherexp3.this.uimult, (float)iH - 2.0f * ProcessingGrapherexp3.this.uimult);
                } else {
                    ProcessingGrapherexp3.this.drawDatabox("Zoom", ProcessingGrapherexp3.this.c_idletab_text, iL, sT + uH * 11, iW / 2, iH, tH);
                    ProcessingGrapherexp3.this.drawDatabox("Reset", ProcessingGrapherexp3.this.c_idletab_text, iL + iW / 2, sT + uH * 11, iW / 2, iH, tH);
                }
                ProcessingGrapherexp3.this.drawHeading("Data Format", iL, (float)sT + (float)uH * 12.5f, iW, tH);
                if (this.xData != -1) {
                    ProcessingGrapherexp3.this.drawButton("X: " + ProcessingGrapherexp3.split((String)this.dataSignals.get((int)this.xData).signalText, (char)':')[1], ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 13.5f, iW, iH, tH);
                } else {
                    ProcessingGrapherexp3.this.drawDatabox("Rate: " + this.graph.frequency() + "Hz", iL, (float)sT + (float)uH * 13.5f, iW, iH, tH);
                }
                float tHnow = 14.5f;
                i = 0;
                while (i < this.dataSignals.size()) {
                    if (i != this.xData) {
                        ProcessingGrapherexp3.this.drawDatabox(this.dataSignals.get((int)i).signalText, iL, (float)sT + (float)uH * tHnow, (float)iW - 40.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                        ProcessingGrapherexp3.this.drawButton("\u2715", ProcessingGrapherexp3.this.c_sidebar_button, (float)(iL + iW) - 20.0f * ProcessingGrapherexp3.this.uimult, (float)sT + (float)uH * tHnow, 20.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                        int buttonColor = this.dataSignals.get((int)i).signalColor;
                        ProcessingGrapherexp3.this.drawButton("", buttonColor, (float)(iL + iW) - 40.0f * ProcessingGrapherexp3.this.uimult, (float)sT + (float)uH * tHnow, 20.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                        ProcessingGrapherexp3.this.drawRectangle(ProcessingGrapherexp3.this.c_sidebar_divider, (float)(iL + iW) - 20.0f * ProcessingGrapherexp3.this.uimult, (float)sT + (float)uH * tHnow + 1.0f * ProcessingGrapherexp3.this.uimult, 1.0f * ProcessingGrapherexp3.this.uimult, (float)iH - 2.0f * ProcessingGrapherexp3.this.uimult);
                        tHnow += 1.0f;
                    }
                    ++i;
                }
            } else if (this.menuLevel == 1) {
                ProcessingGrapherexp3.this.drawHeading("Select a Signal", iL, sT + uH * 0, iW, tH);
                float tHnow = 1.0f;
                if (this.dataSignals.size() == 0 || this.dataSignals.size() == 1 && this.xData != -1) {
                    ProcessingGrapherexp3.this.drawText("No signals available", ProcessingGrapherexp3.this.c_sidebar_text, iL, (float)sT + (float)uH * tHnow, iW, iH);
                    tHnow += 1.0f;
                } else {
                    i = 0;
                    while (i < this.dataSignals.size()) {
                        if (i != this.xData && !this.dataTable.getColumnTitle(i).contains("l:")) {
                            ProcessingGrapherexp3.this.drawButton(ProcessingGrapherexp3.this.constrainString(this.dataSignals.get((int)i).signalText, (float)iW - 10.0f * ProcessingGrapherexp3.this.uimult), ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * tHnow, iW, iH, tH);
                            tHnow += 1.0f;
                        }
                        ++i;
                    }
                }
                ProcessingGrapherexp3.this.drawButton("Cancel", ProcessingGrapherexp3.this.c_sidebar_accent, iL, (float)sT + (float)uH * (tHnow += 0.5f), iW, iH, tH);
            } else if (this.menuLevel == 2) {
                ProcessingGrapherexp3.this.drawHeading("Select a Filter", iL, sT + uH * 0, iW, tH);
                float tHnow = 1.0f;
                if (filterClass.filterList.length == 0) {
                    ProcessingGrapherexp3.this.drawText("No filters available", ProcessingGrapherexp3.this.c_sidebar_text, iL, (float)sT + (float)uH * tHnow, iW, iH);
                    tHnow += 1.0f;
                } else {
                    i = 0;
                    while (i < filterClass.filterList.length) {
                        String filterName = filterClass.filterList[i];
                        if (filterName.contains("h:")) {
                            filterName = ProcessingGrapherexp3.split((String)filterName, (String)":")[1];
                            ProcessingGrapherexp3.this.drawText(filterName, ProcessingGrapherexp3.this.c_idletab_text, iL, (float)sT + (float)uH * tHnow, iW, iH);
                        } else {
                            ProcessingGrapherexp3.this.drawButton(ProcessingGrapherexp3.this.constrainString(filterClass.filterList[i], (float)iW - 10.0f * ProcessingGrapherexp3.this.uimult), ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * tHnow, iW, iH, tH);
                        }
                        tHnow += 1.0f;
                        ++i;
                    }
                }
                ProcessingGrapherexp3.this.drawButton("Cancel", ProcessingGrapherexp3.this.c_sidebar_accent, iL, (float)sT + (float)uH * (tHnow += 0.5f), iW, iH, tH);
            }
        }

        @Override
        public void drawInfoBar() {
            int sW = ProcessingGrapherexp3.this.width - this.cR;
            ProcessingGrapherexp3.this.textAlign(37, 101);
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.base_font);
            ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_status_bar);
            ProcessingGrapherexp3.this.text("Input: " + ProcessingGrapherexp3.this.constrainString(this.currentfile, (float)(ProcessingGrapherexp3.this.width - sW - ProcessingGrapherexp3.round((float)(175.0f * ProcessingGrapherexp3.this.uimult))) - ProcessingGrapherexp3.this.textWidth("Input: ")), ProcessingGrapherexp3.round((float)(5.0f * ProcessingGrapherexp3.this.uimult)), ProcessingGrapherexp3.this.height - ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult)) + ProcessingGrapherexp3.round((float)(2.0f * ProcessingGrapherexp3.this.uimult)));
        }

        @Override
        public void keyboardInput(char keyChar, int keyCodeInt, boolean codedKey) {
            if (keyChar == '\u001b') {
                if (this.menuLevel != 0) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                } else if (this.setZoomSize >= 0) {
                    this.setZoomSize = -1;
                    ProcessingGrapherexp3.this.cursor(0);
                    ProcessingGrapherexp3.this.redrawContent = true;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (codedKey) {
                switch (keyCodeInt) {
                    case 38: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll = (int)((float)this.menuScroll - 12.0f * ProcessingGrapherexp3.this.uimult);
                            if (this.menuScroll < 0) {
                                this.menuScroll = 0;
                            }
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 40: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll = (int)((float)this.menuScroll + 12.0f * ProcessingGrapherexp3.this.uimult);
                            if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                                this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                            }
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 33: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll -= ProcessingGrapherexp3.this.height - this.cT;
                        if (this.menuScroll < 0) {
                            this.menuScroll = 0;
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 34: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll += ProcessingGrapherexp3.this.height - this.cT;
                        if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                            this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 35: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 36: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll = 0;
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 115: {
                        if (this.currentfile == "" || this.currentfile == "No File Set" || !this.changesMade) break;
                        this.saveFilePath = true;
                        this.outputfile = "";
                        ProcessingGrapherexp3.this.selectOutput("Select where to save the *.CSV file", "fileSelected");
                        break;
                    }
                    case 116: {
                        this.saveFilePath = false;
                        this.outputfile = "";
                        ProcessingGrapherexp3.this.selectInput("Select *.CSV data file to open", "fileSelected");
                    }
                }
            }
        }

        @Override
        public void contentClick(int xcoord, int ycoord) {
            if (this.labelling) {
                if (this.currentfile != "" && this.currentfile != "No File Set" && this.graph.onGraph(xcoord, ycoord)) {
                    block31: {
                        int labelColumn = -1;
                        int i = 0;
                        while (i < this.dataTable.getColumnCount()) {
                            if (this.dataTable.getColumnTitle(i).contains("l:Labels")) {
                                labelColumn = i;
                                break;
                            }
                            ++i;
                        }
                        if (labelColumn == -1) {
                            this.dataTable.addColumn("l:Labels");
                            labelColumn = this.dataTable.getColumnCount() - 1;
                            this.dataSignals.add(new DataSignal("Labels", ProcessingGrapherexp3.this.c_colorlist[this.dataSignals.size() % ProcessingGrapherexp3.this.c_colorlist.length]));
                        }
                        float xPosition = this.graph.xLabel(xcoord, this.dataSignals.get((int)labelColumn).signalColor);
                        if (this.xData != -1) {
                            int startPosition = ProcessingGrapherexp3.round((float)((xPosition - this.graph.xMin()) / (this.graph.xMax() - this.graph.xMin()) * (float)(this.dataTable.getRowCount() - 1)));
                            if (startPosition < 0) {
                                startPosition = 0;
                            } else if (startPosition >= this.dataTable.getRowCount()) {
                                startPosition = this.dataTable.getRowCount() - 1;
                            }
                            try {
                                if (this.dataTable.getFloat(startPosition, this.xData) <= xPosition) {
                                    int i2 = startPosition;
                                    while (i2 < this.dataTable.getRowCount() - 2) {
                                        if (xPosition < this.dataTable.getFloat(i2 + 1, this.xData)) {
                                            this.dataTable.setInt(i2, "l:Labels", 1);
                                            break block31;
                                        }
                                        ++i2;
                                    }
                                    break block31;
                                }
                                int i3 = startPosition;
                                while (i3 > 1) {
                                    if (xPosition > this.dataTable.getFloat(i3 - 1, this.xData)) {
                                        this.dataTable.setInt(i3, "l:Labels", 1);
                                        break;
                                    }
                                    --i3;
                                }
                            }
                            catch (Exception exception) {
                                ProcessingGrapherexp3.println((String)"FileGraph()::labels Unable to calculate correct label position");
                                this.dataTable.setInt(startPosition, "l:Labels", 1);
                            }
                        } else {
                            int startPosition = ProcessingGrapherexp3.round((float)(xPosition * this.graph.frequency()));
                            if (startPosition < 0) {
                                startPosition = 0;
                            } else if (startPosition >= this.dataTable.getRowCount()) {
                                startPosition = this.dataTable.getRowCount() - 1;
                            }
                            this.dataTable.setInt(startPosition, "l:Labels", 1);
                        }
                    }
                    this.changesMade = true;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
                this.labelling = false;
                ProcessingGrapherexp3.this.cursor(0);
            } else if (this.setZoomSize == 0) {
                if (this.graph.onGraph(xcoord, ycoord)) {
                    this.zoomCoordOne[0] = this.graph.xGraphPos(xcoord) * (this.graph.xMax() - this.graph.xMin()) + this.graph.xMin();
                    this.zoomCoordOne[1] = (1.0f - this.graph.yGraphPos(ycoord)) * (this.graph.yMax() - this.graph.yMin()) + this.graph.yMin();
                    ProcessingGrapherexp3.this.stroke(ProcessingGrapherexp3.this.c_graph_axis);
                    ProcessingGrapherexp3.this.strokeWeight(1.0f * ProcessingGrapherexp3.this.uimult);
                    ProcessingGrapherexp3.this.line((float)xcoord - 5.0f * ProcessingGrapherexp3.this.uimult, ycoord, (float)xcoord + 5.0f * ProcessingGrapherexp3.this.uimult, ycoord);
                    ProcessingGrapherexp3.this.line(xcoord, (float)ycoord - 5.0f * ProcessingGrapherexp3.this.uimult, xcoord, (float)ycoord + 5.0f * ProcessingGrapherexp3.this.uimult);
                    this.setZoomSize = 1;
                }
            } else if (this.setZoomSize == 1) {
                if (this.graph.onGraph(xcoord, ycoord)) {
                    this.zoomCoordOne[2] = this.graph.xGraphPos(xcoord) * (this.graph.xMax() - this.graph.xMin()) + this.graph.xMin();
                    this.zoomCoordOne[3] = (1.0f - this.graph.yGraphPos(ycoord)) * (this.graph.yMax() - this.graph.yMin()) + this.graph.yMin();
                    this.setZoomSize = -1;
                    this.zoomActive = true;
                    if (this.zoomCoordOne[0] < this.zoomCoordOne[2]) {
                        this.graph.xMin(ProcessingGrapherexp3.this.floorToSigFig(this.zoomCoordOne[0], 4));
                        this.graph.xMax(ProcessingGrapherexp3.this.ceilToSigFig(this.zoomCoordOne[2], 4));
                    } else {
                        this.graph.xMax(ProcessingGrapherexp3.this.ceilToSigFig(this.zoomCoordOne[0], 4));
                        this.graph.xMin(ProcessingGrapherexp3.this.floorToSigFig(this.zoomCoordOne[2], 4));
                    }
                    if (this.zoomCoordOne[1] < this.zoomCoordOne[3]) {
                        this.graph.yMin(ProcessingGrapherexp3.this.floorToSigFig(this.zoomCoordOne[1], 4));
                        this.graph.yMax(ProcessingGrapherexp3.this.ceilToSigFig(this.zoomCoordOne[3], 4));
                    } else {
                        this.graph.yMax(ProcessingGrapherexp3.this.ceilToSigFig(this.zoomCoordOne[1], 4));
                        this.graph.yMin(ProcessingGrapherexp3.this.floorToSigFig(this.zoomCoordOne[3], 4));
                    }
                    ProcessingGrapherexp3.this.redrawContent = true;
                    ProcessingGrapherexp3.this.redrawUI = true;
                    ProcessingGrapherexp3.this.cursor(0);
                }
            } else {
                ProcessingGrapherexp3.this.cursor(0);
            }
        }

        @Override
        public void scrollWheel(float amount) {
            if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                this.menuScroll = (int)((float)this.menuScroll + 30.0f * amount * ProcessingGrapherexp3.this.uimult);
                if (this.menuScroll < 0) {
                    this.menuScroll = 0;
                } else if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                    this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                }
            }
            ProcessingGrapherexp3.this.redrawUI = true;
        }

        @Override
        public void scrollBarUpdate(int xcoord, int ycoord) {
            if (this.sidebarScroll.active()) {
                int previousScroll = this.menuScroll;
                this.menuScroll = this.sidebarScroll.move(xcoord, ycoord, this.menuScroll, 0, this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT));
                if (previousScroll != this.menuScroll) {
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            }
        }

        @Override
        public void menuClick(int xcoord, int ycoord) {
            int sT = this.cT;
            int sL = this.cR;
            if (this.menuScroll > 0) {
                sT -= this.menuScroll;
            }
            if (this.menuScroll != -1) {
                sL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
            }
            int sW = ProcessingGrapherexp3.this.width - this.cR;
            int uH = ProcessingGrapherexp3.round((float)(30.0f * ProcessingGrapherexp3.this.uimult));
            ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult));
            int iH = ProcessingGrapherexp3.round((float)(25.0f * ProcessingGrapherexp3.this.uimult));
            int iL = ProcessingGrapherexp3.round((float)((float)sL + 10.0f * ProcessingGrapherexp3.this.uimult));
            int iW = ProcessingGrapherexp3.round((float)((float)sW - 20.0f * ProcessingGrapherexp3.this.uimult));
            if (this.menuScroll != -1 && this.sidebarScroll.click(xcoord, ycoord)) {
                ProcessingGrapherexp3.this.startScrolling(false);
            }
            if (this.menuLevel == 0) {
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 1.0f, iL, iW)) {
                    this.saveFilePath = false;
                    this.outputfile = "";
                    ProcessingGrapherexp3.this.selectInput("Select *.CSV data file to open", "fileSelected");
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 2.0f, iL, iW)) {
                    if (this.currentfile != "" && this.currentfile != "No File Set" && this.changesMade) {
                        this.saveFilePath = true;
                        this.outputfile = "";
                        ProcessingGrapherexp3.this.selectOutput("Select where to save the *.CSV file", "fileSelected");
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 4.5f, iL, iW)) {
                    if (this.currentfile != "" && this.currentfile != "No File Set") {
                        this.labelling = true;
                        ProcessingGrapherexp3.this.cursor(1);
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 5.5f, iL, iW)) {
                    if (this.currentfile != "" && this.currentfile != "No File Set") {
                        if (this.xData == -1 && this.dataSignals.size() == 1) {
                            this.selectedSignal = 0;
                            this.menuLevel = 2;
                        } else if (this.xData != -1 && this.dataSignals.size() == 2) {
                            this.selectedSignal = this.xData == 0 ? 1 : 0;
                            this.menuLevel = 2;
                        } else {
                            this.menuLevel = 1;
                        }
                        this.menuScroll = 0;
                        ProcessingGrapherexp3.this.redrawUI = true;
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 8.0f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, PApplet.parseInt((float)(iW / 3)))) {
                        this.graph.graphType(0);
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.redrawContent = true;
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + PApplet.parseInt((float)(iW / 3)), PApplet.parseInt((float)(iW / 3)))) {
                        this.graph.graphType(1);
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.redrawContent = true;
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + PApplet.parseInt((float)(2 * iW / 3)), PApplet.parseInt((float)(iW / 3)))) {
                        this.graph.graphType(2);
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.redrawContent = true;
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 9.0f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 2 - PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)))) {
                        ValidateInput userInput = new ValidateInput("Set the X-axis Minimum Value", "Minimum:", ProcessingGrapherexp3.str((float)this.graph.xMin()));
                        userInput.setErrorMessage("Error\nInvalid x-axis minimum value entered.\nThe number should be smaller the the maximum value.");
                        if (userInput.checkFloat(3, this.graph.xMax())) {
                            this.graph.xMin(userInput.getFloat());
                            this.zoomActive = true;
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.redrawContent = true;
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW / 2 + PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)), iW / 2 - PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)))) {
                        ValidateInput userInput = new ValidateInput("Set the X-axis Maximum Value", "Maximum:", ProcessingGrapherexp3.str((float)this.graph.xMax()));
                        userInput.setErrorMessage("Error\nInvalid x-axis maximum value entered.\nThe number should be larger the the minimum value.");
                        if (userInput.checkFloat(1, this.graph.xMin())) {
                            this.graph.xMax(userInput.getFloat());
                            this.zoomActive = true;
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.redrawContent = true;
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 10.0f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 2 - PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)))) {
                        ValidateInput userInput = new ValidateInput("Set the Y-axis Minimum Value", "Minimum:", ProcessingGrapherexp3.str((float)this.graph.yMin()));
                        userInput.setErrorMessage("Error\nInvalid y-axis minimum value entered.\nThe number should be smaller the the maximum value.");
                        if (userInput.checkFloat(3, this.graph.yMax())) {
                            this.graph.yMin(userInput.getFloat());
                            this.zoomActive = true;
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.redrawContent = true;
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW / 2 + PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)), iW / 2 - PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)))) {
                        ValidateInput userInput = new ValidateInput("Set the Y-axis Maximum Value", "Maximum:", ProcessingGrapherexp3.str((float)this.graph.yMax()));
                        userInput.setErrorMessage("Error\nInvalid y-axis maximum value entered.\nThe number should be larger the the minimum value.");
                        if (userInput.checkFloat(1, this.graph.yMin())) {
                            this.graph.yMax(userInput.getFloat());
                            this.zoomActive = true;
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.redrawContent = true;
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 11.0f, iL, iW)) {
                    if (this.currentfile != "" && this.currentfile != "No File Set") {
                        if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 2)) {
                            if (this.setZoomSize >= 0) {
                                this.setZoomSize = -1;
                                ProcessingGrapherexp3.this.cursor(0);
                                ProcessingGrapherexp3.this.redrawContent = true;
                                ProcessingGrapherexp3.this.redrawUI = true;
                            } else {
                                this.setZoomSize = 0;
                                ProcessingGrapherexp3.this.cursor(1);
                                ProcessingGrapherexp3.this.redrawUI = true;
                            }
                        } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW / 2, iW / 2)) {
                            this.zoomActive = false;
                            ProcessingGrapherexp3.this.cursor(0);
                            ProcessingGrapherexp3.this.redrawUI = true;
                            ProcessingGrapherexp3.this.redrawContent = true;
                        }
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 13.5f, iL, iW)) {
                    if (this.xData == -1) {
                        ValidateInput userInput = new ValidateInput("Received Data Update Rate", "Frequency (Hz):", ProcessingGrapherexp3.str((float)this.graph.frequency()));
                        userInput.setErrorMessage("Error\nInvalid frequency entered.\nThe rate can only be a number between 0 - 10,000 Hz");
                        if (userInput.checkFloat(1, 0.0f, 4, 10000.0f)) {
                            float newXrate = userInput.getFloat();
                            this.graph.frequency(newXrate);
                            ProcessingGrapherexp3.this.redrawContent = true;
                            ProcessingGrapherexp3.this.redrawUI = true;
                        }
                    }
                } else {
                    float tHnow = 14.5f;
                    int i = 0;
                    while (i < this.dataSignals.size()) {
                        if (i != this.xData) {
                            if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                                if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW - PApplet.parseInt((float)(20.0f * ProcessingGrapherexp3.this.uimult)), PApplet.parseInt((float)(20.0f * ProcessingGrapherexp3.this.uimult)))) {
                                    this.dataSignals.remove(i);
                                    this.dataTable.removeColumn(i);
                                    if (this.dataSignals.size() == 0 || this.dataSignals.size() == 1 && this.xData != -1) {
                                        this.currentfile = "No File Set";
                                        this.xData = -1;
                                        this.dataSignals.clear();
                                    }
                                    this.changesMade = true;
                                    ProcessingGrapherexp3.this.redrawContent = true;
                                    ProcessingGrapherexp3.this.redrawUI = true;
                                } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW - PApplet.parseInt((float)(40.0f * ProcessingGrapherexp3.this.uimult)), PApplet.parseInt((float)(20.0f * ProcessingGrapherexp3.this.uimult)))) {
                                    this.hueColor = this.previousColor = this.dataSignals.get((int)i).signalColor;
                                    this.newColor = this.previousColor;
                                    this.colorSelector = i;
                                    this.menuLevel = 3;
                                    this.menuScroll = 0;
                                    ProcessingGrapherexp3.this.redrawUI = true;
                                } else {
                                    String colname = ProcessingGrapherexp3.this.myShowInputDialog("Set the Data Signal Name", "Name:", this.dataSignals.get((int)i).signalText);
                                    if (colname != null && colname != "") {
                                        this.dataSignals.get((int)i).signalText = colname;
                                        if (this.dataTable.getColumnTitle(i).contains("l:")) {
                                            this.dataTable.setColumnTitle(i, "l:" + colname);
                                        } else {
                                            this.dataTable.setColumnTitle(i, colname);
                                        }
                                        ProcessingGrapherexp3.this.redrawUI = true;
                                    }
                                }
                            }
                            tHnow += 1.0f;
                        }
                        ++i;
                    }
                }
            } else if (this.menuLevel == 1) {
                float tHnow = 1.0f;
                if (this.dataSignals.size() == 0) {
                    tHnow += 1.0f;
                } else {
                    int i = 0;
                    while (i < this.dataSignals.size()) {
                        if (i != this.xData && !this.dataTable.getColumnTitle(i).contains("l:")) {
                            if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                                this.selectedSignal = i;
                                this.menuLevel = 2;
                                this.menuScroll = 0;
                                ProcessingGrapherexp3.this.redrawUI = true;
                            }
                            tHnow += 1.0f;
                        }
                        ++i;
                    }
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 0.5f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.menuLevel == 2) {
                float tHnow = 1.0f;
                Filters filterClass = new Filters();
                if (filterClass.filterList.length == 0) {
                    tHnow += 1.0f;
                } else {
                    int i = 0;
                    while (i < filterClass.filterList.length) {
                        if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW) && !filterClass.filterList[i].contains("h:")) {
                            this.workerActive = true;
                            WorkerThread filterThread = new WorkerThread();
                            filterThread.setFilterTask(i, this.selectedSignal);
                            this.menuLevel = 0;
                            this.menuScroll = 0;
                            ProcessingGrapherexp3.this.redrawUI = true;
                            ProcessingGrapherexp3.this.redrawContent = true;
                        }
                        tHnow += 1.0f;
                        ++i;
                    }
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 0.5f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.menuLevel == 3) {
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iW, 1.0f, iL, iW)) {
                    ProcessingGrapherexp3.this.colorMode(3, iW, iW, iW);
                    this.newColor = this.hueColor = ProcessingGrapherexp3.this.color(ProcessingGrapherexp3.this.mouseX - iL, ProcessingGrapherexp3.this.mouseY - (sT + uH), iW);
                    ProcessingGrapherexp3.this.colorMode(1, 255.0f, 255.0f, 255.0f);
                    ProcessingGrapherexp3.this.redrawUI = true;
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT + iW, uH, iH, 2.5f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.mouseX > iL && ProcessingGrapherexp3.this.mouseX < iL + iW / 2) {
                        this.newColor = ProcessingGrapherexp3.this.lerpColor(ProcessingGrapherexp3.this.c_white, this.hueColor, (float)(ProcessingGrapherexp3.this.mouseX - iL) / (float)(iW / 2));
                        ProcessingGrapherexp3.this.redrawUI = true;
                    } else if (ProcessingGrapherexp3.this.mouseX > iL + iW / 2 && ProcessingGrapherexp3.this.mouseX < iL + iW) {
                        this.newColor = ProcessingGrapherexp3.this.lerpColor(this.hueColor, ProcessingGrapherexp3.this.c_black, (float)(ProcessingGrapherexp3.this.mouseX - (iL + iW / 2)) / (float)(iW / 2));
                        ProcessingGrapherexp3.this.redrawUI = true;
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT + iW, uH, iH, 6.5f, iL, iW)) {
                    this.dataSignals.get((int)this.colorSelector).signalColor = this.newColor;
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                    ProcessingGrapherexp3.this.redrawContent = true;
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT + iW, uH, iH, 7.5f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            }
        }

        @Override
        public void parsePortData(String inputData, boolean graphable) {
        }

        @Override
        public void connectionEvent(boolean status) {
        }

        @Override
        public boolean checkSafeExit() {
            return true;
        }

        @Override
        public void performExit() {
        }

        class DataSignal {
            public String signalText;
            public int signalColor;

            DataSignal(String setText, int setColor) {
                this.signalText = setText;
                this.signalColor = setColor;
            }
        }

        class WorkerThread
        extends Thread {
            int task = 0;
            int signal = 0;
            int filter = 0;

            WorkerThread() {
            }

            public void setFilterTask(int filterType, int signalNumber) {
                FileGraph.this.workerActive = true;
                this.task = 1;
                this.filter = filterType;
                this.signal = signalNumber;
                super.start();
            }

            public void loadFile() {
                FileGraph.this.workerActive = true;
                this.task = 0;
                super.start();
            }

            @Override
            public void run() {
                if (this.task == 0) {
                    FileGraph.this.dataSignals.clear();
                    FileGraph.this.dataTable = ProcessingGrapherexp3.this.loadTable(FileGraph.this.currentfile, "csv, header");
                    int i = 0;
                    while (i < FileGraph.this.dataTable.getColumnCount()) {
                        FileGraph.this.dataTable.setColumnType(i, 0);
                        ++i;
                    }
                    FileGraph.this.workerActive = false;
                    ((FileGraph)FileGraph.this).ProcessingGrapherexp3.this.redrawContent = true;
                    ((FileGraph)FileGraph.this).ProcessingGrapherexp3.this.redrawUI = true;
                } else if (this.task == 1) {
                    double[] xAxisData;
                    Filters filterClass = new Filters();
                    double[] signalData = FileGraph.this.dataTable.getDoubleColumn(this.signal);
                    if (FileGraph.this.xData != -1) {
                        xAxisData = FileGraph.this.dataTable.getDoubleColumn(FileGraph.this.xData);
                    } else {
                        xAxisData = new double[signalData.length];
                        xAxisData[0] = 0.0;
                        int i = 1;
                        while (i < signalData.length) {
                            xAxisData[i] = xAxisData[i - 1] + (double)(1.0f / FileGraph.this.graph.frequency());
                            ++i;
                        }
                    }
                    double[] outputData = filterClass.runFilter(this.filter, signalData, xAxisData, FileGraph.this.currentfile);
                    if (outputData != null) {
                        String signalName = String.valueOf(filterClass.filterSlug[this.filter]) + "[" + FileGraph.this.dataTable.getColumnTitle(this.signal) + "]";
                        FileGraph.this.dataTable.addColumn(signalName, 0);
                        int newColumnIndex = FileGraph.this.dataTable.getColumnIndex(signalName);
                        int i = 0;
                        while (i < FileGraph.this.dataTable.getRowCount()) {
                            FileGraph.this.dataTable.setDouble(i, newColumnIndex, outputData[i]);
                            ++i;
                        }
                    }
                    FileGraph.this.workerActive = false;
                    ((FileGraph)FileGraph.this).ProcessingGrapherexp3.this.redrawContent = true;
                    ((FileGraph)FileGraph.this).ProcessingGrapherexp3.this.redrawUI = true;
                }
            }
        }
    }

    class Filters {
        String[] filterList = new String[]{"h:Noise Removal", "Moving Average", "1D Total Variance", "RC Low Pass", "RC High Pass", "h:Mathematical Functions", "Absolute Value:  |x|", "Squared:  x^2", "Derivative:  \u0394x/dt", "Integral:  \u03a3xdt", "h:Signal Analysis", "Fourier Transform", "Enclosed Area"};
        String[] filterSlug = new String[]{"h", "avg", "tv", "lp", "hp", "h", "abs", "squ", "\u0394/dt", "\u03a3dt", "h", "fft", "ea"};

        Filters() {
        }

        public double[] runFilter(int filterType, double[] signalData, double[] xAxisData, String currentFileLocation) {
            double[] outputData = null;
            switch (filterType) {
                case 0: 
                case 1: {
                    ValidateInput userInput = new ValidateInput("Set Moving Average Filter Amount", "Number of Samples:", ProcessingGrapherexp3.str((int)5));
                    userInput.setErrorMessage("Error\nInvalid window size entered.\nThe window size should be an integer greater than 2.");
                    if (!userInput.checkInt(2, 2)) break;
                    int windowSize = userInput.getInt();
                    MovingAverage avgFilter = new MovingAverage(windowSize);
                    outputData = avgFilter.process(signalData);
                    break;
                }
                case 2: {
                    ValidateInput userInput = new ValidateInput("Set Denoising Filter Amount", "Lambda Value:", ProcessingGrapherexp3.str((int)1));
                    userInput.setErrorMessage("Error\nInvalid filter value entered.\nThe Lambda value should be a number greater than 0.");
                    if (!userInput.checkDouble(1, 0.0)) break;
                    double filterValue = userInput.getDouble();
                    DenoiseTv1D denoiseFilter = new DenoiseTv1D();
                    outputData = denoiseFilter.process(signalData, filterValue);
                    break;
                }
                case 3: {
                    ValidateInput userInput = new ValidateInput("Set the 3dB Cutoff Frequency", "Filter Frequency (Hz):", ProcessingGrapherexp3.str((int)100));
                    userInput.setErrorMessage("Error\nInvalid filter value entered.\nThe cutoff frequency should be a number above 0 Hz.");
                    if (!userInput.checkDouble(1, 0.0)) break;
                    double filterValue = userInput.getDouble();
                    RcLowPass lowPassFilter = new RcLowPass(filterValue);
                    outputData = lowPassFilter.process(signalData, xAxisData);
                    break;
                }
                case 4: {
                    ValidateInput userInput = new ValidateInput("Set the 3dB Cutoff Frequency", "Filter Frequency (Hz):", ProcessingGrapherexp3.str((int)100));
                    userInput.setErrorMessage("Error\nInvalid filter value entered.\nThe cutoff frequency should be a number above 0 Hz.");
                    if (!userInput.checkDouble(1, 0.0)) break;
                    double filterValue = userInput.getDouble();
                    RcHighPass highPassFilter = new RcHighPass(filterValue);
                    outputData = highPassFilter.process(signalData, xAxisData);
                    break;
                }
                case 5: 
                case 6: {
                    outputData = new double[signalData.length];
                    int i = 0;
                    while (i < signalData.length) {
                        outputData[i] = Math.abs(signalData[i]);
                        ++i;
                    }
                    break;
                }
                case 7: {
                    outputData = new double[signalData.length];
                    int i = 0;
                    while (i < signalData.length) {
                        outputData[i] = Math.pow(signalData[i], 2.0);
                        ++i;
                    }
                    break;
                }
                case 8: {
                    outputData = new double[signalData.length];
                    outputData[0] = 0.0;
                    outputData[signalData.length - 1] = 0.0;
                    int i = 1;
                    while (i < signalData.length - 1) {
                        outputData[i] = (signalData[i + 1] - signalData[i - 1]) / (xAxisData[i + 1] - xAxisData[i - 1]);
                        ++i;
                    }
                    break;
                }
                case 9: {
                    outputData = new double[signalData.length];
                    outputData[0] = 0.0;
                    int i = 1;
                    while (i < signalData.length) {
                        outputData[i] = outputData[i - 1] + signalData[i] * (xAxisData[i] - xAxisData[i - 1]);
                        ++i;
                    }
                    break;
                }
                case 10: 
                case 11: {
                    double[] amplitudeAxis = null;
                    double[] frequencyAxis = new double[signalData.length];
                    double samplingFrequency = 0.0;
                    int i = 0;
                    while (i < xAxisData.length - 1) {
                        samplingFrequency += xAxisData[i + 1] - xAxisData[i];
                        ++i;
                    }
                    samplingFrequency /= (double)(xAxisData.length - 1);
                    samplingFrequency = 1.0 / samplingFrequency;
                    FastFourierTransform fft = new FastFourierTransform();
                    amplitudeAxis = fft.processForward(signalData, samplingFrequency, frequencyAxis);
                    if (frequencyAxis == null || amplitudeAxis == null) {
                        ProcessingGrapherexp3.this.alertMessage("Fast Fourier Transform\nError: Unable to calculate the FFT");
                        break;
                    }
                    double maxAmplitude = 0.0;
                    int maxAmpIndex = 0;
                    String[] lines = new String[amplitudeAxis.length + 1];
                    lines[0] = "x:Frequency (Hz),Amplitude";
                    int i2 = 0;
                    while (i2 < amplitudeAxis.length) {
                        lines[i2 + 1] = String.valueOf(frequencyAxis[i2]) + "," + amplitudeAxis[i2];
                        if (maxAmplitude < amplitudeAxis[i2]) {
                            maxAmplitude = amplitudeAxis[i2];
                            maxAmpIndex = i2;
                        }
                        ++i2;
                    }
                    String newFileLocation = String.valueOf(currentFileLocation.substring(0, currentFileLocation.length() - 4)) + "_fft.csv";
                    ProcessingGrapherexp3.this.saveStrings(newFileLocation, lines);
                    DecimalFormat format = new DecimalFormat("0.#####");
                    ProcessingGrapherexp3.this.alertMessage("Fast Fourier Transform\nDominant frequency:   " + format.format(frequencyAxis[maxAmpIndex]) + " Hz\n(Assuming time axis was in seconds)\n" + "\nFull spectrogram is saved at:\n" + newFileLocation);
                    break;
                }
                case 12: {
                    AreaCalculation areaCalc = new AreaCalculation();
                    double[] calculatedAreas = areaCalc.processCycles(xAxisData, signalData);
                    if (calculatedAreas == null || calculatedAreas.length < 1) {
                        ProcessingGrapherexp3.this.alertMessage("Enclosed Area Calculation\nError: No cycles were found in the data\nTherefore there are no enclosed areas");
                        break;
                    }
                    double averageArea = 0.0;
                    int i = 0;
                    while (i < calculatedAreas.length) {
                        averageArea += calculatedAreas[i];
                        ++i;
                    }
                    DecimalFormat format = new DecimalFormat("0.########");
                    ProcessingGrapherexp3.this.alertMessage("Enclosed Area Calculation\nCycles Detected:   " + calculatedAreas.length + "\nAverage Area:   " + format.format(averageArea /= (double)calculatedAreas.length));
                }
            }
            return outputData;
        }

        public class AreaCalculation {
            public double[] processCycles(double[] xData, double[] yData) {
                int[] cycleEnd = this.detectCycles(xData, yData);
                double[] calculatedArea = null;
                if (cycleEnd != null && cycleEnd.length > 1) {
                    calculatedArea = new double[]{};
                    int i = 1;
                    while (i < cycleEnd.length) {
                        double currentArea = 0.0;
                        int j = cycleEnd[i - 1];
                        while (j < cycleEnd[i] - 1) {
                            double areaSlice = (xData[j] * yData[j + 1] - yData[j] * xData[j + 1]) / 2.0;
                            currentArea += areaSlice;
                            ++j;
                        }
                        currentArea += (xData[cycleEnd[i] - 1] * yData[cycleEnd[i - 1]] - yData[cycleEnd[i] - 1] * xData[cycleEnd[i - 1]]) / 2.0;
                        currentArea = Math.abs(currentArea);
                        calculatedArea = (double[])ProcessingGrapherexp3.append((Object)calculatedArea, (Object)currentArea);
                        ++i;
                    }
                }
                return calculatedArea;
            }

            public int[] detectCycles(double[] xData, double[] yData) {
                if (xData == null || yData == null || xData.length != yData.length || xData.length < 3) {
                    return null;
                }
                int[] cycleEnd = new int[1];
                double[] startPoint = new double[]{xData[0], yData[0]};
                double avgStepDistance = this.distance(xData[0], yData[0], xData[1], yData[1]);
                double avgXstep = Math.abs(xData[1] - xData[0]);
                double avgYstep = Math.abs(yData[1] - yData[0]);
                int i = 2;
                while (i < xData.length) {
                    avgStepDistance = (avgStepDistance * (double)i + this.distance(xData[i - 1], yData[i - 1], xData[i], yData[i])) / (double)(i + 1);
                    avgXstep = (avgXstep * (double)i + Math.abs(xData[i] - xData[i - 1])) / (double)(i + 1);
                    avgYstep = (avgYstep * (double)i + Math.abs(yData[i] - yData[i - 1])) / (double)(i + 1);
                    double currentDistance = this.distance(startPoint[0], startPoint[1], xData[i], yData[i]);
                    if (currentDistance < avgStepDistance * 0.5 && Math.abs(xData[i] - startPoint[0]) < avgXstep * 0.5 && Math.abs(yData[i] - startPoint[1]) < avgYstep * 0.5) {
                        cycleEnd = ProcessingGrapherexp3.append((int[])cycleEnd, (int)i);
                        startPoint[0] = xData[i];
                        startPoint[1] = yData[i];
                        ++i;
                    }
                    ++i;
                }
                return cycleEnd;
            }

            private double distance(double x1, double y1, double x2, double y2) {
                return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            }
        }

        public class DenoiseTv1D {
            /*
             * Unable to fully structure code
             */
            public double[] process(double[] input, double lambda) {
                block39: {
                    block40: {
                        block38: {
                            width = input.length;
                            indstart_low = new int[width];
                            indstart_up = new int[width];
                            output = new double[width];
                            j_low = 0;
                            j_up = 0;
                            jseg = 0;
                            indjseg = 0;
                            i = 1;
                            output_low_curr = output_low_first = input[0] - lambda;
                            output_up_curr = output_up_first = input[0] + lambda;
                            twolambda = 2.0 * lambda;
                            if (width == 1) {
                                output[0] = input[0];
                                return output;
                            }
                            indstart_low[0] = 0;
                            indstart_up[0] = 0;
                            --width;
                            while (i < width) {
                                if (input[i] >= output_low_curr) {
                                    if (input[i] <= output_up_curr) {
                                        output_up_curr += (input[i] - output_up_curr) / (double)(i - indstart_up[j_up] + 1);
                                        output[indjseg] = output_up_first;
                                        while (j_up > jseg && output_up_curr <= output[ind = indstart_up[j_up - 1]]) {
                                            output_up_curr += (output[ind] - output_up_curr) * ((double)(indstart_up[j_up--] - ind) / (double)(i - ind + 1));
                                        }
                                        if (j_up == jseg) {
                                            while (output_up_curr <= output_low_first && jseg < j_low) {
                                                indjseg2 = indstart_low[++jseg];
                                                output_up_curr += (output_up_curr - output_low_first) * ((double)(indjseg2 - indjseg) / (double)(i - indjseg2 + 1));
                                                while (indjseg < indjseg2) {
                                                    output[indjseg++] = output_low_first;
                                                }
                                                output_low_first = output[indjseg];
                                            }
                                            output_up_first = output_up_curr;
                                            j_up = jseg;
                                            indstart_up[j_up] = indjseg;
                                        } else {
                                            output[indstart_up[j_up]] = output_up_curr;
                                        }
                                    } else {
                                        indstart_up[++j_up] = i;
                                        output_up_curr = output[i] = input[indstart_up[++j_up]];
                                    }
                                    output_low_curr += (input[i] - output_low_curr) / (double)(i - indstart_low[j_low] + 1);
                                    output[indjseg] = output_low_first;
                                    while (j_low > jseg && output_low_curr >= output[ind = indstart_low[j_low - 1]]) {
                                        output_low_curr += (output[ind] - output_low_curr) * ((double)(indstart_low[j_low--] - ind) / (double)(i - ind + 1));
                                    }
                                    if (j_low == jseg) {
                                        while (output_low_curr >= output_up_first && jseg < j_up) {
                                            indjseg2 = indstart_up[++jseg];
                                            output_low_curr += (output_low_curr - output_up_first) * ((double)(indjseg2 - indjseg) / (double)(i - indjseg2 + 1));
                                            while (indjseg < indjseg2) {
                                                output[indjseg++] = output_up_first;
                                            }
                                            output_up_first = output[indjseg];
                                        }
                                        j_low = jseg;
                                        indstart_low[j_low] = indjseg;
                                        output_low_first = indstart_low[j_low] == i ? output_up_first - twolambda : output_low_curr;
                                    } else {
                                        output[indstart_low[j_low]] = output_low_curr;
                                    }
                                } else {
                                    indstart_low[++j_low] = i;
                                    output_low_curr = output[i] = input[indstart_low[++j_low]];
                                    output_up_curr += (output[i] - output_up_curr) / (double)(i - indstart_up[j_up] + 1);
                                    output[indjseg] = output_up_first;
                                    while (j_up > jseg && output_up_curr <= output[ind = indstart_up[j_up - 1]]) {
                                        output_up_curr += (output[ind] - output_up_curr) * ((double)(indstart_up[j_up--] - ind) / (double)(i - ind + 1));
                                    }
                                    if (j_up == jseg) {
                                        while (output_up_curr <= output_low_first && jseg < j_low) {
                                            indjseg2 = indstart_low[++jseg];
                                            output_up_curr += (output_up_curr - output_low_first) * ((double)(indjseg2 - indjseg) / (double)(i - indjseg2 + 1));
                                            while (indjseg < indjseg2) {
                                                output[indjseg++] = output_low_first;
                                            }
                                            output_low_first = output[indjseg];
                                        }
                                        j_up = jseg;
                                        indstart_up[j_up] = indjseg;
                                        output_up_first = indstart_up[j_up] == i ? output_low_first + twolambda : output_up_curr;
                                    } else {
                                        output[indstart_up[j_up]] = output_up_curr;
                                    }
                                }
                                ++i;
                            }
                            if (!(input[i] + lambda <= output_low_curr)) break block38;
                            while (jseg < j_low) {
                                indjseg2 = indstart_low[++jseg];
                                while (indjseg < indjseg2) {
                                    output[indjseg++] = output_low_first;
                                }
                                output_low_first = output[indjseg];
                            }
                            while (indjseg < i) {
                                output[indjseg++] = output_low_first;
                            }
                            output[indjseg] = input[i] + lambda;
                            break block39;
                        }
                        if (!(input[i] - lambda >= output_up_curr)) break block40;
                        while (jseg < j_up) {
                            indjseg2 = indstart_up[++jseg];
                            while (indjseg < indjseg2) {
                                output[indjseg++] = output_up_first;
                            }
                            output_up_first = output[indjseg];
                        }
                        while (indjseg < i) {
                            output[indjseg++] = output_up_first;
                        }
                        output[indjseg] = input[i] - lambda;
                        break block39;
                    }
                    output_low_curr += (input[i] + lambda - output_low_curr) / (double)(i - indstart_low[j_low] + 1);
                    output[indjseg] = output_low_first;
                    while (j_low > jseg && output_low_curr >= output[ind = indstart_low[j_low - 1]]) {
                        output_low_curr += (output[ind] - output_low_curr) * ((double)(indstart_low[j_low--] - ind) / (double)(i - ind + 1));
                    }
                    if (j_low != jseg) ** GOTO lbl148
                    if (output_up_first >= output_low_curr) {
                        while (indjseg <= i) {
                            output[indjseg++] = output_low_curr;
                        }
                    } else {
                        output_up_curr += (input[i] - lambda - output_up_curr) / (double)(i - indstart_up[j_up] + 1);
                        output[indjseg] = output_up_first;
                        while (j_up > jseg && output_up_curr <= output[ind = indstart_up[j_up - 1]]) {
                            output_up_curr += (output[ind] - output_up_curr) * ((double)(indstart_up[j_up--] - ind) / (double)(i - ind + 1));
                        }
                        while (jseg < j_up) {
                            indjseg2 = indstart_up[++jseg];
                            while (indjseg < indjseg2) {
                                output[indjseg++] = output_up_first;
                            }
                            output_up_first = output[indjseg];
                        }
                        indjseg = indstart_up[j_up];
                        while (indjseg <= i) {
                            output[indjseg++] = output_up_curr;
                        }
                    }
                    break block39;
lbl-1000:
                    // 1 sources

                    {
                        indjseg2 = indstart_low[++jseg];
                        while (indjseg < indjseg2) {
                            output[indjseg++] = output_low_first;
                        }
                        output_low_first = output[indjseg];
lbl148:
                        // 2 sources

                        ** while (jseg < j_low)
                    }
lbl149:
                    // 1 sources

                    indjseg = indstart_low[j_low];
                    while (indjseg <= i) {
                        output[indjseg++] = output_low_curr;
                    }
                }
                return output;
            }
        }

        public class FastFourierTransform {
            public double[] processForward(double[] signalData, double samplingFrequency, double[] frequencyAxis) {
                int signalLength;
                int pt = signalLength = signalData.length;
                --pt;
                pt |= pt >> 1;
                pt |= pt >> 2;
                pt |= pt >> 4;
                pt |= pt >> 8;
                pt |= pt >> 16;
                double[] complexArray = new double[++pt * 2];
                int i = 0;
                while (i < pt * 2) {
                    complexArray[i] = 0.0;
                    ++i;
                }
                i = 0;
                while (i < signalLength) {
                    complexArray[i * 2] = signalData[i];
                    ++i;
                }
                this.fft(complexArray, pt, 1);
                double[] amplitudeArray = new double[signalLength];
                int i2 = 0;
                while (i2 < signalLength) {
                    amplitudeArray[i2] = Math.sqrt(complexArray[i2 * 2] * complexArray[i2 * 2] + complexArray[i2 * 2 + 1] * complexArray[i2 * 2 + 1]);
                    ++i2;
                }
                if (frequencyAxis != null && frequencyAxis.length >= signalData.length) {
                    i2 = 0;
                    while (i2 < signalLength) {
                        frequencyAxis[i2] = (double)i2 * samplingFrequency / (double)pt;
                        ++i2;
                    }
                }
                return amplitudeArray;
            }

            public void fft(double[] data, int noOfSamples, int direction) {
                int m;
                double tempr;
                int n = noOfSamples * 2;
                int j = 0;
                int i = 0;
                while (i < n / 2) {
                    if (j > i) {
                        tempr = data[j];
                        data[j] = data[i];
                        data[i] = tempr;
                        tempr = data[j + 1];
                        data[j + 1] = data[i + 1];
                        data[i + 1] = tempr;
                        if (j / 2 < n / 4) {
                            tempr = data[n - (i + 2)];
                            data[n - (i + 2)] = data[n - (j + 2)];
                            data[n - (j + 2)] = tempr;
                            tempr = data[n - (i + 2) + 1];
                            data[n - (i + 2) + 1] = data[n - (j + 2) + 1];
                            data[n - (j + 2) + 1] = tempr;
                        }
                    }
                    m = n / 2;
                    while (m >= 2 && j >= m) {
                        j -= m;
                        m /= 2;
                    }
                    j += m;
                    i += 2;
                }
                int mmax = 2;
                while (n > mmax) {
                    int istep = mmax << 1;
                    double theta = (float)direction * ((float)Math.PI * 2 / (float)mmax);
                    double wtemp = Math.sin(0.5 * theta);
                    double wpr = -2.0 * wtemp * wtemp;
                    double wpi = Math.sin(theta);
                    double wr = 1.0;
                    double wi = 0.0;
                    m = 1;
                    while (m < mmax) {
                        i = m;
                        while (i <= n) {
                            j = i + mmax;
                            tempr = wr * data[j - 1] - wi * data[j];
                            double tempi = wr * data[j] + wi * data[j - 1];
                            data[j - 1] = data[i - 1] - tempr;
                            data[j] = data[i] - tempi;
                            int n2 = i - 1;
                            data[n2] = data[n2] + tempr;
                            int n3 = i;
                            data[n3] = data[n3] + tempi;
                            i += istep;
                        }
                        wtemp = wr;
                        wr = wtemp * wpr - wi * wpi + wr;
                        wi = wi * wpr + wtemp * wpi + wi;
                        m += 2;
                    }
                    mmax = istep;
                }
            }
        }

        public class MovingAverage {
            private int size;
            private double[] samples;
            private double total = 0.0;
            private int index = 0;
            private boolean bufferFilled = false;

            public MovingAverage(int windowSize) {
                this.size = windowSize;
                this.samples = new double[this.size];
            }

            public void add(double signalValue) {
                this.total -= this.samples[this.index];
                this.samples[this.index] = signalValue;
                this.total += signalValue;
                ++this.index;
                if (this.index == this.size) {
                    this.bufferFilled = true;
                    this.index = 0;
                }
            }

            public double getAverage() {
                if (this.bufferFilled) {
                    return this.total / (double)this.size;
                }
                return this.total / (double)this.index;
            }

            public double[] process(double[] signalData) {
                double[] outputData = new double[signalData.length];
                int samplesOffset = this.size / 2;
                int i = 0;
                while (i < signalData.length) {
                    this.add(signalData[i]);
                    if (i >= samplesOffset) {
                        outputData[i - samplesOffset] = this.getAverage();
                    }
                    ++i;
                }
                this.reset();
                i = signalData.length - 1;
                while (i >= signalData.length - this.size) {
                    this.add(signalData[i]);
                    if (i < signalData.length - samplesOffset) {
                        outputData[i + samplesOffset] = this.getAverage();
                    }
                    --i;
                }
                return outputData;
            }

            public void reset() {
                this.total = 0.0;
                this.index = 0;
                this.bufferFilled = false;
                int i = 0;
                while (i < this.size) {
                    this.samples[i] = 0.0;
                    ++i;
                }
            }
        }

        public class RcHighPass {
            private double timeConstant;
            private double lastOutput;
            private double lastInput;
            private double lastXaxis;
            private boolean filterInitialised;

            public RcHighPass(double cutoffFrequency) {
                if (cutoffFrequency <= 0.0) {
                    cutoffFrequency = 1.0;
                }
                this.timeConstant = 1.0 / (Math.PI * 2 * cutoffFrequency);
                this.filterInitialised = false;
            }

            public double processStep(double signalData, double xAxisData) {
                double outputData;
                if (this.filterInitialised) {
                    double alpha = this.timeConstant / (this.timeConstant + (xAxisData - this.lastXaxis));
                    outputData = alpha * (this.lastOutput + signalData - this.lastInput);
                } else {
                    outputData = signalData;
                    this.filterInitialised = true;
                }
                this.lastOutput = outputData;
                this.lastInput = signalData;
                this.lastXaxis = xAxisData;
                return outputData;
            }

            public double[] process(double[] signalData, double[] xAxisData) {
                double[] outputData = new double[signalData.length];
                int i = 0;
                while (i < signalData.length) {
                    outputData[i] = this.processStep(signalData[i], xAxisData[i]);
                    ++i;
                }
                return outputData;
            }

            public void reset() {
                this.filterInitialised = false;
            }
        }

        public class RcLowPass {
            private double timeConstant;
            private double lastOutput;
            private double lastXaxis;
            private boolean filterInitialised;

            public RcLowPass(double cutoffFrequency) {
                if (cutoffFrequency <= 0.0) {
                    cutoffFrequency = 1.0;
                }
                this.timeConstant = 1.0 / (Math.PI * 2 * cutoffFrequency);
                this.filterInitialised = false;
            }

            public double processStep(double signalData, double xAxisData) {
                double outputData;
                if (this.filterInitialised) {
                    double alpha = (xAxisData - this.lastXaxis) / (this.timeConstant + (xAxisData - this.lastXaxis));
                    outputData = this.lastOutput + alpha * (signalData - this.lastOutput);
                } else {
                    outputData = signalData;
                    this.filterInitialised = true;
                }
                this.lastOutput = outputData;
                this.lastXaxis = xAxisData;
                return outputData;
            }

            public double[] process(double[] signalData, double[] xAxisData) {
                double[] outputData = new double[signalData.length];
                int i = 0;
                while (i < signalData.length) {
                    outputData[i] = this.processStep(signalData[i], xAxisData[i]);
                    ++i;
                }
                return outputData;
            }

            public void reset() {
                this.filterInitialised = false;
            }
        }
    }

    public static class FxDialogs {
        public static final String YES = "Yes";
        public static final String NO = "No";
        public static final String OK = "OK";
        public static final String CANCEL = "Cancel";

        public static void showInformation(String title, String message) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.initStyle(StageStyle.UTILITY);
            alert.setTitle("Information");
            alert.setHeaderText(title);
            alert.setContentText(message);
            alert.showAndWait();
        }

        public static void showWarning(String title, String message) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.initStyle(StageStyle.UTILITY);
            alert.setTitle("Warning");
            alert.setHeaderText(title);
            alert.setContentText(message);
            alert.showAndWait();
        }

        public static void showError(String title, String message) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initStyle(StageStyle.UTILITY);
            alert.setTitle("Error");
            alert.setHeaderText(title);
            alert.setContentText(message);
            alert.showAndWait();
        }

        public static void showException(String title, String message, Exception exception) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initStyle(StageStyle.UTILITY);
            alert.setTitle("Exception");
            alert.setHeaderText(title);
            alert.setContentText(message);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            String exceptionText = sw.toString();
            Label label = new Label("Details:");
            TextArea textArea = new TextArea(exceptionText);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane expContent = new GridPane();
            expContent.setMaxWidth(Double.MAX_VALUE);
            expContent.add((Node)label, 0, 0);
            expContent.add((Node)textArea, 0, 1);
            alert.getDialogPane().setExpandableContent((Node)expContent);
            alert.showAndWait();
        }

        public static String showConfirm(String title, String message, String ... options) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.initStyle(StageStyle.UTILITY);
            alert.setTitle("Choose an option");
            alert.setHeaderText(title);
            alert.setContentText(message);
            if (options == null || options.length == 0) {
                options = new String[]{OK, CANCEL};
            }
            ArrayList<ButtonType> buttons = new ArrayList<ButtonType>();
            String[] stringArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                buttons.add(new ButtonType(option));
                ++n2;
            }
            alert.getButtonTypes().setAll(buttons);
            Optional result = alert.showAndWait();
            if (!result.isPresent()) {
                return CANCEL;
            }
            return ((ButtonType)result.get()).getText();
        }

        public static String showTextInput(String title, String message, String defaultValue) {
            TextInputDialog dialog = new TextInputDialog(defaultValue);
            dialog.initStyle(StageStyle.UTILITY);
            dialog.setTitle("Input");
            dialog.setHeaderText(title);
            dialog.setContentText(message);
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                return (String)result.get();
            }
            return null;
        }
    }

    class Graph {
        public static final int LINE_CHART = 0;
        public static final int DOT_CHART = 1;
        public static final int BAR_CHART = 2;
        int cL;
        int cR;
        int cT;
        int cB;
        int gL;
        int gR;
        int gT;
        int gB;
        float gridX;
        float gridY;
        float offsetLeft;
        float offsetBottom;
        float minX;
        float maxX;
        float minY;
        float maxY;
        float[] lastX = new float[]{0.0f};
        float[] lastY = new float[]{Float.MIN_VALUE};
        float xStep;
        float scaleFactor;
        float xRate;
        int plotType;
        String plotName;
        String xAxisName;
        int graphMark;
        int border;
        boolean redrawGraph;
        boolean gridLines;
        boolean squareGrid;
        boolean highlighted;
        PGraphics graphics;

        Graph(PGraphics canvas, int left, int right, int top, int bottom, float minX, float maxX, float minY, float maxY, String name) {
            this.graphics = ProcessingGrapherexp3.this.g;
            this.plotName = name;
            this.cL = left;
            this.gL = left;
            this.cR = right;
            this.gR = right;
            this.cT = top;
            this.gT = top;
            this.cB = bottom;
            this.gB = bottom;
            this.gridX = 0.0f;
            this.gridY = 0.0f;
            this.offsetLeft = this.cL;
            this.offsetBottom = this.cT;
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
            this.scaleFactor = 1.0f;
            this.xRate = 100.0f;
            this.xStep = 1.0f / this.xRate;
            this.graphMark = ProcessingGrapherexp3.round((float)(8.0f * this.scaleFactor));
            this.border = ProcessingGrapherexp3.round((float)(30.0f * this.scaleFactor));
            this.plotType = 0;
            this.gridLines = true;
            this.redrawGraph = true;
            this.squareGrid = false;
            this.highlighted = false;
            this.xAxisName = "";
        }

        Graph(PGraphics canvas, int graphWidth, int graphHeight, float minX, float maxX, float minY, float maxY, String name) {
            this(processingGrapherexp3.g, 0, graphWidth, 0, graphHeight, minX, maxX, minY, maxY, name);
        }

        Graph(int left, int right, int top, int bottom, float minX, float maxX, float minY, float maxY, String name) {
            this(processingGrapherexp3.g, left, right, top, bottom, minX, maxX, minY, maxY, name);
        }

        Graph(int graphWidth, int graphHeight, float minX, float maxX, float minY, float maxY, String name) {
            this(processingGrapherexp3.g, 0, graphWidth, 0, graphHeight, minX, maxX, minY, maxY, name);
        }

        Graph(PGraphics canvas, int left, int right, int top, int bottom) {
            this(canvas, left, right, top, bottom, 0.0f, 20.0f, 0.0f, 1.0f, "Graph");
        }

        Graph(int left, int right, int top, int bottom) {
            this(processingGrapherexp3.g, left, right, top, bottom, 0.0f, 20.0f, 0.0f, 1.0f, "Graph");
        }

        Graph(PGraphics canvas, int graphWidth, int graphHeight) {
            this(canvas, 0, graphWidth, 0, graphHeight, 0.0f, 20.0f, 0.0f, 1.0f, "Graph");
        }

        Graph(int graphWidth, int graphHeight) {
            this(processingGrapherexp3.g, 0, graphWidth, 0, graphHeight, 0.0f, 20.0f, 0.0f, 1.0f, "Graph");
        }

        public void canvas(PGraphics newGraphics) {
            if (newGraphics != null) {
                this.graphics = newGraphics;
            }
        }

        public PGraphics canvas() {
            return this.graphics;
        }

        public void setSize(int newL, int newR, int newT, int newB) {
            this.cL = newL;
            this.cR = newR;
            this.cT = newT;
            this.cB = newB;
            this.graphMark = ProcessingGrapherexp3.round((float)(8.0f * this.scaleFactor));
            this.border = ProcessingGrapherexp3.round((float)(30.0f * this.scaleFactor));
            int i = 0;
            while (i < this.lastX.length) {
                this.lastX[i] = 0.0f;
                ++i;
            }
            this.redrawGraph = true;
        }

        public void scale(float factor) {
            if (factor > 0.0f) {
                this.scaleFactor = factor;
            }
        }

        public float scale() {
            return this.scaleFactor;
        }

        public float frequency() {
            return this.xRate;
        }

        public boolean frequency(float newrate) {
            if (this.valid(newrate) && newrate > 0.0f && newrate <= 10000.0f) {
                this.xRate = newrate;
                this.xStep = 1.0f / this.xRate;
                return true;
            }
            ProcessingGrapherexp3.println((String)("Graph::setFrequency() - Invalid number: " + newrate));
            return false;
        }

        public boolean getSquareGrid() {
            return this.squareGrid;
        }

        public void setSquareGrid(boolean value) {
            this.squareGrid = value;
        }

        public void xAxisTitle(String newName) {
            this.xAxisName = newName;
        }

        public String xAxisTitle() {
            return this.xAxisName;
        }

        public void limits(float minX, float maxX, float minY, float maxY) {
            if (this.valid(minX)) {
                this.minX = minX;
            }
            if (this.valid(maxX)) {
                this.maxX = maxX;
            }
            if (this.valid(minY)) {
                this.minY = minY;
            }
            if (this.valid(maxY)) {
                this.maxY = maxY;
            }
        }

        public boolean xMin(float newValue) {
            if (this.valid(newValue) && newValue < this.maxX) {
                this.minX = newValue;
                return true;
            }
            return false;
        }

        public boolean xMax(float newValue) {
            if (this.valid(newValue) && newValue > this.minX) {
                this.maxX = newValue;
                return true;
            }
            return false;
        }

        public boolean yMin(float newValue) {
            if (this.valid(newValue) && newValue < this.maxY) {
                this.minY = newValue;
                return true;
            }
            return false;
        }

        public boolean yMax(float newValue) {
            if (this.valid(newValue) && newValue > this.minY) {
                this.maxY = newValue;
                return true;
            }
            return false;
        }

        public float xMin() {
            return this.minX;
        }

        public float xMax() {
            return this.maxX;
        }

        public float yMin() {
            return this.minY;
        }

        public float yMax() {
            return this.maxY;
        }

        public void resetGraph() {
            int i = 0;
            while (i < this.lastX.length) {
                this.lastX[i] = -this.xStep;
                ++i;
            }
            i = 0;
            while (i < this.lastY.length) {
                this.lastY[i] = Float.MIN_VALUE;
                ++i;
            }
        }

        public void reset() {
            this.lastX = new float[0];
            this.lastY = new float[0];
        }

        private boolean valid(float newNumber) {
            return newNumber == newNumber && newNumber != Float.POSITIVE_INFINITY && newNumber != Float.NEGATIVE_INFINITY;
        }

        public float xLabel(int xCoord, int signalColor) {
            if (xCoord < this.gL || xCoord > this.gR) {
                return 0.0f;
            }
            this.graphics.stroke(signalColor);
            this.graphics.strokeWeight(1.0f * this.scaleFactor);
            this.graphics.line((float)xCoord, (float)this.gT, (float)xCoord, (float)this.gB);
            return ProcessingGrapherexp3.map((float)xCoord, (float)this.gL, (float)this.gR, (float)this.minX, (float)this.maxX);
        }

        public void xLabel(float dataX, int signalColor) {
            if (dataX >= this.minX && dataX <= this.maxX) {
                this.graphics.stroke(signalColor);
                this.graphics.strokeWeight(1.0f * this.scaleFactor);
                this.graphics.line(ProcessingGrapherexp3.map((float)dataX, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR), (float)this.gT, ProcessingGrapherexp3.map((float)dataX, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR), (float)this.gB);
            }
        }

        public void graphType(int type) {
            if (type >= 0 && type <= 2) {
                this.plotType = type;
            }
        }

        public int graphType() {
            return this.plotType;
        }

        public void selected(boolean state) {
            this.highlighted = state;
        }

        public boolean selected() {
            return this.highlighted;
        }

        public boolean onGraph(int xCoord, int yCoord) {
            return xCoord >= this.cL && xCoord <= this.cR && yCoord >= this.cT && yCoord <= this.cB;
        }

        public float xGraphPos(int xCoord) {
            if (xCoord < this.gL) {
                xCoord = this.gL;
            } else if (xCoord > this.gR) {
                xCoord = this.gR;
            }
            return ProcessingGrapherexp3.map((float)xCoord, (float)this.gL, (float)this.gR, (float)0.0f, (float)1.0f);
        }

        public float yGraphPos(int yCoord) {
            if (yCoord < this.gT) {
                yCoord = this.gT;
            } else if (yCoord > this.gB) {
                yCoord = this.gB;
            }
            return ProcessingGrapherexp3.map((float)yCoord, (float)this.gT, (float)this.gB, (float)0.0f, (float)1.0f);
        }

        public void plotData(float dataX, float dataY, int type, int signalColor) {
            if (this.valid(dataY) && this.valid(dataX)) {
                int x2 = this.gL;
                while (this.lastY.length < type + 1) {
                    this.lastY = ProcessingGrapherexp3.append((float[])this.lastY, (float)Float.MIN_VALUE);
                }
                while (this.lastX.length < type + 1) {
                    this.lastX = ProcessingGrapherexp3.append((float[])this.lastX, (float)0.0f);
                }
                if (this.redrawGraph) {
                    this.drawGrid();
                }
                if (dataY > this.maxY) {
                    dataY = this.maxY;
                }
                if (dataY < this.minY) {
                    dataY = this.minY;
                }
                if (dataX > this.maxX) {
                    dataX = this.maxX;
                }
                if (dataX < this.minX) {
                    dataX = this.minX;
                }
                this.graphics.fill(signalColor);
                this.graphics.stroke(signalColor);
                this.graphics.strokeWeight(1.0f * this.scaleFactor);
                switch (this.plotType) {
                    case 1: {
                        x2 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)dataX, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR));
                        int y2 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)dataY, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT));
                        this.graphics.ellipse((float)x2, (float)y2, 1.0f * this.scaleFactor, 1.0f * this.scaleFactor);
                        break;
                    }
                    case 2: {
                        if (this.lastY[type] == Float.MIN_VALUE || this.lastY[type] == Float.MAX_VALUE) break;
                        this.graphics.noStroke();
                        int x1 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)this.lastX[type], (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR));
                        x2 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)dataX, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR));
                        int y1 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)dataY, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT));
                        int y2 = this.minY <= 0.0f ? ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)0.0f, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT)) : ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)this.minY, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT));
                        int oneSegment = ProcessingGrapherexp3.ceil((float)((float)(x2 - x1) / PApplet.parseFloat((int)this.lastX.length)));
                        x2 = this.lastX.length > 1 ? x1 + oneSegment : (x1 += oneSegment * type) + ProcessingGrapherexp3.ceil((float)((float)oneSegment / 1.5f));
                        this.graphics.rectMode(1);
                        this.graphics.rect((float)x1, (float)y1, (float)x2, (float)y2);
                        break;
                    }
                    default: {
                        if (this.lastY[type] == Float.MIN_VALUE) break;
                        int x1 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)this.lastX[type], (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR));
                        x2 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)dataX, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR));
                        int y1 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)this.lastY[type], (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT));
                        int y2 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)dataY, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT));
                        this.graphics.line((float)x1, (float)y1, (float)x2, (float)y2);
                    }
                }
                this.lastY[type] = dataY;
                this.lastX[type] = dataX;
            }
        }

        public void plotData(float dataY, int type) {
            while (this.lastY.length < type + 1) {
                this.lastY = ProcessingGrapherexp3.append((float[])this.lastY, (float)Float.MIN_VALUE);
            }
            while (this.lastX.length < type + 1) {
                this.lastX = ProcessingGrapherexp3.append((float[])this.lastX, (float)(-this.xStep));
            }
            this.plotData(this.lastX[type] + this.xStep, dataY, type);
        }

        public void plotData(float dataX, float dataY, int type) {
            int colorIndex = type - ProcessingGrapherexp3.this.c_colorlist.length * ProcessingGrapherexp3.floor((float)(type / ProcessingGrapherexp3.this.c_colorlist.length));
            this.plotData(dataX, dataY, type, ProcessingGrapherexp3.this.c_colorlist[colorIndex]);
        }

        public void plotRectangle(float dataY1, float dataY2, float dataX1, float dataX2, int areaColor) {
            if (dataY1 >= this.minY && dataY1 <= this.maxY && dataY2 >= this.minY && dataY2 <= this.maxY && dataX1 >= this.minX && dataX1 <= this.maxX && dataX2 >= this.minX && dataX2 <= this.maxX) {
                this.graphics.fill(areaColor);
                this.graphics.stroke(areaColor);
                this.graphics.strokeWeight(1.0f * this.scaleFactor);
                int x1 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)dataX1, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR));
                int x2 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)dataX2, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR));
                int y1 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)dataY1, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT));
                int y2 = ProcessingGrapherexp3.round((float)ProcessingGrapherexp3.map((float)dataY2, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT));
                this.graphics.rectMode(1);
                this.graphics.rect((float)x1, (float)y1, (float)x2, (float)y2);
            }
        }

        public void clearGraph() {
            float i;
            this.graphics.rectMode(0);
            this.graphics.noStroke();
            this.graphics.fill(ProcessingGrapherexp3.this.c_background);
            this.graphics.rect((float)this.gL, (float)this.gT - this.scaleFactor * 1.0f, (float)(this.gR - this.gL) + this.scaleFactor * 1.0f, (float)(this.gB - this.gT) + this.scaleFactor * 2.0f);
            this.graphics.strokeWeight(1.0f * this.scaleFactor);
            this.graphics.stroke(ProcessingGrapherexp3.this.c_graph_gridlines);
            if (this.gridLines && this.gridX != 0.0f) {
                i = this.offsetLeft;
                while (i < (float)this.gR) {
                    this.graphics.line(i, (float)this.gT, i, (float)this.gB);
                    i += this.gridX;
                }
            }
            if (this.gridLines && this.gridY != 0.0f) {
                i = this.offsetBottom;
                while (i > (float)this.gT) {
                    this.graphics.line((float)this.gL, i, (float)this.gR, i);
                    i -= this.gridY;
                }
            }
            float yZero = 0.0f;
            float xZero = 0.0f;
            if (this.minY > 0.0f) {
                yZero = this.minY;
            } else if (this.maxY < 0.0f) {
                yZero = this.maxY;
            }
            if (this.minX > 0.0f) {
                xZero = this.minX;
            } else if (this.maxX < 0.0f) {
                xZero = this.maxX;
            }
            this.graphics.stroke(ProcessingGrapherexp3.this.c_graph_axis);
            this.graphics.line(ProcessingGrapherexp3.map((float)xZero, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR), (float)this.gT, ProcessingGrapherexp3.map((float)xZero, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR), (float)this.gB);
            this.graphics.line((float)this.gL, ProcessingGrapherexp3.map((float)yZero, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT), (float)this.gR, ProcessingGrapherexp3.map((float)yZero, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT));
            this.resetGraph();
        }

        private double roundToIdeal(float num) {
            if (num == 0.0f) {
                return 0.0;
            }
            double d = Math.ceil(Math.log10(num < 0.0f ? -num : num));
            int power = 2 - (int)d;
            double magnitude = Math.pow(10.0, power);
            long shifted = Math.round((double)num * magnitude);
            shifted = ProcessingGrapherexp3.abs((float)shifted) > 75.0f ? (long)(num < 0.0f ? -100 : 100) : (ProcessingGrapherexp3.abs((float)shifted) > 30.0f ? (long)(num < 0.0f ? -50 : 50) : (ProcessingGrapherexp3.abs((float)shifted) > 23.0f ? (long)(num < 0.0f ? -25 : 25) : (ProcessingGrapherexp3.abs((float)shifted) > 15.0f ? (long)(num < 0.0f ? -20 : 20) : (long)(num < 0.0f ? -10 : 10))));
            return (double)shifted / magnitude;
        }

        private int calculateRequiredPrecision(double maxValue, double minValue, double segments) {
            double largeValue;
            if (segments == 0.0 || maxValue == minValue) {
                return 1;
            }
            double d = largeValue = maxValue < 0.0 ? -maxValue : maxValue;
            if (maxValue == 0.0 || -minValue > largeValue) {
                largeValue = minValue < 0.0 ? -minValue : minValue;
            }
            double d1 = Math.floor(Math.log10(segments < 0.0 ? -segments : segments));
            double d2 = Math.floor(Math.log10(largeValue));
            double removeMSN = Math.round(segments % Math.pow(10.0, d1) / Math.pow(10.0, d1 - 1.0));
            int value = ProcessingGrapherexp3.abs((int)((int)d2 - (int)d1)) + 1;
            if (removeMSN > 0.0 && removeMSN < 10.0) {
                ++value;
            }
            return value;
        }

        private String formatLabelText(double labelNumber, int precision) {
            String labelDecimal;
            String labelScientific = String.format("%." + precision + "g", labelNumber);
            if (labelScientific.contains(".")) {
                labelScientific = labelScientific.replaceAll("[0]+$", "").replaceAll("[.]+$", "");
            }
            if ((labelDecimal = String.format("%." + precision + "f", labelNumber)).contains(".")) {
                labelDecimal = labelDecimal.replaceAll("[0]+$", "").replaceAll("[.]+$", "");
            }
            if (labelDecimal.length() < 5 || labelDecimal.charAt(0) == '-' && labelDecimal.length() < 6) {
                return labelDecimal;
            }
            return labelScientific;
        }

        public void drawGrid() {
            String label;
            double x_leftPosition;
            int x_precision;
            double x_segment;
            this.redrawGraph = false;
            this.graphics.rectMode(0);
            this.graphics.noStroke();
            this.graphics.fill(ProcessingGrapherexp3.this.c_background);
            this.graphics.rect((float)this.cL, (float)this.cT, (float)(this.cR - this.cL), (float)(this.cB - this.cT));
            this.graphics.strokeWeight(1.0f * this.scaleFactor);
            this.graphics.stroke(ProcessingGrapherexp3.this.c_graph_border);
            if (this.cT > ProcessingGrapherexp3.round((float)(31.0f * this.scaleFactor))) {
                this.graphics.line((float)this.cL, (float)this.cT, (float)this.cR, (float)this.cT);
            }
            if (this.cL > 1) {
                this.graphics.line((float)this.cL, (float)this.cT, (float)this.cL, (float)this.cB);
            }
            this.graphics.line((float)this.cL, (float)this.cB, (float)this.cR, (float)this.cB);
            this.graphics.line((float)this.cR, (float)this.cT, (float)this.cR, (float)this.cB);
            this.graphics.textAlign(37, 101);
            this.graphics.textFont(ProcessingGrapherexp3.this.base_font);
            this.graphics.fill(ProcessingGrapherexp3.this.c_lightgrey);
            if (this.highlighted) {
                this.graphics.fill(ProcessingGrapherexp3.this.c_red);
            }
            this.graphics.text(this.plotName, (float)(this.cL + PApplet.parseInt((float)(5.0f * this.scaleFactor))), (float)(this.cT + PApplet.parseInt((float)(5.0f * this.scaleFactor))));
            float yZero = 0.0f;
            float xZero = 0.0f;
            if (this.minY > 0.0f) {
                yZero = this.minY;
            } else if (this.maxY < 0.0f) {
                yZero = this.maxY;
            }
            if (this.minX > 0.0f) {
                xZero = this.minX;
            } else if (this.maxX < 0.0f) {
                xZero = this.maxX;
            }
            this.graphics.textFont(ProcessingGrapherexp3.this.mono_font);
            int padding = PApplet.parseInt((float)(5.0f * this.scaleFactor));
            int textHeight = PApplet.parseInt((float)(this.graphics.textAscent() + this.graphics.textDescent() + (float)padding));
            float charWidth = this.graphics.textWidth("0");
            this.gT = this.cT + this.border + textHeight / 3;
            this.gB = this.cB - this.border - textHeight - this.graphMark;
            double y_segment = Math.abs(this.roundToIdeal((this.maxY - this.minY) * (float)(textHeight * 2) / (float)(this.gB - this.gT)));
            double y_basePosition = yZero;
            if (yZero > 0.0f) {
                y_basePosition = Math.ceil((double)this.minY / y_segment) * y_segment;
            } else if (yZero < 0.0f) {
                y_basePosition = -Math.ceil((double)(-this.maxY) / y_segment) * y_segment;
            }
            int y_precision = this.calculateRequiredPrecision(this.maxY, this.minY, y_segment);
            double y_bottomPosition = y_basePosition - Math.floor((y_basePosition - (double)this.minY) / y_segment) * y_segment;
            this.offsetBottom = ProcessingGrapherexp3.map((float)((float)y_bottomPosition), (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT);
            this.gridY = ProcessingGrapherexp3.map((float)((float)y_bottomPosition), (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT) - ProcessingGrapherexp3.map((float)((float)(y_bottomPosition + y_segment)), (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT);
            int yTextWidth = 0;
            String lastLabel = "";
            double i = y_bottomPosition;
            while (i <= (double)this.maxY) {
                int labelWidth;
                String label2 = this.formatLabelText(i, y_precision);
                if (label2.equals(lastLabel)) {
                    ++y_precision;
                }
                if ((labelWidth = PApplet.parseInt((float)((float)label2.length() * charWidth))) > yTextWidth) {
                    yTextWidth = labelWidth;
                }
                lastLabel = label2;
                i += y_segment;
            }
            this.gL = this.cL + this.border + yTextWidth + this.graphMark + padding;
            this.gR = this.cR - this.border;
            boolean solved = false;
            int xTextWidth = PApplet.parseInt((float)(charWidth * 3.0f));
            do {
                x_segment = Math.abs(this.roundToIdeal((this.maxX - this.minX) * (float)(xTextWidth * 3) / (float)(this.gR - this.gL)));
                double x_basePosition = xZero;
                if (xZero > 0.0f) {
                    x_basePosition = Math.ceil((double)this.minX / x_segment) * x_segment;
                } else if (xZero < 0.0f) {
                    x_basePosition = -Math.ceil((double)(-this.maxX) / x_segment) * x_segment;
                }
                x_precision = this.calculateRequiredPrecision(this.maxX, this.minX, x_segment);
                x_leftPosition = x_basePosition - Math.floor((x_basePosition - (double)this.minX) / x_segment) * x_segment;
                this.offsetLeft = ProcessingGrapherexp3.map((float)((float)x_leftPosition), (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR);
                this.gridX = ProcessingGrapherexp3.map((float)((float)(x_leftPosition + x_segment)), (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR) - ProcessingGrapherexp3.map((float)((float)x_leftPosition), (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR);
                int newxTextWidth = 0;
                lastLabel = "";
                double i2 = x_leftPosition;
                while (i2 <= (double)this.maxX) {
                    int labelWidth;
                    label = this.formatLabelText(i2, x_precision);
                    if (label.equals(lastLabel)) {
                        ++x_precision;
                    }
                    if ((labelWidth = PApplet.parseInt((float)((float)label.length() * charWidth))) > newxTextWidth) {
                        newxTextWidth = labelWidth;
                    }
                    lastLabel = label;
                    i2 += x_segment;
                }
                if (newxTextWidth <= xTextWidth) {
                    solved = true;
                    continue;
                }
                xTextWidth = newxTextWidth;
            } while (!solved);
            this.graphics.fill(ProcessingGrapherexp3.this.c_lightgrey);
            this.graphics.textAlign(39, 3);
            double i3 = y_bottomPosition;
            while (i3 <= (double)this.maxY) {
                float currentYpixel = ProcessingGrapherexp3.map((float)((float)i3), (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT);
                if (this.gridLines) {
                    this.graphics.stroke(ProcessingGrapherexp3.this.c_graph_gridlines);
                    this.graphics.line((float)this.gL, currentYpixel, (float)this.gR, currentYpixel);
                }
                label = this.formatLabelText(i3, y_precision);
                this.graphics.stroke(ProcessingGrapherexp3.this.c_graph_axis);
                this.graphics.text(label, (float)(this.gL - this.graphMark - padding), currentYpixel - 1.0f * this.scaleFactor);
                this.graphics.line((float)(this.gL - this.graphMark), currentYpixel, (float)(this.gL - ProcessingGrapherexp3.round((float)(1.0f * this.scaleFactor))), currentYpixel);
                if (i3 > y_bottomPosition) {
                    float minorYpixel = ProcessingGrapherexp3.map((float)((float)(i3 - y_segment / 2.0)), (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT);
                    this.graphics.line((float)this.gL - (float)this.graphMark / 2.0f, minorYpixel, (float)(this.gL - ProcessingGrapherexp3.round((float)(1.0f * this.scaleFactor))), minorYpixel);
                }
                i3 += y_segment;
            }
            this.graphics.textAlign(3, 101);
            if (this.xAxisName != "") {
                this.graphics.text(this.xAxisName, (float)((this.gL + this.gR) / 2), (float)(this.cB - this.border + padding));
            }
            i3 = x_leftPosition;
            while (i3 <= (double)this.maxX) {
                float currentXpixel = ProcessingGrapherexp3.map((float)((float)i3), (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR);
                if (this.gridLines) {
                    this.graphics.stroke(ProcessingGrapherexp3.this.c_graph_gridlines);
                    this.graphics.line(currentXpixel, (float)this.gT, currentXpixel, (float)this.gB);
                }
                label = this.formatLabelText(i3, x_precision);
                this.graphics.stroke(ProcessingGrapherexp3.this.c_graph_axis);
                this.graphics.line(currentXpixel, (float)this.gB, currentXpixel, (float)(this.gB + this.graphMark));
                if (i3 != (double)this.maxX) {
                    this.graphics.text(label, currentXpixel, (float)(this.gB + this.graphMark + padding));
                }
                if (i3 > x_leftPosition) {
                    float minorXpixel = ProcessingGrapherexp3.map((float)((float)(i3 - x_segment / 2.0)), (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR);
                    this.graphics.line(minorXpixel, (float)this.gB, minorXpixel, (float)this.gB + (float)this.graphMark / 2.0f);
                }
                i3 += x_segment;
            }
            this.graphics.stroke(ProcessingGrapherexp3.this.c_graph_axis);
            this.graphics.line(ProcessingGrapherexp3.map((float)xZero, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR), (float)this.gT, ProcessingGrapherexp3.map((float)xZero, (float)this.minX, (float)this.maxX, (float)this.gL, (float)this.gR), (float)this.gB);
            this.graphics.line((float)this.gL, ProcessingGrapherexp3.map((float)yZero, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT), (float)this.gR, ProcessingGrapherexp3.map((float)yZero, (float)this.minY, (float)this.maxY, (float)this.gB, (float)this.gT));
            this.graphics.textFont(ProcessingGrapherexp3.this.base_font);
        }
    }

    class LiveGraph
    implements TabAPI {
        int cL;
        int cR;
        int cT;
        int cB;
        Graph graphA;
        Graph graphB;
        Graph graphC;
        Graph graphD;
        int menuScroll;
        int menuHeight;
        String name;
        ScrollBar sidebarScroll;
        ReentrantLock lock;
        String outputfile;
        String[] dataColumns;
        int[] graphAssignment;
        int graphMode;
        CustomTable dataTable;
        boolean recordData;
        boolean tabIsVisible;
        int recordCounter;
        int fileCounter;
        int maxFileRows;
        int drawFrom;
        int pausedCount;
        float xRate;
        int selectedGraph;
        int customXaxis;
        int autoAxis;
        boolean autoFrequency;
        int frequencyCounter;
        int frequencyTimer;
        boolean isPaused;
        int maxSamples;
        int[] sampleWindow;
        float[] newMinimum;
        float[] newMaximum;
        float newXminimum;
        float newXmaximum;
        int signalListChange;
        int showdataset;

        LiveGraph(String setname, int left, int right, int top, int bottom) {
            this.sidebarScroll = new ScrollBar(false, false);
            this.lock = new ReentrantLock();
            this.dataColumns = new String[0];
            this.graphAssignment = new int[0];
            this.maxFileRows = 100000;
            this.sampleWindow = new int[]{1000, 1000, 1000, 1000};
            this.newMinimum = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            this.newMaximum = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            this.newXminimum = 0.0f;
            this.newXmaximum = 0.0f;
            this.showdataset = 1;
            this.name = setname;
            this.tabIsVisible = false;
            this.cL = left;
            this.cR = right;
            this.cT = top;
            this.cB = bottom;
            this.graphA = new Graph(this.cL, this.cR, this.cT, this.cB, 0.0f, 20.0f, 0.0f, 1.0f, "Graph 1");
            this.graphB = new Graph(this.cL, this.cR, (this.cT + this.cB) / 2, this.cB, 0.0f, 20.0f, 0.0f, 1.0f, "Graph 2");
            this.graphC = new Graph((this.cL + this.cR) / 2, this.cR, this.cT, (this.cT + this.cB) / 2, 0.0f, 20.0f, 0.0f, 1.0f, "Graph 3");
            this.graphD = new Graph((this.cL + this.cR) / 2, this.cR, (this.cT + this.cB) / 2, this.cB, 0.0f, 20.0f, 0.0f, 1.0f, "Graph 4");
            this.graphA.scale(ProcessingGrapherexp3.this.uimult);
            this.graphB.scale(ProcessingGrapherexp3.this.uimult);
            this.graphC.scale(ProcessingGrapherexp3.this.uimult);
            this.graphD.scale(ProcessingGrapherexp3.this.uimult);
            this.graphA.selected(true);
            this.graphA.xAxisTitle("Time (s)");
            this.graphB.xAxisTitle("Time (s)");
            this.graphC.xAxisTitle("Time (s)");
            this.graphD.xAxisTitle("Time (s)");
            this.graphA.yMin(0.0f);
            this.graphA.yMax(1025.0f);
            this.graphB.yMin(0.0f);
            this.graphB.yMax(1025.0f);
            this.graphMode = 1;
            this.selectedGraph = 1;
            this.outputfile = "No File Set";
            this.recordData = false;
            this.recordCounter = 0;
            this.fileCounter = 0;
            this.xRate = 100.0f;
            this.customXaxis = -1;
            this.autoAxis = 0;
            this.autoFrequency = true;
            this.frequencyCounter = 0;
            this.frequencyTimer = 0;
            this.isPaused = false;
            this.drawFrom = 0;
            this.pausedCount = 0;
            this.maxSamples = 10;
            this.signalListChange = 0;
            this.dataTable = new CustomTable();
            this.menuScroll = 0;
            this.menuHeight = this.cB - this.cT - 1;
            this.graphMode = 2;
            this.graphA.setSize(this.cL, this.cR, this.cT, (this.cT + this.cB) / 2);
            this.graphB.setSize(this.cL, this.cR, (this.cT + this.cB) / 2, this.cB);
            if (this.selectedGraph > 2) {
                this.selectedGraph = 2;
                this.graphA.selected(false);
                this.graphB.selected(true);
                this.graphC.selected(false);
                this.graphD.selected(false);
            }
            int i = 0;
            while (i < this.graphAssignment.length) {
                if (this.graphAssignment[i] > this.graphMode + 1) {
                    this.graphAssignment[i] = this.graphMode + 1;
                }
                ++i;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setVisibility(boolean newState) {
            this.tabIsVisible = newState;
        }

        @Override
        public void setMenuLevel(int newLevel) {
        }

        @Override
        public void drawContent() {
            this.graphA.drawGrid();
            this.graphA.resetGraph();
            if (this.graphMode > 1) {
                this.graphB.drawGrid();
                this.graphB.resetGraph();
            }
            if (this.graphMode > 2) {
                this.graphC.drawGrid();
                this.graphC.resetGraph();
            }
            if (this.graphMode > 3) {
                this.graphD.drawGrid();
                this.graphD.resetGraph();
            }
            if (this.dataTable.getRowCount() > 0) {
                this.drawNewData();
            }
            if (!ProcessingGrapherexp3.this.serialConnected) {
                if (ProcessingGrapherexp3.this.showInstructions) {
                    String[] message = new String[]{"1. In the 'Serial' tab, use the right-hand menu to connect to a serial device", "2. Press unlock", "3. In this tab press PPS1/2 TPS1/2"};
                    ProcessingGrapherexp3.this.drawMessageArea("Getting Started", message, (float)this.cL + 60.0f * ProcessingGrapherexp3.this.uimult, (float)this.cR - 60.0f * ProcessingGrapherexp3.this.uimult, (float)this.cT + 30.0f * ProcessingGrapherexp3.this.uimult);
                } else {
                    String messageText = "Serial Port Disconnected";
                    ProcessingGrapherexp3.this.rectMode(3);
                    ProcessingGrapherexp3.this.textAlign(3, 101);
                    ProcessingGrapherexp3.this.stroke(ProcessingGrapherexp3.this.c_alert_message_box);
                    ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_alert_message_box);
                    ProcessingGrapherexp3.this.rect((this.cR - this.cL) / 2, (float)this.cT + 15.0f * ProcessingGrapherexp3.this.uimult, ProcessingGrapherexp3.this.textWidth(messageText) + 10.0f * ProcessingGrapherexp3.this.uimult, 20.0f * ProcessingGrapherexp3.this.uimult);
                    ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_sidebar_heading);
                    ProcessingGrapherexp3.this.text(messageText, (this.cR - this.cL) / 2, this.cT + PApplet.parseInt((float)(5.0f * ProcessingGrapherexp3.this.uimult)));
                }
            } else if (this.isPaused) {
                String messageText = "Live Graph is Paused";
                ProcessingGrapherexp3.this.rectMode(3);
                ProcessingGrapherexp3.this.textAlign(3, 101);
                ProcessingGrapherexp3.this.stroke(ProcessingGrapherexp3.this.c_alert_message_box);
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_alert_message_box);
                ProcessingGrapherexp3.this.rect((this.cR - this.cL) / 2, (float)this.cT + 15.0f * ProcessingGrapherexp3.this.uimult, ProcessingGrapherexp3.this.textWidth(messageText) + 10.0f * ProcessingGrapherexp3.this.uimult, 20.0f * ProcessingGrapherexp3.this.uimult);
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_sidebar_heading);
                ProcessingGrapherexp3.this.text(messageText, (this.cR - this.cL) / 2, this.cT + PApplet.parseInt((float)(5.0f * ProcessingGrapherexp3.this.uimult)));
            }
        }

        @Override
        public void drawNewData() {
            this.lock.lock();
            int currentCount = this.dataTable.getRowCount();
            if (this.isPaused && this.pausedCount < currentCount) {
                currentCount = this.pausedCount;
            }
            if (currentCount > 0) {
                int samplesA = currentCount - this.sampleWindow[0] - 1;
                int samplesB = currentCount - this.sampleWindow[1] - 1;
                int samplesC = currentCount - this.sampleWindow[2] - 1;
                int samplesD = currentCount - this.sampleWindow[3] - 1;
                this.drawFrom = samplesA;
                this.graphA.clearGraph();
                if (this.graphMode >= 2) {
                    this.graphB.clearGraph();
                    if (samplesB < this.drawFrom) {
                        this.drawFrom = samplesB;
                    }
                }
                if (this.graphMode >= 3) {
                    this.graphC.clearGraph();
                    if (samplesC < this.drawFrom) {
                        this.drawFrom = samplesC;
                    }
                }
                if (this.graphMode >= 4) {
                    this.graphD.clearGraph();
                    if (samplesD < this.drawFrom) {
                        this.drawFrom = samplesD;
                    }
                }
                this.maxSamples = currentCount - this.drawFrom;
                if (this.drawFrom < 0) {
                    this.drawFrom = 0;
                }
                this.newMinimum[0] = Float.NaN;
                this.newMinimum[1] = Float.NaN;
                this.newMinimum[2] = Float.NaN;
                this.newMinimum[3] = Float.NaN;
                this.newXminimum = Float.NaN;
                this.newMaximum[0] = Float.NaN;
                this.newMaximum[1] = Float.NaN;
                this.newMaximum[2] = Float.NaN;
                this.newMaximum[3] = Float.NaN;
                this.newXmaximum = Float.NaN;
                int j = this.drawFrom;
                while (j < currentCount) {
                    int i = 0;
                    while (i < this.dataTable.getColumnCount()) {
                        if (i != this.customXaxis) {
                            try {
                                float dataPoint;
                                float xDataValue = 0.0f;
                                if (this.customXaxis >= 0) {
                                    xDataValue = (float)this.dataTable.getDouble(j, this.customXaxis);
                                }
                                if ((dataPoint = (float)this.dataTable.getDouble(j, i)) != dataPoint) {
                                    dataPoint = Float.MAX_VALUE;
                                }
                                if (this.graphAssignment[i] == 2 && this.graphMode >= 2 && samplesB <= this.drawFrom) {
                                    this.checkGraphSize(dataPoint, xDataValue, 1);
                                    if (this.customXaxis >= 0) {
                                        this.graphB.plotData(xDataValue, dataPoint, i);
                                    } else {
                                        this.graphB.plotData(dataPoint, i);
                                    }
                                } else if (this.graphAssignment[i] == 3 && this.graphMode >= 3 && samplesC <= this.drawFrom) {
                                    this.checkGraphSize(dataPoint, xDataValue, 2);
                                    if (this.customXaxis >= 0) {
                                        this.graphC.plotData(xDataValue, dataPoint, i);
                                    } else {
                                        this.graphC.plotData(dataPoint, i);
                                    }
                                } else if (this.graphAssignment[i] == 4 && this.graphMode >= 4 && samplesD <= this.drawFrom) {
                                    this.checkGraphSize(dataPoint, xDataValue, 3);
                                    if (this.customXaxis >= 0) {
                                        this.graphD.plotData(xDataValue, dataPoint, i);
                                    } else {
                                        this.graphD.plotData(dataPoint, i);
                                    }
                                } else if (this.graphAssignment[i] == 1 && samplesA <= this.drawFrom) {
                                    this.checkGraphSize(dataPoint, xDataValue, 0);
                                    if (this.customXaxis >= 0) {
                                        this.graphA.plotData(xDataValue, dataPoint, i);
                                    } else {
                                        this.graphA.plotData(dataPoint, i);
                                    }
                                }
                            }
                            catch (Exception e) {
                                ProcessingGrapherexp3.println((String)("LiveGraph::drawNewData() - drawFrom: " + this.drawFrom + ", currentCount: " + currentCount + ", Error: " + e));
                            }
                        }
                        ++i;
                    }
                    ++this.drawFrom;
                    ++j;
                }
                this.updateGraphSize(this.graphA, 0);
                if (this.graphMode >= 2) {
                    this.updateGraphSize(this.graphB, 1);
                }
                if (this.graphMode >= 3) {
                    this.updateGraphSize(this.graphC, 2);
                }
                if (this.graphMode >= 4) {
                    this.updateGraphSize(this.graphD, 3);
                }
            }
            this.lock.unlock();
        }

        public void checkGraphSize(float dataPoint, float xAxisPoint, int currentGraph) {
            if (this.autoAxis != 0 && dataPoint != Float.MAX_VALUE) {
                if (dataPoint < this.newMinimum[currentGraph] || Float.isNaN(this.newMinimum[currentGraph])) {
                    this.newMinimum[currentGraph] = dataPoint;
                } else if (dataPoint > this.newMaximum[currentGraph] || Float.isNaN(this.newMaximum[currentGraph])) {
                    this.newMaximum[currentGraph] = dataPoint;
                }
                if (this.customXaxis >= 0) {
                    if (xAxisPoint < this.newXminimum || Float.isNaN(this.newXminimum)) {
                        this.newXminimum = xAxisPoint;
                    } else if (xAxisPoint > this.newXmaximum || Float.isNaN(this.newXmaximum)) {
                        this.newXmaximum = xAxisPoint;
                    }
                }
            }
        }

        public void updateGraphSize(Graph currentGraph, int graphIndex) {
            boolean redrawGrid = false;
            if (this.autoAxis != 0 && !Float.isNaN(this.newMinimum[graphIndex]) && !Float.isNaN(this.newMaximum[graphIndex])) {
                this.newMinimum[graphIndex] = ProcessingGrapherexp3.this.floorToSigFig(this.newMinimum[graphIndex], 1);
                this.newMaximum[graphIndex] = ProcessingGrapherexp3.this.ceilToSigFig(this.newMaximum[graphIndex], 1);
                if (this.autoAxis == 1) {
                    if (currentGraph.yMin() > this.newMinimum[graphIndex]) {
                        currentGraph.yMin(this.newMinimum[graphIndex]);
                        redrawGrid = true;
                    }
                    if (currentGraph.yMax() < this.newMaximum[graphIndex]) {
                        currentGraph.yMax(this.newMaximum[graphIndex]);
                        redrawGrid = true;
                    }
                } else if (this.autoAxis == 2) {
                    if (currentGraph.yMin() != this.newMinimum[graphIndex]) {
                        currentGraph.yMin(this.newMinimum[graphIndex]);
                        redrawGrid = true;
                    }
                    if (currentGraph.yMax() != this.newMaximum[graphIndex]) {
                        currentGraph.yMax(this.newMaximum[graphIndex]);
                        redrawGrid = true;
                    }
                }
            }
            if (this.autoAxis != 0 && this.customXaxis >= 0 && !Float.isNaN(this.newXminimum) && !Float.isNaN(this.newXmaximum)) {
                this.newXminimum = ProcessingGrapherexp3.this.floorToSigFig(this.newXminimum, 1);
                this.newXmaximum = ProcessingGrapherexp3.this.ceilToSigFig(this.newXmaximum, 1);
                if (this.autoAxis == 1) {
                    if (currentGraph.xMin() > this.newXminimum) {
                        currentGraph.xMin(this.newXminimum);
                        redrawGrid = true;
                    }
                    if (currentGraph.xMax() < this.newXmaximum) {
                        currentGraph.xMax(this.newXmaximum);
                        redrawGrid = true;
                    }
                } else if (this.autoAxis == 2) {
                    if (currentGraph.xMin() != this.newXminimum) {
                        currentGraph.xMin(this.newXminimum);
                        redrawGrid = true;
                    }
                    if (currentGraph.xMax() != this.newXmaximum) {
                        currentGraph.xMax(this.newXmaximum);
                        redrawGrid = true;
                    }
                }
            }
            if (redrawGrid) {
                currentGraph.drawGrid();
                ProcessingGrapherexp3.this.redrawContent = true;
                ProcessingGrapherexp3.this.redrawUI = true;
            }
        }

        @Override
        public void changeSize(int newL, int newR, int newT, int newB) {
            this.cL = newL;
            this.cR = newR;
            this.cT = newT;
            this.cB = newB;
            this.graphA.scale(ProcessingGrapherexp3.this.uimult);
            this.graphB.scale(ProcessingGrapherexp3.this.uimult);
            this.graphC.scale(ProcessingGrapherexp3.this.uimult);
            this.graphD.scale(ProcessingGrapherexp3.this.uimult);
            if (this.graphMode == 2) {
                this.graphA.setSize(this.cL, this.cR, this.cT, (this.cT + this.cB) / 2);
                this.graphB.setSize(this.cL, this.cR, (this.cT + this.cB) / 2, this.cB);
            } else if (this.graphMode == 3) {
                this.graphA.setSize(this.cL, (this.cL + this.cR) / 2, this.cT, (this.cT + this.cB) / 2);
                this.graphB.setSize(this.cL, this.cR, (this.cT + this.cB) / 2, this.cB);
                this.graphC.setSize((this.cL + this.cR) / 2, this.cR, this.cT, (this.cT + this.cB) / 2);
            } else if (this.graphMode == 4) {
                this.graphA.setSize(this.cL, (this.cL + this.cR) / 2, this.cT, (this.cT + this.cB) / 2);
                this.graphB.setSize(this.cL, (this.cL + this.cR) / 2, (this.cT + this.cB) / 2, this.cB);
                this.graphC.setSize((this.cL + this.cR) / 2, this.cR, this.cT, (this.cT + this.cB) / 2);
                this.graphD.setSize((this.cL + this.cR) / 2, this.cR, (this.cT + this.cB) / 2, this.cB);
            } else {
                this.graphA.setSize(this.cL, this.cR, this.cT, this.cB);
            }
        }

        @Override
        public void setOutput(String newoutput) {
            if (newoutput != "No File Set") {
                int dotPos = newoutput.lastIndexOf(".");
                if (dotPos > 0) {
                    newoutput = newoutput.substring(0, dotPos);
                }
                if (ProcessingGrapherexp3.this.saveFile(newoutput = String.valueOf(newoutput) + ".csv") == null) {
                    ProcessingGrapherexp3.this.alertMessage("Error\nUnable to access the selected output file location; perhaps this location is write-protected?\n" + newoutput);
                    newoutput = "No File Set";
                }
            }
            this.outputfile = newoutput;
        }

        @Override
        public String getOutput() {
            return this.outputfile;
        }

        public void startRecording() {
            this.dataTable = new CustomTable();
            this.drawFrom = 0;
            this.pausedCount = 0;
            this.isPaused = false;
            ProcessingGrapherexp3.this.redrawContent = true;
            while (this.dataTable.getColumnCount() < this.dataColumns.length) {
                if (this.customXaxis >= 0 && this.customXaxis == this.dataTable.getColumnCount()) {
                    this.dataTable.addColumn("x:" + this.dataColumns[this.dataTable.getColumnCount()]);
                    continue;
                }
                this.dataTable.addColumn(this.dataColumns[this.dataTable.getColumnCount()]);
            }
            if (!this.dataTable.openCSVoutput(this.outputfile)) {
                ProcessingGrapherexp3.this.alertMessage("Error\nUnable to create the output file; perhaps the location no longer exists?\n" + this.outputfile);
            } else {
                this.recordCounter = 0;
                this.fileCounter = 0;
                this.recordData = true;
                ProcessingGrapherexp3.this.redrawUI = true;
            }
        }

        public void stopRecording() {
            this.recordData = false;
            if (this.dataTable.closeCSVoutput()) {
                ProcessingGrapherexp3.this.alertMessage("Success\nRecorded " + (this.fileCounter * 10000 + this.recordCounter) + " samples to " + (this.fileCounter + 1) + " CSV file(s)");
            } else {
                this.emergencyOutputSave(false);
            }
            this.outputfile = "No File Set";
            if (this.tabIsVisible) {
                ProcessingGrapherexp3.this.redrawUI = true;
            }
        }

        public void emergencyOutputSave(boolean continueRecording) {
            this.dataTable.closeCSVoutput();
            String[] tempSplit = ProcessingGrapherexp3.split((String)this.outputfile, (char)'/');
            int dotPos = tempSplit[tempSplit.length - 1].lastIndexOf(".");
            String nextoutputfile = tempSplit[tempSplit.length - 1].substring(0, dotPos);
            this.outputfile = String.valueOf(nextoutputfile) + "-backup.csv";
            String emergencysavefile = String.valueOf(nextoutputfile) + "-backup-" + (this.fileCounter + 1) + ".csv";
            try {
                ProcessingGrapherexp3.this.saveTable(this.dataTable, emergencysavefile);
                if (continueRecording) {
                    ++this.fileCounter;
                    if (this.dataTable.openCSVoutput(nextoutputfile = String.valueOf(nextoutputfile) + "-backup-" + (this.fileCounter + 1) + ".csv")) {
                        ProcessingGrapherexp3.this.alertMessage("Warning\nAn issue occurred when trying to save new data to the ouput file.\n1. A backup of all the data has been created\n2. Data is still being recorded (to a new file)\n3. The files are in the same directory as ProcessingGrapher.exe");
                    } else {
                        this.recordData = false;
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.alertMessage("Error - Recording Stopped\nAn issue occurred when trying to save new data to the ouput file.\n1. A backup of all the data has been created\n2. The files are in the same directory as ProcessingGrapher.exe");
                    }
                } else {
                    this.recordData = false;
                    ProcessingGrapherexp3.this.alertMessage("Error\nAn issue occurred when trying to save new data to the ouput file.\n1. Data recording has been stopped\n2. A backup of all the data has been created\n3. The backup is in the same directory as ProcessingGrapher.exe");
                }
            }
            catch (Exception e) {
                this.dataTable.closeCSVoutput();
                this.recordData = false;
                ProcessingGrapherexp3.this.alertMessage("Critical Error\nAn issue occurred when trying to save new data to the ouput file.\nData backup was also unsuccessful, so some data may have been lost...\n" + e);
            }
        }

        @Override
        public void connectionEvent(boolean status) {
            if (!status) {
                if (this.recordData) {
                    this.stopRecording();
                }
                this.frequencyCounter = 0;
                this.frequencyTimer = 0;
            }
        }

        @Override
        public void parsePortData(String inputData, boolean graphable) {
            block24: {
                block26: {
                    block25: {
                        if (!graphable) break block24;
                        String[] dataArray = ProcessingGrapherexp3.trim((String[])ProcessingGrapherexp3.split((String)inputData, (char)ProcessingGrapherexp3.this.separator));
                        if (this.autoFrequency && this.frequencyCounter != -1) {
                            if (this.frequencyCounter == 0) {
                                this.frequencyTimer = ProcessingGrapherexp3.this.millis();
                            }
                            ++this.frequencyCounter;
                            if (this.frequencyCounter > 20 && ProcessingGrapherexp3.this.millis() - this.frequencyTimer >= 10000) {
                                float newXrate = 1000.0f * (float)this.frequencyCounter / PApplet.parseFloat((int)(ProcessingGrapherexp3.this.millis() - this.frequencyTimer));
                                if (ProcessingGrapherexp3.abs((float)(newXrate - this.xRate)) > 2.0f) {
                                    this.xRate = ProcessingGrapherexp3.this.roundToSigFig(newXrate, 2);
                                    this.graphA.frequency(this.xRate);
                                    this.graphB.frequency(this.xRate);
                                    this.graphC.frequency(this.xRate);
                                    this.graphD.frequency(this.xRate);
                                    this.sampleWindow[0] = PApplet.parseInt((float)(this.xRate * ProcessingGrapherexp3.abs((float)(this.graphA.xMax() - this.graphA.xMin()))));
                                    this.sampleWindow[1] = PApplet.parseInt((float)(this.xRate * ProcessingGrapherexp3.abs((float)(this.graphB.xMax() - this.graphB.xMin()))));
                                    this.sampleWindow[2] = PApplet.parseInt((float)(this.xRate * ProcessingGrapherexp3.abs((float)(this.graphC.xMax() - this.graphC.xMin()))));
                                    this.sampleWindow[3] = PApplet.parseInt((float)(this.xRate * ProcessingGrapherexp3.abs((float)(this.graphD.xMax() - this.graphD.xMin()))));
                                    ProcessingGrapherexp3.this.redrawContent = true;
                                    ProcessingGrapherexp3.this.redrawUI = true;
                                }
                                this.frequencyCounter = 0;
                            }
                        }
                        while (this.dataColumns.length < dataArray.length) {
                            if (this.dataColumns.length == 0) {
                                this.dataColumns = ProcessingGrapherexp3.append((String[])this.dataColumns, (String)"PPS1");
                                this.graphAssignment = ProcessingGrapherexp3.append((int[])this.graphAssignment, (int)1);
                                this.dataTable.addColumn("PPS1" + (this.dataColumns.length + 1), 0);
                            }
                            if (this.dataColumns.length == 1) {
                                if (this.showdataset < 2) {
                                    this.dataColumns = ProcessingGrapherexp3.append((String[])this.dataColumns, (String)"PPS2");
                                    this.graphAssignment = ProcessingGrapherexp3.append((int[])this.graphAssignment, (int)1);
                                    this.dataTable.addColumn("PPS2" + (this.dataColumns.length + 1), 0);
                                } else {
                                    this.dataColumns = ProcessingGrapherexp3.append((String[])this.dataColumns, (String)"Target");
                                    this.graphAssignment = ProcessingGrapherexp3.append((int[])this.graphAssignment, (int)2);
                                    this.dataTable.addColumn("Target" + (this.dataColumns.length + 1), 0);
                                }
                            }
                            if (this.dataColumns.length == 2) {
                                this.dataColumns = ProcessingGrapherexp3.append((String[])this.dataColumns, (String)"TPS1");
                                this.graphAssignment = ProcessingGrapherexp3.append((int[])this.graphAssignment, (int)2);
                                this.dataTable.addColumn("TPS1" + (this.dataColumns.length + 1), 0);
                            }
                            if (this.dataColumns.length == 3) {
                                if (this.showdataset < 2) {
                                    this.dataColumns = ProcessingGrapherexp3.append((String[])this.dataColumns, (String)"TPS2");
                                    this.graphAssignment = ProcessingGrapherexp3.append((int[])this.graphAssignment, (int)2);
                                    this.dataTable.addColumn("TPS2" + (this.dataColumns.length + 1), 0);
                                } else {
                                    this.dataColumns = ProcessingGrapherexp3.append((String[])this.dataColumns, (String)"Motor Current");
                                    this.graphAssignment = ProcessingGrapherexp3.append((int[])this.graphAssignment, (int)3);
                                    this.dataTable.addColumn("Motor Current" + (this.dataColumns.length + 1), 0);
                                }
                            }
                            if (this.dataColumns.length == 4) {
                                this.dataColumns = ProcessingGrapherexp3.append((String[])this.dataColumns, (String)"PWM");
                                this.graphAssignment = ProcessingGrapherexp3.append((int[])this.graphAssignment, (int)3);
                                this.dataTable.addColumn("PWM" + (this.dataColumns.length + 1), 0);
                            }
                            ProcessingGrapherexp3.this.redrawUI = true;
                        }
                        if (this.dataColumns.length > dataArray.length) {
                            ++this.signalListChange;
                            if (this.signalListChange >= 10 && !this.recordData && !this.isPaused) {
                                this.dataColumns = ProcessingGrapherexp3.shorten((String[])this.dataColumns);
                                this.graphAssignment = ProcessingGrapherexp3.shorten((int[])this.graphAssignment);
                                this.dataTable.removeColumn(this.dataColumns.length);
                                this.signalListChange = 0;
                                ProcessingGrapherexp3.this.redrawUI = true;
                            }
                        }
                        this.lock.lock();
                        TableRow newRow = this.dataTable.addRow();
                        int i = 0;
                        while (i < dataArray.length) {
                            try {
                                double dataPoint = Double.parseDouble(dataArray[i]);
                                newRow.setDouble(i, dataPoint);
                            }
                            catch (Exception e) {
                                ProcessingGrapherexp3.print((Object[])new Object[]{e});
                                ProcessingGrapherexp3.println((String)" - When parsing live graph data");
                            }
                            ++i;
                        }
                        this.lock.unlock();
                        if (!this.recordData) break block25;
                        ++this.recordCounter;
                        if (!this.dataTable.saveCSVentries(this.dataTable.lastRowIndex(), this.dataTable.lastRowIndex())) {
                            this.emergencyOutputSave(true);
                        }
                        if (this.recordCounter < this.maxFileRows) break block26;
                        this.dataTable.closeCSVoutput();
                        ++this.fileCounter;
                        this.recordCounter = 0;
                        int dotPos = this.outputfile.lastIndexOf(".");
                        String nextoutputfile = this.outputfile.substring(0, dotPos);
                        nextoutputfile = String.valueOf(nextoutputfile) + "-" + (this.fileCounter + 1) + ".csv";
                        this.dataTable.clearRows();
                        this.drawFrom = 0;
                        if (this.dataTable.openCSVoutput(nextoutputfile)) break block26;
                        ProcessingGrapherexp3.println((String)"Failed to start recording to a new output file");
                        break block26;
                    }
                    if (!this.isPaused && !this.lock.isLocked()) {
                        while (this.dataTable.getRowCount() > this.maxSamples) {
                            this.lock.lock();
                            this.dataTable.removeRow(0);
                            --this.drawFrom;
                            if (this.drawFrom < 0) {
                                this.drawFrom = 0;
                            }
                            this.lock.unlock();
                        }
                    }
                }
                if (this.tabIsVisible) {
                    ProcessingGrapherexp3.this.drawNewData = true;
                }
            }
        }

        @Override
        public void drawSidebar() {
            int sT = this.cT;
            int sL = this.cR;
            int sW = ProcessingGrapherexp3.this.width - this.cR;
            int sH = ProcessingGrapherexp3.this.height - sT;
            int uH = ProcessingGrapherexp3.round((float)(30.0f * ProcessingGrapherexp3.this.uimult));
            int tH = ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult));
            int iH = ProcessingGrapherexp3.round((float)(25.0f * ProcessingGrapherexp3.this.uimult));
            int iL = ProcessingGrapherexp3.round((float)((float)sL + 10.0f * ProcessingGrapherexp3.this.uimult));
            int iW = ProcessingGrapherexp3.round((float)((float)sW - 20.0f * ProcessingGrapherexp3.this.uimult));
            this.menuHeight = ProcessingGrapherexp3.round((float)((13.5f + (float)this.dataColumns.length + (float)(this.graphMode + 1) * 0.75f) * (float)uH));
            if (this.menuHeight > sH) {
                if (this.menuScroll == -1) {
                    this.menuScroll = 0;
                } else if (this.menuScroll > this.menuHeight - sH) {
                    this.menuScroll = this.menuHeight - sH;
                }
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_serial_message_box);
                ProcessingGrapherexp3.this.rect(ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sH);
                int scrollbarSize = sH - ProcessingGrapherexp3.round((float)((float)sH * PApplet.parseFloat((int)(this.menuHeight - sH)) / (float)this.menuHeight));
                if (scrollbarSize < uH) {
                    scrollbarSize = uH;
                }
                int scrollbarOffset = ProcessingGrapherexp3.round((float)((float)(sH - scrollbarSize) * ((float)this.menuScroll / PApplet.parseFloat((int)(this.menuHeight - sH)))));
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.rect(ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT + scrollbarOffset, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, scrollbarSize);
                this.sidebarScroll.update(this.menuHeight, sH, ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT + scrollbarOffset, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, scrollbarSize);
                sT -= this.menuScroll;
                sL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
                iL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
            } else {
                this.menuScroll = -1;
            }
            ProcessingGrapherexp3.this.drawHeading("Record Graph Data", iL, sT + uH * 0, iW, tH);
            if (this.outputfile == "No File Set" || this.outputfile == "") {
                ProcessingGrapherexp3.this.drawButton("Set Output File", ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 1, iW, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox("Start Recording", ProcessingGrapherexp3.this.c_idletab_text, iL, sT + uH * 2, iW, iH, tH);
            } else {
                String[] fileParts = ProcessingGrapherexp3.split((String)this.outputfile, (char)'/');
                String fileName = fileParts[fileParts.length - 1];
                if (this.recordData) {
                    ProcessingGrapherexp3.this.drawDatabox(fileName, ProcessingGrapherexp3.this.c_idletab_text, iL, sT + uH * 1, iW, iH, tH);
                    ProcessingGrapherexp3.this.drawButton("Stop Recording", ProcessingGrapherexp3.this.c_sidebar_accent, iL, sT + uH * 2, iW, iH, tH);
                } else {
                    ProcessingGrapherexp3.this.drawDatabox(fileName, ProcessingGrapherexp3.this.c_sidebar_text, iL, sT + uH * 1, iW, iH, tH);
                    ProcessingGrapherexp3.this.drawButton("Start Recording", ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 2, iW, iH, tH);
                }
            }
            ProcessingGrapherexp3.this.drawButton("Show PPS/TPS", ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 4, iW, iH, tH);
            ProcessingGrapherexp3.this.drawButton("Show live data", ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 5, iW, iH, tH);
            Graph currentGraph = this.selectedGraph == 2 ? this.graphB : (this.selectedGraph == 3 ? this.graphC : (this.selectedGraph == 4 ? this.graphD : this.graphA));
            ProcessingGrapherexp3.this.drawHeading("Graph " + this.selectedGraph + " - Options", iL, (float)sT + (float)uH * 6.5f, iW, tH);
            ProcessingGrapherexp3.this.drawDatabox(ProcessingGrapherexp3.str((float)currentGraph.xMin()).replaceAll("[0]+$", "").replaceAll("[.]+$", ""), this.autoAxis != 2 && this.customXaxis >= 0 ? ProcessingGrapherexp3.this.c_sidebar_text : ProcessingGrapherexp3.this.c_idletab_text, iL, (float)sT + (float)uH * 7.5f, (float)(iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
            ProcessingGrapherexp3.this.drawButton("x", ProcessingGrapherexp3.this.c_sidebar_button, (float)(iL + iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, (float)sT + (float)uH * 7.5f, 12.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
            ProcessingGrapherexp3.this.drawDatabox(ProcessingGrapherexp3.str((float)currentGraph.xMax()).replaceAll("[0]+$", "").replaceAll("[.]+$", ""), this.autoAxis != 2 || this.customXaxis < 0 ? ProcessingGrapherexp3.this.c_sidebar_text : ProcessingGrapherexp3.this.c_idletab_text, (float)(iL + iW / 2) + 6.0f * ProcessingGrapherexp3.this.uimult, (float)sT + (float)uH * 7.5f, (float)(iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
            ProcessingGrapherexp3.this.drawDatabox(ProcessingGrapherexp3.str((float)currentGraph.yMin()).replaceAll("[0]+$", "").replaceAll("[.]+$", ""), this.autoAxis != 2 ? ProcessingGrapherexp3.this.c_sidebar_text : ProcessingGrapherexp3.this.c_idletab_text, iL, (float)sT + (float)uH * 8.5f, (float)(iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
            ProcessingGrapherexp3.this.drawButton("y", ProcessingGrapherexp3.this.c_sidebar_button, (float)(iL + iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, (float)sT + (float)uH * 8.5f, 12.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
            ProcessingGrapherexp3.this.drawDatabox(ProcessingGrapherexp3.str((float)currentGraph.yMax()).replaceAll("[0]+$", "").replaceAll("[.]+$", ""), this.autoAxis != 2 ? ProcessingGrapherexp3.this.c_sidebar_text : ProcessingGrapherexp3.this.c_idletab_text, (float)(iL + iW / 2) + 6.0f * ProcessingGrapherexp3.this.uimult, (float)sT + (float)uH * 8.5f, (float)(iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
            ProcessingGrapherexp3.this.drawButton("", !this.isPaused ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 10, iW / 4, iH, tH);
            ProcessingGrapherexp3.this.drawTriangle(ProcessingGrapherexp3.this.c_sidebar_text, (float)iL + 12.0f * ProcessingGrapherexp3.this.uimult, (float)(sT + uH * 10) + 8.0f * ProcessingGrapherexp3.this.uimult, (float)iL + 12.0f * ProcessingGrapherexp3.this.uimult, (float)(sT + uH * 10 + iH) - 8.0f * ProcessingGrapherexp3.this.uimult, (float)(iL + iW / 4) - 12.0f * ProcessingGrapherexp3.this.uimult, sT + uH * 10 + tH / 2 + 1);
            ProcessingGrapherexp3.this.drawButton("", this.isPaused ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL + iW / 4, sT + uH * 10, iW / 4 + 1, iH, tH);
            ProcessingGrapherexp3.this.drawButton("Clear", ProcessingGrapherexp3.this.c_sidebar_button, iL + iW / 2, sT + uH * 10, iW / 2, iH, tH);
            ProcessingGrapherexp3.this.drawRectangle(ProcessingGrapherexp3.this.c_sidebar_text, (float)(iL + iW / 4) + 12.0f * ProcessingGrapherexp3.this.uimult, (float)(sT + uH * 10) + 8.0f * ProcessingGrapherexp3.this.uimult, 3.0f * ProcessingGrapherexp3.this.uimult, (float)iH - 16.0f * ProcessingGrapherexp3.this.uimult);
            ProcessingGrapherexp3.this.drawRectangle(ProcessingGrapherexp3.this.c_sidebar_text, (float)(iL + iW / 2) - 12.0f * ProcessingGrapherexp3.this.uimult, (float)(sT + uH * 10) + 8.0f * ProcessingGrapherexp3.this.uimult, -3.0f * ProcessingGrapherexp3.this.uimult, (float)iH - 16.0f * ProcessingGrapherexp3.this.uimult);
            ProcessingGrapherexp3.this.drawRectangle(ProcessingGrapherexp3.this.c_sidebar_divider, iL + iW / 4, (float)(sT + uH * 10) + 1.0f * ProcessingGrapherexp3.this.uimult, 1.0f * ProcessingGrapherexp3.this.uimult, (float)iH - 2.0f * ProcessingGrapherexp3.this.uimult);
            ProcessingGrapherexp3.this.drawRectangle(ProcessingGrapherexp3.this.c_sidebar_divider, iL + iW / 2, (float)(sT + uH * 10) + 1.0f * ProcessingGrapherexp3.this.uimult, 1.0f * ProcessingGrapherexp3.this.uimult, (float)iH - 2.0f * ProcessingGrapherexp3.this.uimult);
            float tHnow = 11.0f;
            int j = 0;
            while (j < this.graphMode + 1) {
                if (j < this.graphMode) {
                    ProcessingGrapherexp3.this.drawText("Graph " + (j + 1), ProcessingGrapherexp3.this.c_idletab_text, iL, (float)sT + (float)uH * tHnow, iW, iH * 3 / 4);
                } else {
                    ProcessingGrapherexp3.this.drawText("Hidden", ProcessingGrapherexp3.this.c_idletab_text, iL, (float)sT + (float)uH * tHnow, iW, iH * 3 / 4);
                }
                tHnow += 0.75f;
                int itemCount = 0;
                int i = 0;
                while (i < this.dataColumns.length) {
                    if (this.graphAssignment[i] == j + 1) {
                        ProcessingGrapherexp3.this.drawDatabox(this.dataColumns[i], iL, (float)sT + (float)uH * tHnow, (float)iW - 40.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                        int buttonColor = ProcessingGrapherexp3.this.c_colorlist[i - ProcessingGrapherexp3.this.c_colorlist.length * ProcessingGrapherexp3.floor((float)(i / ProcessingGrapherexp3.this.c_colorlist.length))];
                        ProcessingGrapherexp3.this.drawButton("\u25b2", ProcessingGrapherexp3.this.c_sidebar, buttonColor, (float)(iL + iW) - 40.0f * ProcessingGrapherexp3.this.uimult, (float)sT + (float)uH * tHnow, 20.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                        ProcessingGrapherexp3.this.drawButton(this.graphAssignment[i] < this.graphMode + 1 ? "\u25bc" : "", ProcessingGrapherexp3.this.c_sidebar, buttonColor, (float)(iL + iW) - 20.0f * ProcessingGrapherexp3.this.uimult, (float)sT + (float)uH * tHnow, 20.0f * ProcessingGrapherexp3.this.uimult, iH, tH);
                        ProcessingGrapherexp3.this.drawRectangle(ProcessingGrapherexp3.this.c_sidebar_divider, (float)(iL + iW) - 20.0f * ProcessingGrapherexp3.this.uimult, (float)sT + (float)uH * tHnow + 1.0f * ProcessingGrapherexp3.this.uimult, 1.0f * ProcessingGrapherexp3.this.uimult, (float)iH - 2.0f * ProcessingGrapherexp3.this.uimult);
                        tHnow += 1.0f;
                        ++itemCount;
                    }
                    ++i;
                }
                if (itemCount == 0) {
                    ProcessingGrapherexp3.this.drawText("Empty", ProcessingGrapherexp3.this.c_idletab_text, iL + iW / 2, (float)sT + (float)uH * (tHnow - (float)itemCount - 0.75f), iW / 2, iH * 3 / 4);
                }
                ++j;
            }
        }

        @Override
        public void drawInfoBar() {
            int sW = ProcessingGrapherexp3.this.width - this.cR;
            ProcessingGrapherexp3.this.textAlign(37, 101);
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.base_font);
            ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_status_bar);
            ProcessingGrapherexp3.this.text("Output: " + ProcessingGrapherexp3.this.constrainString(this.outputfile, (float)(ProcessingGrapherexp3.this.width - sW - ProcessingGrapherexp3.round((float)(175.0f * ProcessingGrapherexp3.this.uimult))) - ProcessingGrapherexp3.this.textWidth("Output: ")), ProcessingGrapherexp3.round((float)(5.0f * ProcessingGrapherexp3.this.uimult)), ProcessingGrapherexp3.this.height - ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult)) + ProcessingGrapherexp3.round((float)(2.0f * ProcessingGrapherexp3.this.uimult)));
        }

        @Override
        public void keyboardInput(char keyChar, int keyCodeInt, boolean codedKey) {
            if (codedKey) {
                switch (keyCodeInt) {
                    case 38: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll = (int)((float)this.menuScroll - 12.0f * ProcessingGrapherexp3.this.uimult);
                            if (this.menuScroll < 0) {
                                this.menuScroll = 0;
                            }
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 40: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll = (int)((float)this.menuScroll + 12.0f * ProcessingGrapherexp3.this.uimult);
                            if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                                this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                            }
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 33: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll -= ProcessingGrapherexp3.this.height - this.cT;
                        if (this.menuScroll < 0) {
                            this.menuScroll = 0;
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 34: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll += ProcessingGrapherexp3.this.height - this.cT;
                        if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                            this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 35: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 36: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll = 0;
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 115: {
                        if (this.recordData) break;
                        this.outputfile = "";
                        ProcessingGrapherexp3.this.selectOutput("Select a location and name for the output *.CSV file", "fileSelected");
                        break;
                    }
                    case 117: {
                        if (this.recordData) {
                            this.stopRecording();
                            break;
                        }
                        if (this.outputfile == "" || this.outputfile == "No File Set") break;
                        this.startRecording();
                    }
                }
            }
        }

        @Override
        public void contentClick(int xcoord, int ycoord) {
            if (!(this.graphMode != 1 && ycoord > (this.cT + this.cB) / 2 || this.graphMode >= 3 && xcoord > (this.cL + this.cR) / 2)) {
                this.selectedGraph = 1;
                this.graphA.selected(true);
                this.graphB.selected(false);
                this.graphC.selected(false);
                this.graphD.selected(false);
                ProcessingGrapherexp3.this.redrawUI = true;
                ProcessingGrapherexp3.this.redrawContent = true;
            } else if (ycoord > (this.cT + this.cB) / 2 && this.graphMode > 1 && (xcoord <= (this.cL + this.cR) / 2 || this.graphMode < 4)) {
                this.selectedGraph = 2;
                this.graphA.selected(false);
                this.graphB.selected(true);
                this.graphC.selected(false);
                this.graphD.selected(false);
                ProcessingGrapherexp3.this.redrawUI = true;
                ProcessingGrapherexp3.this.redrawContent = true;
            } else if (ycoord <= (this.cT + this.cB) / 2 && this.graphMode > 2 && xcoord > (this.cL + this.cR) / 2) {
                this.selectedGraph = 3;
                this.graphA.selected(false);
                this.graphB.selected(false);
                this.graphC.selected(true);
                this.graphD.selected(false);
                ProcessingGrapherexp3.this.redrawUI = true;
                ProcessingGrapherexp3.this.redrawContent = true;
            } else if (ycoord > (this.cT + this.cB) / 2 && this.graphMode > 3 && xcoord > (this.cL + this.cR) / 2) {
                this.selectedGraph = 4;
                this.graphA.selected(false);
                this.graphB.selected(false);
                this.graphC.selected(false);
                this.graphD.selected(true);
                ProcessingGrapherexp3.this.redrawUI = true;
                ProcessingGrapherexp3.this.redrawContent = true;
            }
        }

        @Override
        public void scrollWheel(float amount) {
            if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                this.menuScroll = (int)((float)this.menuScroll + 30.0f * amount * ProcessingGrapherexp3.this.uimult);
                if (this.menuScroll < 0) {
                    this.menuScroll = 0;
                } else if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                    this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                }
            }
            ProcessingGrapherexp3.this.redrawUI = true;
        }

        @Override
        public void scrollBarUpdate(int xcoord, int ycoord) {
            if (this.sidebarScroll.active()) {
                int previousScroll = this.menuScroll;
                this.menuScroll = this.sidebarScroll.move(xcoord, ycoord, this.menuScroll, 0, this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT));
                if (previousScroll != this.menuScroll) {
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            }
        }

        @Override
        public void menuClick(int xcoord, int ycoord) {
            block31: {
                int iW;
                int iL;
                int iH;
                int uH;
                int sT;
                block40: {
                    block42: {
                        block41: {
                            block38: {
                                Graph currentGraph;
                                block39: {
                                    block36: {
                                        Graph currentGraph2;
                                        block37: {
                                            block35: {
                                                block34: {
                                                    block32: {
                                                        block33: {
                                                            block30: {
                                                                sT = this.cT;
                                                                int sL = this.cR;
                                                                if (this.menuScroll > 0) {
                                                                    sT -= this.menuScroll;
                                                                }
                                                                if (this.menuScroll != -1) {
                                                                    sL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
                                                                }
                                                                int sW = ProcessingGrapherexp3.this.width - this.cR;
                                                                uH = ProcessingGrapherexp3.round((float)(30.0f * ProcessingGrapherexp3.this.uimult));
                                                                ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult));
                                                                iH = ProcessingGrapherexp3.round((float)(25.0f * ProcessingGrapherexp3.this.uimult));
                                                                iL = ProcessingGrapherexp3.round((float)((float)sL + 10.0f * ProcessingGrapherexp3.this.uimult));
                                                                iW = PApplet.parseInt((float)((float)sW - 20.0f * ProcessingGrapherexp3.this.uimult));
                                                                if (this.menuScroll != -1 && this.sidebarScroll.click(xcoord, ycoord)) {
                                                                    ProcessingGrapherexp3.this.startScrolling(false);
                                                                }
                                                                if (!ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 1.0f, iL, iW)) break block30;
                                                                if (!this.recordData) {
                                                                    this.outputfile = "";
                                                                    ProcessingGrapherexp3.this.selectOutput("Select a location and name for the output *.CSV file", "fileSelected");
                                                                }
                                                                break block31;
                                                            }
                                                            if (!ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 2.0f, iL, iW)) break block32;
                                                            if (!this.recordData) break block33;
                                                            this.stopRecording();
                                                            break block31;
                                                        }
                                                        if (this.outputfile == "" || this.outputfile == "No File Set") break block31;
                                                        this.startRecording();
                                                        break block31;
                                                    }
                                                    if (!ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 4.0f, iL, iW)) break block34;
                                                    if (ProcessingGrapherexp3.this.serialConnected) {
                                                        ProcessingGrapherexp3.this.serialSend("v");
                                                    }
                                                    this.showdataset = 1;
                                                    this.dataTable.clearRows();
                                                    while (this.dataColumns.length > 0) {
                                                        this.dataColumns = ProcessingGrapherexp3.shorten((String[])this.dataColumns);
                                                        this.graphAssignment = ProcessingGrapherexp3.shorten((int[])this.graphAssignment);
                                                    }
                                                    while (this.dataTable.getColumnCount() > 0) {
                                                        this.dataTable.removeColumn(0);
                                                    }
                                                    this.drawFrom = 0;
                                                    this.frequencyCounter = 0;
                                                    this.frequencyTimer = 0;
                                                    this.signalListChange = 0;
                                                    this.graphA.yMin(0.0f);
                                                    this.graphA.yMax(1025.0f);
                                                    this.graphB.yMin(0.0f);
                                                    this.graphB.yMax(1025.0f);
                                                    ProcessingGrapherexp3.this.redrawUI = true;
                                                    break block31;
                                                }
                                                if (!ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 5.0f, iL, iW)) break block35;
                                                if (ProcessingGrapherexp3.this.serialConnected) {
                                                    ProcessingGrapherexp3.this.serialSend("z");
                                                }
                                                this.showdataset = 2;
                                                this.dataTable.clearRows();
                                                while (this.dataColumns.length > 0) {
                                                    this.dataColumns = ProcessingGrapherexp3.shorten((String[])this.dataColumns);
                                                    this.graphAssignment = ProcessingGrapherexp3.shorten((int[])this.graphAssignment);
                                                }
                                                while (this.dataTable.getColumnCount() > 0) {
                                                    this.dataTable.removeColumn(0);
                                                }
                                                this.drawFrom = 0;
                                                this.frequencyCounter = 0;
                                                this.frequencyTimer = 0;
                                                this.signalListChange = 0;
                                                this.graphA.yMin(0.0f);
                                                this.graphA.yMax(1025.0f);
                                                this.graphB.yMin(-50.0f);
                                                this.graphB.yMax(1025.0f);
                                                ProcessingGrapherexp3.this.redrawUI = true;
                                                break block31;
                                            }
                                            if (!ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 7.5f, iL, iW)) break block36;
                                            currentGraph2 = this.selectedGraph == 2 ? this.graphB : (this.selectedGraph == 3 ? this.graphC : (this.selectedGraph == 4 ? this.graphD : this.graphA));
                                            if (this.autoAxis == 2 || this.customXaxis < 0 || ProcessingGrapherexp3.this.mouseX <= iL || !((float)ProcessingGrapherexp3.this.mouseX < (float)(iL + iW / 2) - 6.0f * ProcessingGrapherexp3.this.uimult)) break block37;
                                            ValidateInput userInput = new ValidateInput("Set the X-axis Minimum Value", "Minimum:", ProcessingGrapherexp3.str((float)currentGraph2.xMin()));
                                            userInput.setErrorMessage("Error\nInvalid x-axis minimum value entered.\nPlease input a number less than the maximum x-axis value.");
                                            if (userInput.checkFloat(3, currentGraph2.xMax())) {
                                                this.graphA.xMin(userInput.getFloat());
                                                this.graphB.xMin(userInput.getFloat());
                                                this.graphC.xMin(userInput.getFloat());
                                                this.graphD.xMin(userInput.getFloat());
                                            }
                                            ProcessingGrapherexp3.this.redrawUI = true;
                                            ProcessingGrapherexp3.this.redrawContent = true;
                                            break block31;
                                        }
                                        if (this.autoAxis == 2 && this.customXaxis >= 0 || !ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW / 2 + PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)), iW / 2 - PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)))) break block31;
                                        ValidateInput userInput = new ValidateInput("Set the X-axis Maximum Value", "Maximum:", ProcessingGrapherexp3.str((float)currentGraph2.xMax()));
                                        userInput.setErrorMessage("Error\nInvalid x-axis maximum value entered.\nPlease input a number greater than 0.");
                                        if (userInput.checkFloat(1, 0.0f)) {
                                            if (this.customXaxis >= 0) {
                                                this.graphA.xMax(userInput.getFloat());
                                                this.graphB.xMax(userInput.getFloat());
                                                this.graphC.xMax(userInput.getFloat());
                                                this.graphD.xMax(userInput.getFloat());
                                            } else {
                                                currentGraph2.xMax(userInput.getFloat());
                                                this.sampleWindow[this.selectedGraph - 1] = PApplet.parseInt((float)(this.xRate * ProcessingGrapherexp3.abs((float)(currentGraph2.xMax() - currentGraph2.xMin()))));
                                            }
                                        }
                                        ProcessingGrapherexp3.this.redrawUI = true;
                                        ProcessingGrapherexp3.this.redrawContent = true;
                                        break block31;
                                    }
                                    if (!ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 8.5f, iL, iW) || this.autoAxis == 2) break block38;
                                    currentGraph = this.selectedGraph == 2 ? this.graphB : (this.selectedGraph == 3 ? this.graphC : (this.selectedGraph == 4 ? this.graphD : this.graphA));
                                    if (!ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 2 - PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)))) break block39;
                                    ValidateInput userInput = new ValidateInput("Set the Y-axis Minimum Value", "Minimum:", ProcessingGrapherexp3.str((float)currentGraph.yMin()));
                                    userInput.setErrorMessage("Error\nInvalid y-axis minimum value entered.\nThe number should be smaller the the maximum value.");
                                    if (userInput.checkFloat(3, currentGraph.yMax())) {
                                        currentGraph.yMin(userInput.getFloat());
                                    }
                                    ProcessingGrapherexp3.this.redrawUI = true;
                                    ProcessingGrapherexp3.this.redrawContent = true;
                                    break block31;
                                }
                                if (!ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW / 2 + PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)), iW / 2 - PApplet.parseInt((float)(6.0f * ProcessingGrapherexp3.this.uimult)))) break block31;
                                ValidateInput userInput = new ValidateInput("Set the Y-axis Maximum Value", "Maximum:", ProcessingGrapherexp3.str((float)currentGraph.yMax()));
                                userInput.setErrorMessage("Error\nInvalid y-axis maximum value entered.\nThe number should be larger the the minimum value.");
                                if (userInput.checkFloat(1, currentGraph.yMin())) {
                                    currentGraph.yMax(userInput.getFloat());
                                }
                                ProcessingGrapherexp3.this.redrawUI = true;
                                ProcessingGrapherexp3.this.redrawContent = true;
                                break block31;
                            }
                            if (!ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 10.0f, iL, iW)) break block40;
                            if (!ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 4)) break block41;
                            if (this.isPaused) {
                                this.pausedCount = this.dataTable.getRowCount();
                                this.isPaused = false;
                                ProcessingGrapherexp3.this.redrawUI = true;
                                ProcessingGrapherexp3.this.redrawContent = true;
                            }
                            break block31;
                        }
                        if (!ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW / 4 + 1, iW / 4)) break block42;
                        if (!this.isPaused) {
                            this.pausedCount = this.dataTable.getRowCount();
                            this.isPaused = true;
                            ProcessingGrapherexp3.this.redrawUI = true;
                            ProcessingGrapherexp3.this.redrawContent = true;
                        }
                        break block31;
                    }
                    if (!ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW / 2 + 1, iW / 2)) break block31;
                    this.dataTable.clearRows();
                    this.drawFrom = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                    ProcessingGrapherexp3.this.redrawContent = true;
                    break block31;
                }
                float tHnow = 11.0f;
                int j = 0;
                while (j < this.graphMode + 1) {
                    tHnow += 0.75f;
                    int i = 0;
                    while (i < this.dataColumns.length) {
                        if (this.graphAssignment[i] == j + 1) {
                            if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                                if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW - PApplet.parseInt((float)(20.0f * ProcessingGrapherexp3.this.uimult)), PApplet.parseInt((float)(20.0f * ProcessingGrapherexp3.this.uimult)))) {
                                    int n = i;
                                    this.graphAssignment[n] = this.graphAssignment[n] + 1;
                                    if (this.graphAssignment[i] > this.graphMode + 1) {
                                        this.graphAssignment[i] = this.graphMode + 1;
                                    }
                                    ProcessingGrapherexp3.this.redrawUI = true;
                                    ProcessingGrapherexp3.this.redrawContent = true;
                                } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW - PApplet.parseInt((float)(40.0f * ProcessingGrapherexp3.this.uimult)), PApplet.parseInt((float)(20.0f * ProcessingGrapherexp3.this.uimult)))) {
                                    int n = i;
                                    this.graphAssignment[n] = this.graphAssignment[n] - 1;
                                    if (this.graphAssignment[i] < 1) {
                                        if (this.customXaxis >= 0) {
                                            this.graphAssignment[this.customXaxis] = 1;
                                        }
                                        this.autoAxis = 2;
                                        this.customXaxis = i;
                                        this.sampleWindow[0] = 1000;
                                        this.sampleWindow[1] = 1000;
                                        this.sampleWindow[2] = 1000;
                                        this.sampleWindow[3] = 1000;
                                        this.graphA.xAxisTitle(this.dataColumns[i]);
                                        this.graphB.xAxisTitle(this.dataColumns[i]);
                                        this.graphC.xAxisTitle(this.dataColumns[i]);
                                        this.graphD.xAxisTitle(this.dataColumns[i]);
                                        this.graphAssignment[i] = -1;
                                        this.drawNewData();
                                    }
                                    ProcessingGrapherexp3.this.redrawUI = true;
                                    ProcessingGrapherexp3.this.redrawContent = true;
                                } else {
                                    String colname = ProcessingGrapherexp3.this.myShowInputDialog("Set the Data Signal Name", "Name:", this.dataColumns[i]);
                                    if (colname != null && colname.length() > 0) {
                                        this.dataColumns[i] = colname;
                                        ProcessingGrapherexp3.this.redrawUI = true;
                                    }
                                }
                            }
                            tHnow += 1.0f;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }

        @Override
        public boolean checkSafeExit() {
            return !this.recordData;
        }

        @Override
        public void performExit() {
            if (this.recordData) {
                this.stopRecording();
            }
        }
    }

    class ScrollBar {
        int x1;
        int w;
        int y1;
        int h;
        int totalElements;
        int totalLength;
        int startPosition;
        int mouseOffset;
        float movementScaler;
        boolean orientation;
        boolean inverted;
        boolean active;
        public static final boolean HORIZONTAL = true;
        public static final boolean VERTICAL = false;
        public static final boolean INVERT = true;
        public static final boolean NORMAL = false;

        ScrollBar(boolean orientation, boolean inverted) {
            this.orientation = orientation;
            this.inverted = inverted;
            this.mouseOffset = 0;
            this.active = false;
        }

        public boolean active() {
            return this.active;
        }

        public void active(boolean setActive) {
            this.active = setActive;
        }

        public void update(int totalElements, int totalLength, int xLeft, int yTop, int xWidth, int yHeight) {
            this.totalElements = totalElements;
            this.totalLength = totalLength;
            this.mouseOffset = !this.orientation ? (this.mouseOffset += yTop + yHeight - (this.y1 + this.h)) : (this.mouseOffset += xLeft + xWidth - (this.x1 + this.w));
            this.x1 = xLeft;
            this.w = xWidth;
            this.y1 = yTop;
            this.h = yHeight;
            this.movementScaler = (float)totalElements / (float)totalLength;
        }

        public boolean click(int xcoord, int ycoord) {
            if (xcoord >= this.x1 && xcoord <= this.x1 + this.w && ycoord >= this.y1 && ycoord <= this.y1 + this.h) {
                if (!this.orientation) {
                    this.mouseOffset = this.y1 + this.h - ycoord;
                    this.startPosition = ycoord;
                } else {
                    this.mouseOffset = this.x1 + this.w - xcoord;
                    this.startPosition = xcoord;
                }
                this.active = true;
                return true;
            }
            this.active = false;
            return false;
        }

        public int move(int xcoord, int ycoord, int currentScroll, int minScroll, int maxScroll) {
            int currentPosition;
            int elementsMoved;
            int mainCoord = ycoord;
            if (this.orientation) {
                mainCoord = xcoord;
            }
            if (ProcessingGrapherexp3.abs((int)(elementsMoved = PApplet.parseInt((float)((float)((currentPosition = mainCoord + this.mouseOffset) - (this.startPosition + this.mouseOffset)) * this.movementScaler)))) >= 1) {
                if (this.inverted) {
                    elementsMoved = -elementsMoved;
                }
                if (elementsMoved < 0 && currentScroll == minScroll || elementsMoved > 0 && currentScroll == maxScroll) {
                    if (!this.orientation) {
                        this.mouseOffset = this.y1 + this.h - ycoord;
                        this.startPosition = ycoord;
                    } else {
                        this.mouseOffset = this.x1 + this.w - xcoord;
                        this.startPosition = xcoord;
                    }
                } else {
                    if ((currentScroll += elementsMoved) < minScroll) {
                        currentScroll = minScroll;
                    } else if (currentScroll > maxScroll) {
                        currentScroll = maxScroll;
                    }
                    this.startPosition = mainCoord;
                }
            }
            return currentScroll;
        }
    }

    class SerialMonitor
    implements TabAPI {
        int cL;
        int cR;
        int cT;
        int cB;
        int border;
        int padding;
        int yTextHeight;
        int msgB;
        PrintWriter dataWriter;
        int msgBorder;
        int msgSize;
        int menuScroll;
        int menuHeight;
        int menuLevel;
        String name;
        String outputfile;
        boolean recordData;
        int recordCounter;
        int fileCounter;
        final int maxFileRows = 50000;
        ArrayList<SerialTag> serialTags = new ArrayList();
        int displayRows;
        final int maxBuffer = 50000;
        int scrollUp;
        ScrollBar serialScroll;
        ScrollBar sidebarScroll;
        String msgText;
        int cursorPosition;
        int[] msgTextBounds;
        boolean autoScroll;
        boolean tabIsVisible;
        boolean infoTextVisible;
        int msgBtnSize;
        int previousColor;
        int hueColor;
        int newColor;
        int colorSelector;
        final int[] baudRateList;
        SerialMessages serialBuffer;
        TextSelection inputTextSelection;
        TextSelection serialTextSelection;
        int activeArea;

        SerialMonitor(String setname, int left, int right, int top, int bottom) {
            this.serialScroll = new ScrollBar(false, true);
            this.sidebarScroll = new ScrollBar(false, false);
            this.msgText = "";
            this.msgTextBounds = new int[2];
            this.infoTextVisible = false;
            this.msgBtnSize = 0;
            this.previousColor = ProcessingGrapherexp3.this.c_red;
            this.hueColor = ProcessingGrapherexp3.this.c_red;
            this.newColor = ProcessingGrapherexp3.this.c_red;
            this.colorSelector = 0;
            this.baudRateList = new int[]{300, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 74880, 115200, 230400, 250000};
            this.inputTextSelection = new TextSelection();
            this.serialTextSelection = new TextSelection();
            this.activeArea = 0;
            this.name = setname;
            this.tabIsVisible = false;
            this.cL = left;
            this.cR = right;
            this.cT = top;
            this.cB = bottom;
            this.msgBorder = ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult));
            this.msgSize = ProcessingGrapherexp3.round((float)((float)(2 * this.msgBorder) + 30.0f * ProcessingGrapherexp3.this.uimult));
            this.border = ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult));
            this.padding = ProcessingGrapherexp3.round((float)(5.0f * ProcessingGrapherexp3.this.uimult));
            this.yTextHeight = ProcessingGrapherexp3.round((float)(12.0f * ProcessingGrapherexp3.this.uimult)) + this.padding;
            this.msgB = this.cT + this.msgSize;
            this.outputfile = "No File Set";
            this.recordData = false;
            this.recordCounter = 0;
            this.fileCounter = 0;
            this.scrollUp = 0;
            this.displayRows = 0;
            this.cursorPosition = 0;
            this.menuScroll = 0;
            this.menuHeight = this.cB - this.cT - 1;
            this.menuLevel = 0;
            this.autoScroll = true;
            this.serialTags.add(new SerialTag("SENT:", ProcessingGrapherexp3.this.c_colorlist[0]));
            this.serialTags.add(new SerialTag("[Info]", ProcessingGrapherexp3.this.c_colorlist[1]));
            this.serialBuffer = new SerialMessages(50000);
            this.serialBuffer.append("--- SERIAL MONITOR ---");
            if (ProcessingGrapherexp3.this.showInstructions) {
                this.infoTextVisible = true;
                this.serialBuffer.append("");
                this.serialBuffer.append("[Info] Choose COM port and press CONNECT");
                this.serialBuffer.append("");
                this.serialBuffer.append("[Info] Turn on Throttle controller and press Unlock");
                this.serialBuffer.append("[Info] Terminal should say Unlocked");
                this.serialBuffer.append("");
                this.serialBuffer.append("");
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setVisibility(boolean newState) {
            this.tabIsVisible = newState;
        }

        @Override
        public void setMenuLevel(int newLevel) {
            this.menuLevel = newLevel;
        }

        @Override
        public void drawContent() {
            int dist2;
            int dist4;
            ProcessingGrapherexp3.this.rectMode(1);
            ProcessingGrapherexp3.this.noStroke();
            ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_background);
            ProcessingGrapherexp3.this.rect(this.cL, this.cT, this.cR, this.cT + this.msgB);
            ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_serial_message_box);
            ProcessingGrapherexp3.this.rect(this.cL + this.msgBorder, this.cT + this.msgBorder, this.cR - this.msgBorder, this.msgB - this.msgBorder);
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.base_font);
            ProcessingGrapherexp3.this.textAlign(37, 101);
            String msgBtnText = "Send:";
            this.msgBtnSize = PApplet.parseInt((float)ProcessingGrapherexp3.this.textWidth(msgBtnText));
            ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
            ProcessingGrapherexp3.this.text(msgBtnText, this.cL + 2 * this.msgBorder, (float)(this.cT + this.msgBorder) + 6.5f * ProcessingGrapherexp3.this.uimult);
            ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_background);
            ProcessingGrapherexp3.this.stroke(ProcessingGrapherexp3.this.c_background);
            ProcessingGrapherexp3.this.strokeWeight(1.0f * ProcessingGrapherexp3.this.uimult);
            ProcessingGrapherexp3.this.line(this.cL + 3 * this.msgBorder + this.msgBtnSize, this.cT + this.msgBorder, this.cL + 3 * this.msgBorder + this.msgBtnSize, this.msgB - this.msgBorder);
            if (this.cursorPosition < 0) {
                this.cursorPosition = 0;
            } else if (this.cursorPosition > this.msgText.length()) {
                this.cursorPosition = this.msgText.length();
            }
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.mono_font);
            float charWidth = ProcessingGrapherexp3.this.textWidth("a");
            int maxChars = ProcessingGrapherexp3.floor((float)((float)(this.cR - this.cL - 6 * this.msgBorder - this.msgBtnSize) / charWidth));
            if (this.cursorPosition > this.msgTextBounds[1]) {
                this.msgTextBounds[0] = this.msgTextBounds[0] + (this.cursorPosition - this.msgTextBounds[1]);
                this.msgTextBounds[1] = this.cursorPosition;
            } else if (this.cursorPosition < this.msgTextBounds[0]) {
                this.msgTextBounds[1] = this.msgTextBounds[1] - (this.msgTextBounds[0] - this.cursorPosition);
                this.msgTextBounds[0] = this.cursorPosition;
            }
            if (this.msgTextBounds[1] - this.msgTextBounds[0] < maxChars || this.msgTextBounds[1] > this.msgText.length()) {
                this.msgTextBounds[1] = this.msgText.length();
                this.msgTextBounds[0] = this.msgText.length() - maxChars;
            }
            if (this.msgTextBounds[0] < 0) {
                this.msgTextBounds[0] = 0;
            }
            if (this.msgTextBounds[1] < 0) {
                this.msgTextBounds[1] = 0;
            }
            if (this.inputTextSelection.valid && this.inputTextSelection.startChar <= this.msgTextBounds[1] && this.inputTextSelection.endChar >= this.msgTextBounds[0]) {
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_highlight_background);
                ProcessingGrapherexp3.this.noStroke();
                ProcessingGrapherexp3.this.rectMode(1);
                float leftHighlight = this.cL + 4 * this.msgBorder + this.msgBtnSize;
                float rightHighlight = leftHighlight + (float)(this.msgTextBounds[1] - this.msgTextBounds[0]) * charWidth;
                if (this.inputTextSelection.startChar > this.msgTextBounds[0]) {
                    leftHighlight += (float)(this.inputTextSelection.startChar - this.msgTextBounds[0]) * charWidth;
                }
                if (this.inputTextSelection.endChar < this.msgTextBounds[1]) {
                    rightHighlight -= (float)(this.msgTextBounds[1] - this.inputTextSelection.endChar) * charWidth;
                }
                ProcessingGrapherexp3.this.rect(leftHighlight, this.cT + this.msgBorder + ProcessingGrapherexp3.round((float)(9.0f * ProcessingGrapherexp3.this.uimult)), rightHighlight, this.cT + this.msgBorder + ProcessingGrapherexp3.round((float)(9.0f * ProcessingGrapherexp3.this.uimult)) + this.yTextHeight);
            }
            if (!this.inputTextSelection.valid && this.activeArea == 0) {
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.stroke(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.rectMode(0);
                ProcessingGrapherexp3.this.rect((float)(this.cL + 4 * this.msgBorder + this.msgBtnSize) + (float)(this.cursorPosition - this.msgTextBounds[0]) * charWidth + (float)ProcessingGrapherexp3.round((float)(1.0f * ProcessingGrapherexp3.this.uimult)), this.cT + this.msgBorder + ProcessingGrapherexp3.round((float)(9.0f * ProcessingGrapherexp3.this.uimult)), ProcessingGrapherexp3.round((float)(2.0f * ProcessingGrapherexp3.this.uimult)), ProcessingGrapherexp3.round((float)(13.0f * ProcessingGrapherexp3.this.uimult)));
            }
            ProcessingGrapherexp3.this.rectMode(1);
            ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_message_text);
            ProcessingGrapherexp3.this.text(this.msgText.substring(this.msgTextBounds[0], this.msgTextBounds[1]), this.cL + 4 * this.msgBorder + this.msgBtnSize, this.cT + this.msgBorder + ProcessingGrapherexp3.round((float)(9.0f * ProcessingGrapherexp3.this.uimult)));
            if (this.msgTextBounds[0] > 0) {
                int halfWay = this.cT + this.msgBorder + ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult));
                int frontPos = this.cL + ProcessingGrapherexp3.round((float)(3.25f * (float)this.msgBorder)) + this.msgBtnSize;
                dist4 = ProcessingGrapherexp3.round((float)(4.0f * ProcessingGrapherexp3.this.uimult));
                dist2 = ProcessingGrapherexp3.round((float)(2.0f * ProcessingGrapherexp3.this.uimult));
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.stroke(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.triangle(frontPos, halfWay, frontPos + dist4, halfWay + dist2, frontPos + dist4, halfWay - dist2);
            }
            if (this.msgTextBounds[1] < this.msgText.length()) {
                int halfWay = this.cT + this.msgBorder + ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult));
                int backPos = this.cR - ProcessingGrapherexp3.round((float)(1.25f * (float)this.msgBorder));
                dist4 = ProcessingGrapherexp3.round((float)(4.0f * ProcessingGrapherexp3.this.uimult));
                dist2 = ProcessingGrapherexp3.round((float)(2.0f * ProcessingGrapherexp3.this.uimult));
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.stroke(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.triangle(backPos, halfWay, backPos - dist4, halfWay + dist2, backPos - dist4, halfWay - dist2);
            }
            this.drawNewData();
        }

        @Override
        public void drawNewData() {
            ProcessingGrapherexp3.this.rectMode(0);
            ProcessingGrapherexp3.this.noStroke();
            ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_background);
            ProcessingGrapherexp3.this.rect(this.cL, this.msgB, this.cR - this.cL, this.cB - this.msgB);
            this.displayRows = PApplet.parseInt((float)((this.cB - this.msgB - this.border) / this.yTextHeight));
            while (this.displayRows > this.serialBuffer.size() - this.scrollUp && this.scrollUp > 0) {
                --this.scrollUp;
                this.displayRows = this.serialBuffer.size() - this.scrollUp;
            }
            if (this.displayRows > this.serialBuffer.size() - this.scrollUp) {
                this.displayRows = this.serialBuffer.size() - this.scrollUp;
            }
            int totalHeight = this.displayRows * this.yTextHeight;
            ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_serial_message_box);
            ProcessingGrapherexp3.this.rect(this.cL, this.msgB, this.border / 2, totalHeight);
            ProcessingGrapherexp3.this.textAlign(37, 101);
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.mono_font);
            if (this.serialBuffer.size() > 0) {
                int scrollbarSize = totalHeight * this.displayRows / this.serialBuffer.size();
                if (scrollbarSize < this.yTextHeight) {
                    scrollbarSize = this.yTextHeight;
                }
                int scrollbarOffset = PApplet.parseInt((float)((float)(totalHeight - scrollbarSize) * (1.0f - (float)this.scrollUp / PApplet.parseFloat((int)(this.serialBuffer.size() - this.displayRows)))));
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.rect(this.cL, this.msgB + scrollbarOffset, this.border / 2, scrollbarSize);
                this.serialScroll.update(this.serialBuffer.size(), totalHeight, this.cL, this.msgB + scrollbarOffset, this.border / 2, scrollbarSize);
                totalHeight -= this.yTextHeight;
                float charWidth = ProcessingGrapherexp3.this.textWidth("a");
                int maxChars = ProcessingGrapherexp3.floor((float)((float)(this.cR - 2 * this.cL - 5 * this.border) / charWidth));
                int i = 0;
                while (i < this.displayRows) {
                    int textColor = ProcessingGrapherexp3.this.c_terminal_text;
                    int textIndex = this.serialBuffer.size() - 1 - i - this.scrollUp;
                    if (textIndex < 0) {
                        textIndex = 0;
                    }
                    String textRow = this.serialBuffer.get(textIndex);
                    for (SerialTag curTag : this.serialTags) {
                        if (!textRow.contains(curTag.tagText)) continue;
                        textColor = curTag.tagColor;
                    }
                    if (textRow.length() > maxChars) {
                        textRow = textRow.substring(0, maxChars - 1);
                        ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
                        ProcessingGrapherexp3.this.text(">>", this.cR - 2 * this.border, this.msgB + totalHeight);
                    }
                    if (this.serialTextSelection.valid) {
                        ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_highlight_background);
                        if (this.serialTextSelection.startLine < textIndex && this.serialTextSelection.endLine > textIndex) {
                            ProcessingGrapherexp3.this.rect(this.cL + 2 * this.border, this.msgB + totalHeight, (float)textRow.length() * charWidth, this.yTextHeight);
                        } else if (this.serialTextSelection.startLine == textIndex && this.serialTextSelection.endLine == textIndex) {
                            ProcessingGrapherexp3.this.rect((float)(this.cL + 2 * this.border) + charWidth * (float)this.serialTextSelection.startChar, this.msgB + totalHeight, (float)(this.serialTextSelection.endChar - this.serialTextSelection.startChar) * charWidth, this.yTextHeight);
                        } else if (this.serialTextSelection.startLine == textIndex && this.serialTextSelection.endLine > textIndex) {
                            ProcessingGrapherexp3.this.rect((float)(this.cL + 2 * this.border) + charWidth * (float)this.serialTextSelection.startChar, this.msgB + totalHeight, (float)(textRow.length() - this.serialTextSelection.startChar) * charWidth, this.yTextHeight);
                        } else if (this.serialTextSelection.startLine < textIndex && this.serialTextSelection.endLine == textIndex) {
                            ProcessingGrapherexp3.this.rect(this.cL + 2 * this.border, this.msgB + totalHeight, (float)this.serialTextSelection.endChar * charWidth, this.yTextHeight);
                        }
                    }
                    ProcessingGrapherexp3.this.fill(textColor);
                    ProcessingGrapherexp3.this.text(textRow, this.cL + 2 * this.border, this.msgB + totalHeight);
                    totalHeight -= this.yTextHeight;
                    ++i;
                }
                if (this.scrollUp > 0) {
                    ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_sidebar);
                    ProcessingGrapherexp3.this.rect((float)this.cR - 40.0f * ProcessingGrapherexp3.this.uimult, (float)this.cB - 40.0f * ProcessingGrapherexp3.this.uimult, 30.0f * ProcessingGrapherexp3.this.uimult, 30.0f * ProcessingGrapherexp3.this.uimult);
                    ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_background);
                    ProcessingGrapherexp3.this.strokeWeight(1.0f * ProcessingGrapherexp3.this.uimult);
                    ProcessingGrapherexp3.this.stroke(ProcessingGrapherexp3.this.c_terminal_text);
                    ProcessingGrapherexp3.this.triangle((float)this.cR - 30.0f * ProcessingGrapherexp3.this.uimult, (float)this.cB - 29.0f * ProcessingGrapherexp3.this.uimult, (float)this.cR - 20.0f * ProcessingGrapherexp3.this.uimult, (float)this.cB - 29.0f * ProcessingGrapherexp3.this.uimult, (float)this.cR - 25.0f * ProcessingGrapherexp3.this.uimult, (float)this.cB - 20.0f * ProcessingGrapherexp3.this.uimult);
                }
            } else if (this.recordData) {
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.text("Serial monitor has been cleared\n(A new save file has just been opened)", this.cL + 2 * this.border, this.msgB);
            } else {
                this.serialBuffer.append("--- PROCESSING SERIAL MONITOR ---");
                ProcessingGrapherexp3.this.drawNewData = true;
            }
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.base_font);
        }

        @Override
        public void changeSize(int newL, int newR, int newT, int newB) {
            this.cL = newL;
            this.cR = newR;
            this.cT = newT;
            this.cB = newB;
            this.msgBorder = ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult));
            this.msgSize = ProcessingGrapherexp3.round((float)((float)(2 * this.msgBorder) + 30.0f * ProcessingGrapherexp3.this.uimult));
            this.msgB = this.cT + this.msgSize;
            this.border = ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult));
            this.padding = ProcessingGrapherexp3.round((float)(5.0f * ProcessingGrapherexp3.this.uimult));
            this.yTextHeight = ProcessingGrapherexp3.round((float)(12.0f * ProcessingGrapherexp3.this.uimult)) + this.padding;
        }

        @Override
        public void setOutput(String newoutput) {
            if (newoutput != "No File Set") {
                int dotPos = newoutput.lastIndexOf(".");
                if (dotPos > 0) {
                    newoutput = newoutput.substring(0, dotPos);
                }
                if (ProcessingGrapherexp3.this.saveFile(newoutput = String.valueOf(newoutput) + ".txt") == null) {
                    ProcessingGrapherexp3.this.alertMessage("Error\nUnable to access the selected output file location; is this actually a writable location?\n" + newoutput);
                    newoutput = "No File Set";
                }
            }
            this.outputfile = newoutput;
        }

        @Override
        public String getOutput() {
            return this.outputfile;
        }

        public void startRecording() {
            try {
                File filePath = ProcessingGrapherexp3.this.saveFile(this.outputfile);
                this.dataWriter = ProcessingGrapherexp3.createWriter((File)filePath);
                this.serialBuffer.clear();
                this.scrollUp = 0;
                this.recordCounter = 0;
                this.fileCounter = 0;
                this.recordData = true;
                ProcessingGrapherexp3.this.redrawUI = true;
                ProcessingGrapherexp3.this.drawNewData = true;
            }
            catch (Exception e) {
                ProcessingGrapherexp3.println((Object)e);
                ProcessingGrapherexp3.this.alertMessage("Error\nUnable to create the output file:\n" + e);
            }
        }

        public void stopRecording() {
            this.recordData = false;
            try {
                this.dataWriter.flush();
                this.dataWriter.close();
                ProcessingGrapherexp3.this.alertMessage("Success\nRecorded " + (this.fileCounter * 10000 + this.recordCounter) + " entries to " + (this.fileCounter + 1) + " TXT file(s)");
            }
            catch (Exception e) {
                ProcessingGrapherexp3.println((Object)e);
                ProcessingGrapherexp3.this.alertMessage("Error\nUnable to save the output file:\n" + e);
            }
            this.outputfile = "No File Set";
            if (this.tabIsVisible) {
                ProcessingGrapherexp3.this.redrawUI = true;
            }
        }

        @Override
        public void connectionEvent(boolean status) {
            if (status && this.infoTextVisible) {
                this.infoTextVisible = false;
                if (!this.recordData) {
                    this.serialBuffer.clear();
                    this.serialBuffer.append("--- DATA from DBW controller ---");
                    this.scrollUp = 0;
                    this.serialTextSelection.setVisibility(false);
                    ProcessingGrapherexp3.this.drawNewData = true;
                }
            }
            if (!status && this.recordData) {
                this.stopRecording();
            }
        }

        @Override
        public void parsePortData(String inputData, boolean graphable) {
            this.serialBuffer.append(inputData, graphable);
            if (!this.autoScroll && this.scrollUp < 50000) {
                ++this.scrollUp;
            }
            if (this.recordData) {
                ++this.recordCounter;
                try {
                    this.dataWriter.println(inputData);
                    if (this.dataWriter.checkError()) {
                        this.emergencyOutputSave(true);
                    }
                    if (this.recordCounter >= 50000) {
                        this.dataWriter.close();
                        ++this.fileCounter;
                        this.recordCounter = 0;
                        int dotPos = this.outputfile.lastIndexOf(".");
                        String nextoutputfile = String.valueOf(this.outputfile.substring(0, dotPos)) + "-" + (this.fileCounter + 1) + ".txt";
                        File filePath = ProcessingGrapherexp3.this.saveFile(nextoutputfile);
                        this.dataWriter = ProcessingGrapherexp3.createWriter((File)filePath);
                        this.serialBuffer.clear();
                        this.scrollUp = 0;
                        ProcessingGrapherexp3.this.redrawUI = true;
                    }
                }
                catch (Exception exception) {
                    this.emergencyOutputSave(true);
                }
            }
            if (!this.serialBuffer.getVisibility() && graphable) {
                return;
            }
            if (this.tabIsVisible) {
                ProcessingGrapherexp3.this.drawNewData = true;
            }
        }

        public void emergencyOutputSave(boolean continueRecording) {
            this.dataWriter.close();
            String[] tempSplit = ProcessingGrapherexp3.split((String)this.outputfile, (char)'/');
            int dotPos = tempSplit[tempSplit.length - 1].lastIndexOf(".");
            String nextoutputfile = tempSplit[tempSplit.length - 1].substring(0, dotPos);
            this.outputfile = String.valueOf(nextoutputfile) + "-backup.txt";
            String emergencysavefile = String.valueOf(nextoutputfile) + "-backup-" + (this.fileCounter + 1) + ".txt";
            try {
                File filePath = ProcessingGrapherexp3.this.saveFile(emergencysavefile);
                this.dataWriter = ProcessingGrapherexp3.createWriter((File)filePath);
                int i = 0;
                while (i < this.serialBuffer.size()) {
                    this.dataWriter.println(this.serialBuffer.get(i));
                    ++i;
                }
                if (this.dataWriter.checkError()) {
                    continueRecording = false;
                }
                this.dataWriter.close();
                if (continueRecording) {
                    ++this.fileCounter;
                    filePath = ProcessingGrapherexp3.this.saveFile(nextoutputfile = String.valueOf(nextoutputfile) + "-backup-" + (this.fileCounter + 1) + ".txt");
                    if (filePath != null) {
                        ProcessingGrapherexp3.this.alertMessage("Warning\nAn issue occurred when trying to save new data to the ouput file.\n1. A backup of all the data has been created\n2. Data is still being recorded (to a new file)\n3. The files are in the same directory as ProcessingGrapher.exe");
                        this.dataWriter = ProcessingGrapherexp3.createWriter((File)filePath);
                        this.serialBuffer.clear();
                        this.scrollUp = 0;
                    } else {
                        this.recordData = false;
                        ProcessingGrapherexp3.this.alertMessage("Error - Recording Stopped\nAn issue occurred when trying to save new data to the ouput file.\n1. A backup of all the data has been created\n2. The files are in the same directory as ProcessingGrapher.exe");
                    }
                } else {
                    this.recordData = false;
                    ProcessingGrapherexp3.this.alertMessage("Error\nAn issue occurred when trying to save new data to the ouput file.\n1. Data recording has been stopped\n2. A backup of all the data has been created\n3. The backup is in the same directory as ProcessingGrapher.exe");
                }
                ProcessingGrapherexp3.this.redrawUI = true;
                ProcessingGrapherexp3.this.drawNewData = true;
            }
            catch (Exception e) {
                this.dataWriter.close();
                this.recordData = false;
                ProcessingGrapherexp3.this.redrawUI = true;
                ProcessingGrapherexp3.this.alertMessage("Critical Error\nAn issue occurred when trying to save new data to the ouput file.\nData backup was also unsuccessful, so some data may have been lost...\n" + e);
            }
        }

        @Override
        public void drawSidebar() {
            int i;
            int sT = this.cT;
            int sL = this.cR;
            int sW = ProcessingGrapherexp3.this.width - this.cR;
            int sH = ProcessingGrapherexp3.this.height - this.cT;
            int uH = ProcessingGrapherexp3.round((float)(30.0f * ProcessingGrapherexp3.this.uimult));
            int tH = ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult));
            int iH = ProcessingGrapherexp3.round((float)(25.0f * ProcessingGrapherexp3.this.uimult));
            int iL = ProcessingGrapherexp3.round((float)((float)sL + 10.0f * ProcessingGrapherexp3.this.uimult));
            int iW = ProcessingGrapherexp3.round((float)((float)sW - 20.0f * ProcessingGrapherexp3.this.uimult));
            String[] ports = Serial.list();
            if (this.menuLevel == 0) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((21 + this.serialTags.size()) * uH));
            } else if (this.menuLevel == 1) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((3 + ports.length) * uH));
            } else if (this.menuLevel == 2) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((4 + this.baudRateList.length) * uH));
            } else if (this.menuLevel == 3) {
                this.menuHeight = ProcessingGrapherexp3.round((float)(9 * uH + iW));
            }
            if (this.menuHeight > sH) {
                if (this.menuScroll == -1) {
                    this.menuScroll = 0;
                } else if (this.menuScroll > this.menuHeight - sH) {
                    this.menuScroll = this.menuHeight - sH;
                }
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_serial_message_box);
                ProcessingGrapherexp3.this.rect(ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sH);
                int scrollbarSize = sH - ProcessingGrapherexp3.round((float)((float)sH * PApplet.parseFloat((int)(this.menuHeight - sH)) / (float)this.menuHeight));
                if (scrollbarSize < uH) {
                    scrollbarSize = uH;
                }
                int scrollbarOffset = ProcessingGrapherexp3.round((float)((float)(sH - scrollbarSize) * ((float)this.menuScroll / PApplet.parseFloat((int)(this.menuHeight - sH)))));
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.rect(ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT + scrollbarOffset, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, scrollbarSize);
                this.sidebarScroll.update(this.menuHeight, sH, ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT + scrollbarOffset, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, scrollbarSize);
                sT -= this.menuScroll;
                sL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
                iL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
            } else {
                this.menuScroll = -1;
            }
            if (this.menuLevel == 0) {
                ProcessingGrapherexp3.this.drawHeading("Serial Port", iL, sT + uH * 0, iW, tH);
                if (ports.length == 0) {
                    ProcessingGrapherexp3.this.drawDatabox("Port: None", iL, sT + uH * 1, iW, iH, tH);
                } else if (ports.length <= ProcessingGrapherexp3.this.portNumber) {
                    ProcessingGrapherexp3.this.drawDatabox("Port: Invalid", iL, sT + uH * 1, iW, iH, tH);
                } else {
                    ProcessingGrapherexp3.this.drawDatabox("Port: " + ProcessingGrapherexp3.this.constrainString(ports[ProcessingGrapherexp3.this.portNumber], (float)iW - ProcessingGrapherexp3.this.textWidth("Port: ") - 15.0f * ProcessingGrapherexp3.this.uimult), iL, sT + uH * 1, iW, iH, tH);
                }
                ProcessingGrapherexp3.this.drawButton(ProcessingGrapherexp3.this.serialConnected ? "Disconnect" : "Connect", ProcessingGrapherexp3.this.serialConnected ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 2, iW, iH, tH);
                ProcessingGrapherexp3.this.drawButton("Unlock", ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 3, iW, iH, tH);
                ProcessingGrapherexp3.this.drawHeading("Controller", iL, (float)sT + (float)uH * 4.5f, iW, tH);
                ProcessingGrapherexp3.this.drawButton("Show CALdata", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 5.5f, iW, iH, tH);
                ProcessingGrapherexp3.this.drawButton("CAN on/off", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 6.5f, iW, iH, tH);
                ProcessingGrapherexp3.this.drawButton("OverC on/off", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 7.5f, iW, iH, tH);
                ProcessingGrapherexp3.this.drawButton("Unsafe mode", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 8.5f, iW, iH, tH);
                ProcessingGrapherexp3.this.drawButton("SAVE", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 9.5f, iW, iH, tH);
                ProcessingGrapherexp3.this.drawButton("SAVE to file", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 10.5f, iW, iH, tH);
                ProcessingGrapherexp3.this.drawButton("Load from file", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 11.5f, iW, iH, tH);
                ProcessingGrapherexp3.this.drawButton("Advanced settings", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 12.5f, iW, iH, tH);
                ProcessingGrapherexp3.this.drawHeading("Record Messages", iL, sT + uH * 14, iW, tH);
                if (this.outputfile == "No File Set" || this.outputfile == "") {
                    ProcessingGrapherexp3.this.drawButton("Set Output File", ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 15, iW, iH, tH);
                    ProcessingGrapherexp3.this.drawDatabox("Start Recording", ProcessingGrapherexp3.this.c_idletab_text, iL, sT + uH * 16, iW, iH, tH);
                } else {
                    String[] fileParts = ProcessingGrapherexp3.split((String)this.outputfile, (char)'/');
                    String fileName = fileParts[fileParts.length - 1];
                    if (this.recordData) {
                        ProcessingGrapherexp3.this.drawDatabox(fileName, ProcessingGrapherexp3.this.c_idletab_text, iL, sT + uH * 15, iW, iH, tH);
                        ProcessingGrapherexp3.this.drawButton("Stop Recording", ProcessingGrapherexp3.this.c_sidebar_accent, iL, sT + uH * 16, iW, iH, tH);
                    } else {
                        ProcessingGrapherexp3.this.drawDatabox(fileName, ProcessingGrapherexp3.this.c_sidebar_text, iL, sT + uH * 15, iW, iH, tH);
                        ProcessingGrapherexp3.this.drawButton("Start Recording", ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 16, iW, iH, tH);
                    }
                }
                ProcessingGrapherexp3.this.drawHeading("Terminal Options", iL, (float)sT + (float)uH * 17.5f, iW, tH);
                if (this.recordData) {
                    ProcessingGrapherexp3.this.drawDatabox("Clear Terminal", ProcessingGrapherexp3.this.c_idletab_text, iL, (float)sT + (float)uH * 18.5f, iW, iH, tH);
                } else {
                    ProcessingGrapherexp3.this.drawButton("Clear Terminal", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 18.5f, iW, iH, tH);
                }
                ProcessingGrapherexp3.this.drawButton(this.autoScroll ? "Autoscroll: On" : "Autoscroll: Off", this.autoScroll ? ProcessingGrapherexp3.this.c_sidebar_button : ProcessingGrapherexp3.this.c_sidebar_accent, iL, (float)sT + (float)uH * 19.5f, iW, iH, tH);
            } else if (this.menuLevel == 1) {
                ProcessingGrapherexp3.this.drawHeading("Select a Port", iL, sT + uH * 0, iW, tH);
                float tHnow = 1.0f;
                if (ports.length == 0) {
                    ProcessingGrapherexp3.this.drawText("No devices detected", ProcessingGrapherexp3.this.c_sidebar_text, iL, (float)sT + (float)uH * tHnow, iW, iH);
                    tHnow += 1.0f;
                } else {
                    i = 0;
                    while (i < ports.length) {
                        ProcessingGrapherexp3.this.drawButton(ProcessingGrapherexp3.this.constrainString(ports[i], (float)iW - 10.0f * ProcessingGrapherexp3.this.uimult), ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * tHnow, iW, iH, tH);
                        tHnow += 1.0f;
                        ++i;
                    }
                }
                ProcessingGrapherexp3.this.drawButton("Cancel", ProcessingGrapherexp3.this.c_sidebar_accent, iL, (float)sT + (float)uH * (tHnow += 0.5f), iW, iH, tH);
            } else if (this.menuLevel == 2) {
                ProcessingGrapherexp3.this.drawHeading("Select Baud Rate", iL, sT + uH * 0, iW, tH);
                float tHnow = 1.0f;
                i = 0;
                while (i < this.baudRateList.length) {
                    ProcessingGrapherexp3.this.drawButton(ProcessingGrapherexp3.str((int)this.baudRateList[i]), ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * tHnow, iW, iH, tH);
                    tHnow += 1.0f;
                    ++i;
                }
                ProcessingGrapherexp3.this.drawButton("More Options", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * (tHnow += 0.5f), iW, iH, tH);
                ProcessingGrapherexp3.this.drawButton("Cancel", ProcessingGrapherexp3.this.c_sidebar_accent, iL, (float)sT + (float)uH * (tHnow + 1.0f), iW, iH, tH);
            }
        }

        @Override
        public void drawInfoBar() {
            int sW = ProcessingGrapherexp3.this.width - this.cR;
            ProcessingGrapherexp3.this.textAlign(37, 101);
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.base_font);
            ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_status_bar);
            ProcessingGrapherexp3.this.text("Output: " + ProcessingGrapherexp3.this.constrainString(this.outputfile, (float)(ProcessingGrapherexp3.this.width - sW - ProcessingGrapherexp3.round((float)(175.0f * ProcessingGrapherexp3.this.uimult))) - ProcessingGrapherexp3.this.textWidth("Output: ")), ProcessingGrapherexp3.round((float)(5.0f * ProcessingGrapherexp3.this.uimult)), ProcessingGrapherexp3.this.height - ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult)) + ProcessingGrapherexp3.round((float)(2.0f * ProcessingGrapherexp3.this.uimult)));
        }

        @Override
        public void keyboardInput(char keyChar, int keyCodeInt, boolean codedKey) {
            if (!codedKey && ' ' <= keyChar && keyChar <= '~') {
                String msg;
                this.serialTextSelection.setVisibility(false);
                if (this.inputTextSelection.valid) {
                    this.msgText = msg = String.valueOf(this.msgText.substring(0, this.inputTextSelection.startChar)) + this.msgText.substring(this.inputTextSelection.endChar, this.msgText.length());
                    this.cursorPosition = this.inputTextSelection.startChar;
                    this.inputTextSelection.setVisibility(false);
                }
                if (this.cursorPosition < this.msgText.length()) {
                    if (this.cursorPosition == 0) {
                        this.msgText = String.valueOf(keyChar) + this.msgText;
                    } else {
                        msg = String.valueOf(this.msgText.substring(0, this.cursorPosition)) + keyChar;
                        this.msgText = msg = String.valueOf(msg) + this.msgText.substring(this.cursorPosition, this.msgText.length());
                    }
                } else {
                    this.msgText = String.valueOf(this.msgText) + keyChar;
                }
                ++this.cursorPosition;
                this.activeArea = 0;
                ProcessingGrapherexp3.this.redrawContent = true;
            } else {
                switch (keyCodeInt) {
                    case 27: {
                        if (this.menuLevel != 0) {
                            this.menuLevel = 0;
                            this.menuScroll = 0;
                            ProcessingGrapherexp3.this.redrawUI = true;
                            break;
                        }
                        if (this.serialTextSelection.valid) {
                            this.serialTextSelection.setVisibility(false);
                            ProcessingGrapherexp3.this.redrawContent = true;
                            break;
                        }
                        if (!this.inputTextSelection.valid) break;
                        this.inputTextSelection.setVisibility(false);
                        ProcessingGrapherexp3.this.redrawContent = true;
                        break;
                    }
                    case 10: 
                    case 13: {
                        if (this.msgText == "") break;
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.serialSend(this.msgText);
                        }
                        this.msgText = "SENT: " + this.msgText;
                        this.serialBuffer.append(this.msgText);
                        this.inputTextSelection.setVisibility(false);
                        this.msgText = "";
                        this.cursorPosition = 0;
                        if (!this.autoScroll) {
                            ++this.scrollUp;
                        }
                        ProcessingGrapherexp3.this.redrawContent = true;
                        break;
                    }
                    case 8: {
                        if (this.msgText == "") break;
                        if (this.inputTextSelection.valid) {
                            String msg;
                            this.msgText = msg = String.valueOf(this.msgText.substring(0, this.inputTextSelection.startChar)) + this.msgText.substring(this.inputTextSelection.endChar, this.msgText.length());
                            this.cursorPosition = this.inputTextSelection.startChar;
                            this.inputTextSelection.setVisibility(false);
                        } else if (this.cursorPosition < this.msgText.length() && this.cursorPosition > 0) {
                            String msg;
                            this.msgText = msg = String.valueOf(this.msgText.substring(0, this.cursorPosition - 1)) + this.msgText.substring(this.cursorPosition, this.msgText.length());
                            --this.cursorPosition;
                        } else if (this.cursorPosition >= this.msgText.length() && this.msgText.length() > 1) {
                            this.msgText = this.msgText.substring(0, this.msgText.length() - 1);
                            --this.cursorPosition;
                            if (this.cursorPosition < 0) {
                                this.cursorPosition = 0;
                            }
                        } else if (this.cursorPosition >= this.msgText.length() && this.msgText.length() <= 1) {
                            this.msgText = "";
                            this.cursorPosition = 0;
                        }
                        this.activeArea = 0;
                        ProcessingGrapherexp3.this.redrawContent = true;
                        break;
                    }
                    case 127: {
                        if (this.msgText == "") break;
                        if (this.inputTextSelection.valid) {
                            String msg;
                            this.msgText = msg = String.valueOf(this.msgText.substring(0, this.inputTextSelection.startChar)) + this.msgText.substring(this.inputTextSelection.endChar, this.msgText.length());
                            this.cursorPosition = this.inputTextSelection.startChar;
                            this.inputTextSelection.setVisibility(false);
                        } else if (this.cursorPosition + 1 < this.msgText.length() && this.cursorPosition > 0) {
                            String msg;
                            this.msgText = msg = String.valueOf(this.msgText.substring(0, this.cursorPosition)) + this.msgText.substring(this.cursorPosition + 1, this.msgText.length());
                        } else if (this.cursorPosition + 1 == this.msgText.length() && this.msgText.length() > 1) {
                            this.msgText = this.msgText.substring(0, this.msgText.length() - 1);
                        } else if (this.cursorPosition == 0 && this.msgText.length() > 1) {
                            this.msgText = this.msgText.substring(1, this.msgText.length());
                        } else if (this.cursorPosition == 0 && this.msgText.length() <= 1) {
                            this.msgText = "";
                            this.cursorPosition = 0;
                        }
                        this.activeArea = 0;
                        ProcessingGrapherexp3.this.redrawContent = true;
                        break;
                    }
                    case 39: {
                        this.cursorPosition = this.cursorPosition < this.msgText.length() ? ++this.cursorPosition : this.msgText.length();
                        this.serialTextSelection.setVisibility(false);
                        this.activeArea = 0;
                        ProcessingGrapherexp3.this.redrawContent = true;
                        break;
                    }
                    case 37: {
                        this.cursorPosition = this.cursorPosition > 0 ? --this.cursorPosition : 0;
                        this.serialTextSelection.setVisibility(false);
                        this.activeArea = 0;
                        ProcessingGrapherexp3.this.redrawContent = true;
                        break;
                    }
                    case 38: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll = (int)((float)this.menuScroll - 12.0f * ProcessingGrapherexp3.this.uimult);
                            if (this.menuScroll < 0) {
                                this.menuScroll = 0;
                            }
                            ProcessingGrapherexp3.this.redrawUI = true;
                            break;
                        }
                        int previousScroll = this.scrollUp;
                        this.scrollUp = this.scrollUp < this.serialBuffer.size() - this.displayRows ? ++this.scrollUp : this.serialBuffer.size() - this.displayRows;
                        ProcessingGrapherexp3.this.drawNewData = true;
                        if (previousScroll != 0 || this.scrollUp <= 0) break;
                        this.autoScroll = false;
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 40: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll = (int)((float)this.menuScroll + 12.0f * ProcessingGrapherexp3.this.uimult);
                            if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                                this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                            }
                            ProcessingGrapherexp3.this.redrawUI = true;
                            break;
                        }
                        int previousScroll = this.scrollUp;
                        this.scrollUp = this.scrollUp > 0 ? --this.scrollUp : 0;
                        ProcessingGrapherexp3.this.drawNewData = true;
                        if (previousScroll <= 0 || this.scrollUp != 0) break;
                        this.autoScroll = true;
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 33: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll -= ProcessingGrapherexp3.this.height - this.cT;
                            if (this.menuScroll < 0) {
                                this.menuScroll = 0;
                            }
                            ProcessingGrapherexp3.this.redrawUI = true;
                            break;
                        }
                        int previousScroll = this.scrollUp;
                        if (this.scrollUp < this.serialBuffer.size() - this.displayRows) {
                            this.scrollUp += this.displayRows;
                        }
                        if (this.scrollUp > this.serialBuffer.size() - this.displayRows) {
                            this.scrollUp = this.serialBuffer.size() - this.displayRows;
                        }
                        if (previousScroll == 0 && this.scrollUp > 0) {
                            this.autoScroll = false;
                            ProcessingGrapherexp3.this.redrawUI = true;
                        }
                        ProcessingGrapherexp3.this.drawNewData = true;
                        break;
                    }
                    case 34: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll += ProcessingGrapherexp3.this.height - this.cT;
                            if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                                this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                            }
                            ProcessingGrapherexp3.this.redrawUI = true;
                            break;
                        }
                        int previousScroll = this.scrollUp;
                        if (this.scrollUp > 0) {
                            this.scrollUp -= this.displayRows;
                        }
                        if (this.scrollUp < 0) {
                            this.scrollUp = 0;
                        }
                        ProcessingGrapherexp3.this.drawNewData = true;
                        if (previousScroll <= 0 || this.scrollUp != 0) break;
                        this.autoScroll = true;
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 35: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                            ProcessingGrapherexp3.this.redrawUI = true;
                            break;
                        }
                        this.scrollUp = 0;
                        this.autoScroll = true;
                        ProcessingGrapherexp3.this.drawNewData = true;
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 36: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll = 0;
                            ProcessingGrapherexp3.this.redrawUI = true;
                            break;
                        }
                        this.scrollUp = this.serialBuffer.size() - this.displayRows;
                        ProcessingGrapherexp3.this.drawNewData = true;
                        this.autoScroll = false;
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 256: {
                        if (this.activeArea == 0) {
                            this.serialTextSelection.setVisibility(false);
                            this.inputTextSelection.startChar = 0;
                            this.inputTextSelection.endChar = this.msgText.length();
                            this.cursorPosition = this.msgText.length();
                            this.inputTextSelection.setVisibility(true);
                        } else if (this.activeArea == 1) {
                            this.inputTextSelection.setVisibility(false);
                            this.serialTextSelection.startLine = 0;
                            this.serialTextSelection.startChar = 0;
                            this.serialTextSelection.endLine = this.serialBuffer.size() - 1;
                            this.serialTextSelection.endChar = this.serialBuffer.get(this.serialTextSelection.endLine).length();
                            this.serialTextSelection.setVisibility(true);
                        }
                        ProcessingGrapherexp3.this.redrawContent = true;
                        break;
                    }
                    case 65485: {
                        if (this.serialTextSelection.valid) {
                            String copyText = "";
                            int i = this.serialTextSelection.startLine;
                            while (i <= this.serialTextSelection.endLine) {
                                String tempString = this.serialBuffer.get(i);
                                if (this.serialTextSelection.startLine == this.serialTextSelection.endLine) {
                                    copyText = tempString.substring(this.serialTextSelection.startChar, this.serialTextSelection.endChar);
                                } else if (i == this.serialTextSelection.startLine) {
                                    if (this.serialTextSelection.startChar > 0) {
                                        copyText = String.valueOf(copyText) + tempString.substring(this.serialTextSelection.startChar) + '\n';
                                    }
                                } else {
                                    copyText = i == this.serialTextSelection.endLine ? String.valueOf(copyText) + tempString.substring(0, this.serialTextSelection.endChar) : String.valueOf(copyText) + tempString + '\n';
                                }
                                ++i;
                            }
                            StringSelection selection = new StringSelection(copyText);
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(selection, selection);
                            break;
                        }
                        if (!this.inputTextSelection.valid) break;
                        String copyText = this.msgText.substring(this.inputTextSelection.startChar, this.inputTextSelection.endChar);
                        StringSelection selection = new StringSelection(copyText);
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        clipboard.setContents(selection, selection);
                        break;
                    }
                    case 65487: {
                        String clipboardText = ProcessingGrapherexp3.this.getStringClipboard();
                        if (clipboardText == null || clipboardText.length() <= 0) break;
                        String msgEnd = "";
                        if (this.cursorPosition == 0) {
                            msgEnd = this.msgText;
                            this.msgText = "";
                        } else if (this.cursorPosition < this.msgText.length()) {
                            msgEnd = this.msgText.substring(this.cursorPosition, this.msgText.length());
                            this.msgText = this.msgText.substring(0, this.cursorPosition);
                        }
                        String[] clipboardLines = clipboardText.split("\\r?\\n");
                        int i = 0;
                        while (i < clipboardLines.length - 1) {
                            if (ProcessingGrapherexp3.this.serialConnected) {
                                ProcessingGrapherexp3.this.serialSend(String.valueOf(this.msgText) + clipboardLines[i]);
                            }
                            this.msgText = "SENT: " + this.msgText + clipboardLines[i];
                            this.serialBuffer.append(this.msgText);
                            this.msgText = "";
                            ++i;
                        }
                        this.msgText = String.valueOf(this.msgText) + clipboardLines[clipboardLines.length - 1] + msgEnd;
                        this.cursorPosition = this.msgText.length() - msgEnd.length();
                        this.inputTextSelection.setVisibility(false);
                        ProcessingGrapherexp3.this.redrawContent = true;
                        break;
                    }
                    case 115: {
                        if (this.recordData) break;
                        this.outputfile = "";
                        ProcessingGrapherexp3.this.selectOutput("Select a location and name for the output *.TXT file", "fileSelected");
                        break;
                    }
                    case 117: {
                        if (this.recordData) {
                            this.stopRecording();
                            break;
                        }
                        if (this.outputfile == "" || this.outputfile == "No File Set") break;
                        this.startRecording();
                        break;
                    }
                }
            }
        }

        @Override
        public void contentClick(int xcoord, int ycoord) {
            if (this.scrollUp > 0 && (float)xcoord > (float)this.cR - 40.0f * ProcessingGrapherexp3.this.uimult && (float)ycoord > (float)this.cB - 40.0f * ProcessingGrapherexp3.this.uimult && (float)xcoord < (float)this.cR - 10.0f * ProcessingGrapherexp3.this.uimult && (float)ycoord < (float)this.cB - 10.0f * ProcessingGrapherexp3.this.uimult) {
                this.scrollUp = 0;
                this.autoScroll = true;
                ProcessingGrapherexp3.this.redrawUI = true;
                ProcessingGrapherexp3.this.redrawContent = true;
                return;
            }
            if (this.scrollUp != -1 && this.serialScroll.click(xcoord, ycoord)) {
                this.sidebarScroll.active(false);
                this.serialTextSelection.active = false;
                this.inputTextSelection.active = false;
                ProcessingGrapherexp3.this.startScrolling(true, 0);
                return;
            }
            if (ycoord > this.msgB && (float)ycoord < (float)this.cB - (float)this.border * 1.5f) {
                this.sidebarScroll.active(false);
                this.serialScroll.active(false);
                this.inputTextSelection.setVisibility(false);
                this.activeArea = 1;
                this.serialTextSelectionCalculation(xcoord, ycoord, true);
                ProcessingGrapherexp3.this.startScrolling(true, 1);
                ProcessingGrapherexp3.this.redrawContent = true;
            }
            if (ycoord > this.cT && ycoord < this.msgB) {
                this.sidebarScroll.active(false);
                this.serialScroll.active(false);
                this.serialTextSelection.setVisibility(false);
                this.activeArea = 0;
                this.inputTextSelectionCalculation(xcoord, ycoord, true);
                ProcessingGrapherexp3.this.startScrolling(true, 1);
                ProcessingGrapherexp3.this.redrawContent = true;
            }
        }

        @Override
        public void menuClick(int xcoord, int ycoord) {
            int sT = this.cT;
            int sL = this.cR;
            if (this.menuScroll > 0) {
                sT -= this.menuScroll;
            }
            if (this.menuScroll != -1) {
                sL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
            }
            int sW = ProcessingGrapherexp3.this.width - this.cR;
            int uH = ProcessingGrapherexp3.round((float)(30.0f * ProcessingGrapherexp3.this.uimult));
            ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult));
            int iH = ProcessingGrapherexp3.round((float)(25.0f * ProcessingGrapherexp3.this.uimult));
            int iL = ProcessingGrapherexp3.round((float)((float)sL + 10.0f * ProcessingGrapherexp3.this.uimult));
            int iW = ProcessingGrapherexp3.round((float)((float)sW - 20.0f * ProcessingGrapherexp3.this.uimult));
            String[] ports = Serial.list();
            if (this.menuScroll != -1 && this.sidebarScroll.click(xcoord, ycoord)) {
                this.serialScroll.active(false);
                this.serialTextSelection.active = false;
                this.inputTextSelection.active = false;
                ProcessingGrapherexp3.this.startScrolling(false);
            }
            if (this.menuLevel == 0) {
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 1.0f, iL, iW)) {
                    this.menuLevel = 1;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 2.0f, iL, iW)) {
                    ProcessingGrapherexp3.this.setupSerial();
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 3.0f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"Un");
                    if (ProcessingGrapherexp3.this.serialConnected) {
                        ProcessingGrapherexp3.this.myPort.write("Un");
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 5.5f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"caldata");
                    if (ProcessingGrapherexp3.this.serialConnected) {
                        ProcessingGrapherexp3.this.myPort.write("c");
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 6.5f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"canonoff");
                    if (ProcessingGrapherexp3.this.serialConnected) {
                        ProcessingGrapherexp3.this.myPort.write("m");
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 7.5f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"Overc");
                    if (ProcessingGrapherexp3.this.serialConnected) {
                        ProcessingGrapherexp3.this.myPort.write("$");
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 8.5f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"Unsafe");
                    if (ProcessingGrapherexp3.this.serialConnected) {
                        ProcessingGrapherexp3.this.myPort.write("!");
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 9.5f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"save");
                    if (ProcessingGrapherexp3.this.serialConnected) {
                        ProcessingGrapherexp3.this.myPort.write("s");
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 10.5f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"savetofile");
                    if (this.recordData) {
                        this.stopRecording();
                    }
                    this.outputfile = "";
                    ProcessingGrapherexp3.this.selectOutput("Select a location and name for Saving controller settings to file", "fileSelected");
                    while (this.outputfile == "") {
                        ProcessingGrapherexp3.this.delay(100);
                    }
                    ProcessingGrapherexp3.println((String)this.outputfile);
                    this.serialBuffer.clear();
                    ProcessingGrapherexp3.this.redrawUI = true;
                    ProcessingGrapherexp3.this.drawNewData = true;
                    ProcessingGrapherexp3.this.recoo = true;
                    ProcessingGrapherexp3.this.myPort.write("`");
                    ProcessingGrapherexp3.println((String)"sentC");
                    ProcessingGrapherexp3.this.delay(200);
                    int i = 0;
                    if (ProcessingGrapherexp3.this.myPort.read() == 64 && ProcessingGrapherexp3.this.myPort.read() == 44) {
                        int jj;
                        String inS = ProcessingGrapherexp3.this.myPort.readStringUntil(44);
                        inS = inS.substring(0, inS.length() - 1);
                        int totbytes = Integer.parseInt(inS);
                        ProcessingGrapherexp3.println((int)totbytes);
                        inS = ProcessingGrapherexp3.this.myPort.readStringUntil(10);
                        inS = inS.substring(0, inS.length() - 2);
                        int checksum = Integer.parseInt(inS);
                        ProcessingGrapherexp3.println((int)checksum);
                        byte[] nums = new byte[totbytes];
                        while (ProcessingGrapherexp3.this.myPort.available() > 0 && i < totbytes) {
                            jj = ProcessingGrapherexp3.this.myPort.read();
                            nums[i] = PApplet.parseByte((int)jj);
                            ++i;
                        }
                        int value = 0;
                        jj = 0;
                        while (jj < totbytes) {
                            value += nums[jj];
                            ++jj;
                        }
                        value ^= 0xFFFFFFFF;
                        if ((value &= 0xFF) == checksum) {
                            ProcessingGrapherexp3.this.saveBytes(this.outputfile, nums);
                        } else {
                            ProcessingGrapherexp3.println((String)"checksum not matching");
                        }
                        this.outputfile = "";
                        ProcessingGrapherexp3.this.recoo = false;
                    }
                    this.outputfile = "";
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 11.5f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"loadfrfile");
                    if (this.recordData) {
                        this.stopRecording();
                    }
                    this.outputfile = "";
                    ProcessingGrapherexp3.this.selectInput("Select settings file to send to controller", "fileSelected");
                    while (this.outputfile == "") {
                        ProcessingGrapherexp3.this.delay(100);
                    }
                    byte[] nums1 = ProcessingGrapherexp3.this.loadBytes(this.outputfile);
                    ProcessingGrapherexp3.print((String)"size of nums: ");
                    ProcessingGrapherexp3.println((int)nums1.length);
                    int value = 0;
                    int jj = 0;
                    while (jj < nums1.length) {
                        value += nums1[jj];
                        jj = (byte)(jj + 1);
                    }
                    value ^= 0xFFFFFFFF;
                    ProcessingGrapherexp3.println((int)(value &= 0xFF));
                    ProcessingGrapherexp3.this.myPort.write("@,");
                    ProcessingGrapherexp3.this.myPort.write(nums1.length);
                    ProcessingGrapherexp3.this.myPort.write(value);
                    jj = 0;
                    while (jj < nums1.length) {
                        ProcessingGrapherexp3.this.myPort.write((int)nums1[jj]);
                        jj = (byte)(jj + 1);
                    }
                    ProcessingGrapherexp3.this.redrawUI = true;
                    ProcessingGrapherexp3.this.drawNewData = true;
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 12.5f, iL, iW)) {
                    ProcessingGrapherexp3.this.settingsMenuActive = true;
                    ProcessingGrapherexp3.this.redrawUI = true;
                    ProcessingGrapherexp3.this.settings.setVisibility(true);
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 15.0f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"setoutputfile");
                    if (!this.recordData) {
                        this.outputfile = "";
                        ProcessingGrapherexp3.this.selectOutput("Select a location and name for the output *.TXT file", "fileSelected");
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 16.0f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"startrec");
                    if (this.recordData) {
                        this.stopRecording();
                    } else if (this.outputfile != "" && this.outputfile != "No File Set") {
                        this.startRecording();
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 18.5f, iL, iW)) {
                    ProcessingGrapherexp3.println((String)"clearterm");
                    if (!this.recordData) {
                        this.serialBuffer.clear();
                        this.serialBuffer.append("--- DATA from DBW controller ---");
                        this.scrollUp = 0;
                        this.autoScroll = true;
                        this.serialTextSelection.setVisibility(false);
                        ProcessingGrapherexp3.this.drawNewData = true;
                        ProcessingGrapherexp3.this.redrawUI = true;
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 19.5f, iL, iW)) {
                    this.autoScroll = !this.autoScroll;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.menuLevel == 1) {
                float tHnow = 1.0f;
                if (ports.length == 0) {
                    tHnow += 1.0f;
                } else {
                    int i = 0;
                    while (i < ports.length) {
                        if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                            if (ProcessingGrapherexp3.this.serialConnected && ProcessingGrapherexp3.this.portNumber != i) {
                                ProcessingGrapherexp3.this.setupSerial();
                            }
                            ProcessingGrapherexp3.this.portNumber = i;
                            ProcessingGrapherexp3.this.currentPort = ProcessingGrapherexp3.this.portList[ProcessingGrapherexp3.this.portNumber];
                            this.menuLevel = 0;
                            this.menuScroll = 0;
                            ProcessingGrapherexp3.this.redrawUI = true;
                        }
                        tHnow += 1.0f;
                        ++i;
                    }
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 0.5f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.menuLevel == 2) {
                float tHnow = 1.0f;
                int i = 0;
                while (i < this.baudRateList.length) {
                    if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                        ProcessingGrapherexp3.this.baudRate = this.baudRateList[i];
                        this.menuLevel = 0;
                        this.menuScroll = 0;
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.setupSerial();
                            ProcessingGrapherexp3.this.setupSerial();
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                    }
                    tHnow += 1.0f;
                    ++i;
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 0.5f, iL, iW)) {
                    ProcessingGrapherexp3.this.settingsMenuActive = true;
                    ProcessingGrapherexp3.this.settings.setMenuLevel(1);
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 1.0f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            }
        }

        @Override
        public void scrollWheel(float amount) {
            if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                this.menuScroll = (int)((float)this.menuScroll + 30.0f * amount * ProcessingGrapherexp3.this.uimult);
                if (this.menuScroll < 0) {
                    this.menuScroll = 0;
                } else if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                    this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                }
            } else {
                int previousScroll = this.scrollUp;
                this.scrollUp -= ProcessingGrapherexp3.round((float)(2.0f * amount));
                if (this.scrollUp < 0) {
                    this.scrollUp = 0;
                } else if (this.scrollUp > this.serialBuffer.size() - this.displayRows) {
                    this.scrollUp = this.serialBuffer.size() - this.displayRows;
                }
                ProcessingGrapherexp3.this.drawNewData = true;
                if (previousScroll == 0 && this.scrollUp > 0) {
                    this.autoScroll = false;
                    ProcessingGrapherexp3.this.redrawUI = true;
                } else if (previousScroll > 0 && this.scrollUp == 0) {
                    this.autoScroll = true;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            }
            ProcessingGrapherexp3.this.redrawUI = true;
        }

        @Override
        public void scrollBarUpdate(int xcoord, int ycoord) {
            if (this.serialScroll.active()) {
                int previousScroll = this.scrollUp;
                this.scrollUp = this.serialScroll.move(xcoord, ycoord, this.scrollUp, 0, this.serialBuffer.size() - this.displayRows);
                if (previousScroll != this.scrollUp) {
                    ProcessingGrapherexp3.this.redrawContent = true;
                }
                if (previousScroll == 0 && this.scrollUp > 0) {
                    this.autoScroll = false;
                    ProcessingGrapherexp3.this.redrawUI = true;
                } else if (previousScroll > 0 && this.scrollUp == 0) {
                    this.autoScroll = true;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.sidebarScroll.active()) {
                int previousScroll = this.menuScroll;
                this.menuScroll = this.sidebarScroll.move(xcoord, ycoord, this.menuScroll, 0, this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT));
                if (previousScroll != this.menuScroll) {
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.serialTextSelection.active) {
                if (this.serialTextSelectionCalculation(xcoord, ycoord, false)) {
                    ProcessingGrapherexp3.this.drawNewData = true;
                }
            } else if (this.inputTextSelection.active && this.inputTextSelectionCalculation(xcoord, ycoord, false)) {
                ProcessingGrapherexp3.this.redrawContent = true;
            }
        }

        @Override
        public boolean checkSafeExit() {
            return !this.recordData;
        }

        @Override
        public void performExit() {
            if (this.recordData) {
                this.stopRecording();
            }
            if (ProcessingGrapherexp3.this.serialConnected) {
                ProcessingGrapherexp3.this.setupSerial();
            }
        }

        public boolean serialTextSelectionCalculation(int xcoord, int ycoord, boolean selectionStart) {
            int selectedLine = this.displayRows - (ycoord - this.msgB) / this.yTextHeight;
            if (selectedLine > this.displayRows) {
                if (!selectionStart && this.scrollUp < this.serialBuffer.size() - this.displayRows) {
                    ++this.scrollUp;
                    selectedLine = this.displayRows + 1;
                } else {
                    selectedLine = this.displayRows;
                }
            } else if (selectedLine < 0) {
                if (!selectionStart && this.scrollUp > 0) {
                    --this.scrollUp;
                    selectedLine = 0;
                } else {
                    selectedLine = 0;
                }
            }
            int textIndex = this.serialBuffer.size() - selectedLine - this.scrollUp;
            if (textIndex < 0) {
                textIndex = 0;
            } else if (textIndex >= this.serialBuffer.size()) {
                textIndex = this.serialBuffer.size() - 1;
            }
            String textRow = this.serialBuffer.get(textIndex);
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.mono_font);
            float charWidth = ProcessingGrapherexp3.this.textWidth("a");
            int maxChars = ProcessingGrapherexp3.floor((float)((float)(this.cR - 2 * this.cL - 5 * this.border) / charWidth));
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.base_font);
            int selectedChar = PApplet.parseInt((float)((float)(xcoord - (this.cL + 2 * this.border)) / charWidth)) + 1;
            if (selectionStart) {
                --selectedChar;
            }
            if (selectedChar < 0) {
                selectedChar = 0;
            } else if (selectedChar >= textRow.length()) {
                selectedChar = textRow.length();
            } else if (selectedChar > maxChars) {
                selectedChar = maxChars;
            }
            return this.serialTextSelection.setNewSelection(selectionStart, textIndex, selectedChar);
        }

        public boolean inputTextSelectionCalculation(int xcoord, int ycoord, boolean selectionStart) {
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.mono_font);
            float charWidth = ProcessingGrapherexp3.this.textWidth("a");
            ProcessingGrapherexp3.floor((float)((float)(this.cR - 2 * this.cL - 5 * this.border) / charWidth));
            ProcessingGrapherexp3.this.textFont(ProcessingGrapherexp3.this.base_font);
            int selectedChar = this.msgTextBounds[0] + PApplet.parseInt((float)((float)(xcoord - (this.cL + 4 * this.msgBorder + this.msgBtnSize)) / charWidth));
            if (selectedChar < this.msgTextBounds[0]) {
                if (this.msgTextBounds[0] > 0) {
                    this.msgTextBounds[0] = this.msgTextBounds[0] - 1;
                    this.msgTextBounds[1] = this.msgTextBounds[1] - 1;
                    if (this.cursorPosition > this.msgTextBounds[1]) {
                        --this.cursorPosition;
                    }
                }
                selectedChar = this.msgTextBounds[0];
            } else if (selectedChar > this.msgTextBounds[1]) {
                if (this.msgTextBounds[1] < this.msgText.length()) {
                    this.msgTextBounds[0] = this.msgTextBounds[0] + 1;
                    this.msgTextBounds[1] = this.msgTextBounds[1] + 1;
                    if (this.cursorPosition < this.msgTextBounds[0]) {
                        ++this.cursorPosition;
                    }
                }
                selectedChar = this.msgTextBounds[1];
            }
            if (selectionStart) {
                this.cursorPosition = selectedChar;
            }
            return this.inputTextSelection.setNewSelection(selectionStart, 0, selectedChar);
        }

        class SerialMessages {
            private int totalMessagesLength = 0;
            private int lookupTableLength = 0;
            private int maximumLength;
            private boolean showAllMessages = true;
            private int bufferEndIdx = 0;
            private int tableStartIdx = 0;
            private int tableEndIdx = 0;
            private StringList serialMessagesBuffer;
            private IntList textLookupTable;

            SerialMessages(int maxLength) {
                this.maximumLength = maxLength;
                int initialLength = 1000;
                if (initialLength > maxLength) {
                    initialLength = maxLength;
                }
                this.serialMessagesBuffer = new StringList(initialLength);
                this.textLookupTable = new IntList(initialLength);
            }

            public String get(int index) {
                if (this.showAllMessages) {
                    if (index < this.totalMessagesLength) {
                        if (this.totalMessagesLength == this.maximumLength && (index += this.bufferEndIdx) >= this.totalMessagesLength) {
                            index -= this.totalMessagesLength;
                        }
                        return this.serialMessagesBuffer.get(index);
                    }
                } else if (index < this.lookupTableLength) {
                    if ((index += this.tableStartIdx) >= this.textLookupTable.size()) {
                        index -= this.textLookupTable.size();
                    }
                    return this.serialMessagesBuffer.get(this.textLookupTable.get(index));
                }
                return null;
            }

            public int size() {
                if (this.showAllMessages) {
                    return this.totalMessagesLength;
                }
                return this.lookupTableLength;
            }

            public void clear() {
                this.totalMessagesLength = 0;
                this.bufferEndIdx = 0;
                this.tableStartIdx = 0;
                this.tableEndIdx = 0;
                this.lookupTableLength = 0;
            }

            public boolean getVisibility() {
                return this.showAllMessages;
            }

            public void setVisibility(boolean setState) {
                this.showAllMessages = setState;
            }

            public void append(String message, boolean graphable) {
                if (this.totalMessagesLength < this.maximumLength) {
                    if (this.totalMessagesLength < this.serialMessagesBuffer.size()) {
                        this.serialMessagesBuffer.set(this.bufferEndIdx, message);
                        if (!graphable) {
                            this.textLookupTable.set(this.tableEndIdx, this.bufferEndIdx);
                        }
                    } else {
                        this.serialMessagesBuffer.append(message);
                        this.textLookupTable.append(0);
                        if (!graphable) {
                            this.textLookupTable.set(this.tableEndIdx, this.bufferEndIdx);
                        }
                    }
                    ++this.totalMessagesLength;
                    ++this.bufferEndIdx;
                    if (!graphable) {
                        ++this.tableEndIdx;
                        ++this.lookupTableLength;
                    }
                } else {
                    int firstItem = this.bufferEndIdx;
                    if (firstItem >= this.serialMessagesBuffer.size()) {
                        firstItem = 0;
                    }
                    if (this.textLookupTable.get(this.tableStartIdx) == firstItem) {
                        --this.lookupTableLength;
                        ++this.tableStartIdx;
                        if (this.tableStartIdx >= this.textLookupTable.size()) {
                            this.tableStartIdx = 0;
                        }
                    }
                    this.serialMessagesBuffer.set(firstItem, message);
                    if (!graphable) {
                        if (this.tableEndIdx >= this.textLookupTable.size()) {
                            this.tableEndIdx = 0;
                        }
                        this.textLookupTable.set(this.tableEndIdx++, firstItem);
                        ++this.lookupTableLength;
                    }
                    this.bufferEndIdx = firstItem + 1;
                }
            }

            public void append(String message) {
                this.append(message, false);
            }
        }

        class SerialTag {
            public String tagText;
            public int tagColor;

            SerialTag(String setText, int setColor) {
                this.tagText = setText;
                this.tagColor = setColor;
            }
        }

        class TextSelection {
            public int startLine = 0;
            public int startChar = 0;
            public int endLine = 0;
            public int endChar = 0;
            public boolean active = false;
            public boolean valid = false;
            private boolean inverted = false;

            TextSelection() {
            }

            public void setVisibility(boolean selectionState) {
                if (selectionState) {
                    this.valid = true;
                } else {
                    this.valid = false;
                    this.active = false;
                    this.inverted = false;
                }
            }

            public boolean setNewSelection(boolean selectionStart, int newLine, int newChar) {
                if (this.inverted && newLine == this.startLine && newChar == this.startChar) {
                    return false;
                }
                if (!this.inverted && newLine == this.endLine && newChar == this.endChar) {
                    return false;
                }
                if (selectionStart) {
                    this.startLine = newLine;
                    this.startChar = newChar;
                    this.endLine = newLine;
                    this.endChar = newChar;
                    this.valid = false;
                } else {
                    if (!this.inverted && (newLine < this.startLine || newLine == this.startLine && newChar < this.startChar)) {
                        this.inverted = true;
                        this.endLine = this.startLine;
                        this.endChar = this.startChar;
                    } else if (this.inverted && (newLine > this.endLine || newLine == this.endLine && newChar > this.endChar)) {
                        this.inverted = false;
                        this.startLine = this.endLine;
                        this.startChar = this.endChar;
                    }
                    if (this.inverted) {
                        this.startLine = newLine;
                        this.startChar = newChar;
                    } else {
                        this.endLine = newLine;
                        this.endChar = newChar;
                    }
                    if (this.endLine > this.startLine || this.endChar > this.startChar) {
                        this.valid = true;
                    }
                }
                this.active = true;
                return true;
            }
        }
    }

    class Settings
    implements TabAPI {
        int cL;
        int cR;
        int cT;
        int cB;
        int menuScroll;
        int menuHeight;
        int menuLevel;
        ScrollBar sidebarScroll;
        String name;
        String outputfile;
        boolean backExit;
        boolean unsavedChanges;
        boolean tabIsVisible;
        final int[] baudRateList;
        final int[] baudRateListFull;
        final String[] lineEndingNames;
        final char[] lineEndingList;
        final String[] parityBitsNames;
        final char[] parityBitsList;
        final String[] dataBitsNames;
        final int[] dataBitsList;
        final String[] stopBitsNames;
        final float[] stopBitsList;
        final String[] separatorNames;
        final char[] separatorList;

        Settings(String setname, int left, int right, int top, int bottom) {
            this.sidebarScroll = new ScrollBar(false, false);
            this.backExit = false;
            this.unsavedChanges = false;
            this.tabIsVisible = false;
            this.baudRateList = new int[]{300, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 74880, 115200, 230400, 250000};
            this.baudRateListFull = new int[]{50, 75, 110, 134, 150, 200, 300, 600, 1200, 1800, 2400, 4800, 9600, 19200, 38400, 57600, 74880, 115200, 230400, 250000, 460800, 500000, 576000, 921600, 1000000, 1152000, 1500000, 2000000, 2500000, 3000000, 3500000, 4000000};
            this.lineEndingNames = new String[]{"New Line (Default)", "Carriage Return"};
            this.lineEndingList = new char[]{'\n', '\r'};
            this.parityBitsNames = new String[]{"None (Default)", "Even", "Odd", "Mark", "Space"};
            this.parityBitsList = new char[]{'N', 'E', 'O', 'M', 'S'};
            this.dataBitsNames = new String[]{"5", "6", "7", "8 (Default)"};
            this.dataBitsList = new int[]{5, 6, 7, 8};
            this.stopBitsNames = new String[]{"1.0 (Default)", "1.5", "2.0"};
            this.stopBitsList = new float[]{1.0f, 1.5f, 2.0f};
            this.separatorNames = new String[]{"Comma (Default)", "Semi-colon [ ; ]", "Tab [ \\t ]", "Colon [ : ]", "Space [   ]", "Underscore [ _ ]", "Vertical Bar [ | ]"};
            this.separatorList = new char[]{',', ';', '\t', ':', ' ', '_', '|'};
            this.name = setname;
            this.cL = left;
            this.cR = right;
            this.cT = top;
            this.cB = bottom;
            this.outputfile = "No File Set";
            this.menuScroll = 0;
            this.menuHeight = this.cB - this.cT - 1;
            this.menuLevel = 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setVisibility(boolean newState) {
            this.tabIsVisible = newState;
        }

        @Override
        public void setMenuLevel(int newLevel) {
            this.menuLevel = newLevel;
            this.menuScroll = 0;
            this.backExit = true;
        }

        @Override
        public void drawContent() {
            this.loadSettings();
        }

        @Override
        public void drawNewData() {
            this.menuLevel = 0;
            this.menuScroll = 0;
        }

        @Override
        public void changeSize(int newL, int newR, int newT, int newB) {
            this.cL = newL;
            this.cR = newR;
            this.cT = newT;
            this.cB = newB;
        }

        @Override
        public void setOutput(String newoutput) {
        }

        @Override
        public String getOutput() {
            return this.outputfile;
        }

        public void loadSettings() {
            if (ProcessingGrapherexp3.this.dataFile("user-preferences.xml").isFile()) {
                int i;
                char charValue;
                String value;
                int i2;
                int value2;
                XML xmlFile = ProcessingGrapherexp3.this.loadXML("user-preferences.xml");
                XML entry = xmlFile.getChild("interface-scale");
                try {
                    value2 = entry.getInt("percentage", 100);
                    if (value2 == value2 && value2 <= 200 && value2 >= 50) {
                        ProcessingGrapherexp3.this.uimult = (float)value2 / 100.0f;
                        ProcessingGrapherexp3.this.uiResize();
                    }
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.println((String)("Unable to parse user settings - <interface-scale>:\n" + e));
                }
                entry = xmlFile.getChild("color-scheme");
                try {
                    value2 = entry.getInt("id", 2);
                    if (value2 == value2 && value2 <= 2 && value2 >= 0) {
                        ProcessingGrapherexp3.this.colorScheme = value2;
                        ProcessingGrapherexp3.this.loadColorScheme(ProcessingGrapherexp3.this.colorScheme);
                    }
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.println((String)("Unable to parse user settings - <color-scheme>:\n" + e));
                }
                entry = xmlFile.getChild("fps-indicator");
                try {
                    int value3 = entry.getInt("visible", 0);
                    if (value3 == value3 && value3 <= 1 && value3 >= 0) {
                        ProcessingGrapherexp3.this.drawFPS = value3 == 1;
                        ProcessingGrapherexp3.this.redrawUI = true;
                    }
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.println((String)("Unable to parse user settings - <fps-indicator>:\n" + e));
                }
                entry = xmlFile.getChild("usage-instructions");
                try {
                    int value4 = entry.getInt("visible", 1);
                    if (value4 == value4 && value4 <= 1 && value4 >= 0) {
                        ProcessingGrapherexp3.this.showInstructions = value4 == 1;
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.redrawContent = true;
                    }
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.println((String)("Unable to parse user settings - <usage-instructions>\n" + e));
                }
                entry = xmlFile.getChild("serial-port");
                try {
                    int value5 = entry.getInt("baud-rate", 9600);
                    i2 = 0;
                    while (i2 < this.baudRateListFull.length) {
                        if (this.baudRateListFull[i2] == value5) {
                            ProcessingGrapherexp3.this.baudRate = value5;
                        }
                        ++i2;
                    }
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.println((String)("Unable to parse user settings - <serial-port: baud-rate>\n" + e));
                }
                try {
                    value = entry.getString("line-ending", ProcessingGrapherexp3.str((char)'\n'));
                    charValue = value.charAt(0);
                    i = 0;
                    while (i < this.lineEndingList.length) {
                        if (this.lineEndingList[i] == charValue) {
                            ProcessingGrapherexp3.this.lineEnding = charValue;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.println((String)("Unable to parse user settings - <serial-port: line-ending>\n" + e));
                }
                try {
                    value = entry.getString("parity", ProcessingGrapherexp3.str((char)'N'));
                    charValue = value.charAt(0);
                    i = 0;
                    while (i < this.parityBitsList.length) {
                        if (this.parityBitsList[i] == charValue) {
                            ProcessingGrapherexp3.this.serialParity = charValue;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.println((String)("Unable to parse user settings - <serial-port: parity>\n" + e));
                }
                try {
                    int value6 = entry.getInt("databits", 8);
                    i2 = 0;
                    while (i2 < this.dataBitsList.length) {
                        if (this.dataBitsList[i2] == value6) {
                            ProcessingGrapherexp3.this.serialDatabits = value6;
                        }
                        ++i2;
                    }
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.println((String)("Unable to parse user settings - <serial-port: databits>\n" + e));
                }
                try {
                    float value7 = entry.getFloat("stopbits", 1.0f);
                    i2 = 0;
                    while (i2 < this.stopBitsList.length) {
                        if (this.stopBitsList[i2] == value7) {
                            ProcessingGrapherexp3.this.serialStopbits = value7;
                        }
                        ++i2;
                    }
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.println((String)("Unable to parse user settings - <serial-port: stopbits>\n" + e));
                }
                try {
                    String value8 = entry.getString("separator", ProcessingGrapherexp3.str((char)','));
                    charValue = value8.charAt(0);
                    i = 0;
                    while (i < this.separatorList.length) {
                        if (this.separatorList[i] == charValue) {
                            ProcessingGrapherexp3.this.separator = charValue;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    ProcessingGrapherexp3.println((String)("Unable to parse user settings - <serial-port: separator>\n" + e));
                }
            }
        }

        public void saveSettings() {
            XML xmlFile = new XML("user-preferences");
            xmlFile.addChild("interface-scale");
            xmlFile.getChild("interface-scale").setInt("percentage", ProcessingGrapherexp3.round((float)(ProcessingGrapherexp3.this.uimult * 100.0f)));
            xmlFile.addChild("color-scheme");
            xmlFile.getChild("color-scheme").setInt("id", ProcessingGrapherexp3.this.colorScheme);
            xmlFile.addChild("fps-indicator");
            xmlFile.getChild("fps-indicator").setInt("visible", PApplet.parseInt((boolean)ProcessingGrapherexp3.this.drawFPS));
            xmlFile.addChild("usage-instructions");
            xmlFile.getChild("usage-instructions").setInt("visible", PApplet.parseInt((boolean)ProcessingGrapherexp3.this.showInstructions));
            xmlFile.addChild("serial-port");
            xmlFile.getChild("serial-port").setInt("baud-rate", ProcessingGrapherexp3.this.baudRate);
            xmlFile.getChild("serial-port").setString("line-ending", ProcessingGrapherexp3.str((char)ProcessingGrapherexp3.this.lineEnding));
            xmlFile.getChild("serial-port").setString("parity", ProcessingGrapherexp3.str((char)ProcessingGrapherexp3.this.serialParity));
            xmlFile.getChild("serial-port").setInt("databits", ProcessingGrapherexp3.this.serialDatabits);
            xmlFile.getChild("serial-port").setFloat("stopbits", ProcessingGrapherexp3.this.serialStopbits);
            xmlFile.getChild("serial-port").setString("separator", ProcessingGrapherexp3.str((char)ProcessingGrapherexp3.this.separator));
            if (ProcessingGrapherexp3.this.saveXML(xmlFile, "data/user-preferences.xml")) {
                ProcessingGrapherexp3.this.alertMessage("Success\nUser preferences saved");
                this.unsavedChanges = false;
            } else {
                ProcessingGrapherexp3.this.alertMessage("Error\nUnable to save user preferences");
            }
        }

        @Override
        public void drawSidebar() {
            int i;
            int sT = this.cT;
            int sL = this.cR;
            int sW = ProcessingGrapherexp3.this.width - this.cR;
            int sH = ProcessingGrapherexp3.this.height - sT;
            int uH = ProcessingGrapherexp3.round((float)(30.0f * ProcessingGrapherexp3.this.uimult));
            int tH = ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult));
            int iH = ProcessingGrapherexp3.round((float)(25.0f * ProcessingGrapherexp3.this.uimult));
            int iL = ProcessingGrapherexp3.round((float)((float)sL + 10.0f * ProcessingGrapherexp3.this.uimult));
            int iW = ProcessingGrapherexp3.round((float)((float)sW - 20.0f * ProcessingGrapherexp3.this.uimult));
            if (this.menuLevel == 0) {
                this.menuHeight = ProcessingGrapherexp3.round((float)(23 * uH));
            } else if (this.menuLevel == 1) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((3 + this.baudRateListFull.length) * uH));
            } else if (this.menuLevel == 2) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((3 + this.lineEndingList.length) * uH));
            } else if (this.menuLevel == 3) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((3 + this.parityBitsList.length) * uH));
            } else if (this.menuLevel == 4) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((3 + this.dataBitsList.length) * uH));
            } else if (this.menuLevel == 5) {
                this.menuHeight = ProcessingGrapherexp3.round((float)((3 + this.stopBitsList.length) * uH));
            }
            if (this.menuHeight > sH) {
                if (this.menuScroll == -1) {
                    this.menuScroll = 0;
                } else if (this.menuScroll > this.menuHeight - sH) {
                    this.menuScroll = this.menuHeight - sH;
                }
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_serial_message_box);
                ProcessingGrapherexp3.this.rect(ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sH);
                int scrollbarSize = sH - ProcessingGrapherexp3.round((float)((float)sH * PApplet.parseFloat((int)(this.menuHeight - sH)) / (float)this.menuHeight));
                if (scrollbarSize < uH) {
                    scrollbarSize = uH;
                }
                int scrollbarOffset = ProcessingGrapherexp3.round((float)((float)(sH - scrollbarSize) * ((float)this.menuScroll / PApplet.parseFloat((int)(this.menuHeight - sH)))));
                ProcessingGrapherexp3.this.fill(ProcessingGrapherexp3.this.c_terminal_text);
                ProcessingGrapherexp3.this.rect(ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT + scrollbarOffset, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, scrollbarSize);
                this.sidebarScroll.update(this.menuHeight, sH, ProcessingGrapherexp3.this.width - ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, sT + scrollbarOffset, ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 2, scrollbarSize);
                sT -= this.menuScroll;
                sL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
                iL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
            } else {
                this.menuScroll = -1;
            }
            if (this.menuLevel == 0) {
                ProcessingGrapherexp3.this.drawHeading("Interface Size", iL, sT + uH * 0, iW, tH);
                ProcessingGrapherexp3.this.drawButton("-", ProcessingGrapherexp3.this.c_sidebar_button, iL, sT + uH * 1, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawButton("+", ProcessingGrapherexp3.this.c_sidebar_button, iL + iW * 3 / 4, sT + uH * 1, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox(String.valueOf(ProcessingGrapherexp3.round((float)(ProcessingGrapherexp3.this.uimult * 100.0f))) + "%", ProcessingGrapherexp3.this.c_idletab_text, iL + iW / 4, sT + uH * 1, iW / 2, iH, tH);
                ProcessingGrapherexp3.this.drawHeading("Controller", iL, (float)sT + (float)uH * 2.5f, iW, tH);
                ProcessingGrapherexp3.this.drawButton("-", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 3.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawButton("+", ProcessingGrapherexp3.this.c_sidebar_button, iL + iW * 3 / 4, (float)sT + (float)uH * 3.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox("Idle LOW", ProcessingGrapherexp3.this.c_idletab_text, iL + iW / 4, (float)sT + (float)uH * 3.5f, iW / 2, iH, tH);
                ProcessingGrapherexp3.this.drawButton("-", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 4.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawButton("+", ProcessingGrapherexp3.this.c_sidebar_button, iL + iW * 3 / 4, (float)sT + (float)uH * 4.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox("Idle HIGH", ProcessingGrapherexp3.this.c_idletab_text, iL + iW / 4, (float)sT + (float)uH * 4.5f, iW / 2, iH, tH);
                ProcessingGrapherexp3.this.drawButton("-", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 5.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawButton("+", ProcessingGrapherexp3.this.c_sidebar_button, iL + iW * 3 / 4, (float)sT + (float)uH * 5.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox("Antilag", ProcessingGrapherexp3.this.c_idletab_text, iL + iW / 4, (float)sT + (float)uH * 5.5f, iW / 2, iH, tH);
                ProcessingGrapherexp3.this.drawButton("-", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 6.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawButton("+", ProcessingGrapherexp3.this.c_sidebar_button, iL + iW * 3 / 4, (float)sT + (float)uH * 6.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox("P", ProcessingGrapherexp3.this.c_idletab_text, iL + iW / 4, (float)sT + (float)uH * 6.5f, iW / 2, iH, tH);
                ProcessingGrapherexp3.this.drawButton("-", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 7.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawButton("+", ProcessingGrapherexp3.this.c_sidebar_button, iL + iW * 3 / 4, (float)sT + (float)uH * 7.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox("I", ProcessingGrapherexp3.this.c_idletab_text, iL + iW / 4, (float)sT + (float)uH * 7.5f, iW / 2, iH, tH);
                ProcessingGrapherexp3.this.drawButton("-", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * 8.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawButton("+", ProcessingGrapherexp3.this.c_sidebar_button, iL + iW * 3 / 4, (float)sT + (float)uH * 8.5f, iW / 4, iH, tH);
                ProcessingGrapherexp3.this.drawDatabox("D", ProcessingGrapherexp3.this.c_idletab_text, iL + iW / 4, (float)sT + (float)uH * 8.5f, iW / 2, iH, tH);
            } else if (this.menuLevel == 1) {
                ProcessingGrapherexp3.this.drawHeading("Select Baud Rate", iL, sT + uH * 0, iW, tH);
                float tHnow = 1.0f;
                i = 0;
                while (i < this.baudRateListFull.length) {
                    ProcessingGrapherexp3.this.drawButton(ProcessingGrapherexp3.str((int)this.baudRateListFull[i]), ProcessingGrapherexp3.this.baudRate == this.baudRateListFull[i] ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * tHnow, iW, iH, tH);
                    tHnow += 1.0f;
                    ++i;
                }
                ProcessingGrapherexp3.this.drawButton("Cancel", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * (tHnow += 0.5f), iW, iH, tH);
            } else if (this.menuLevel == 2) {
                ProcessingGrapherexp3.this.drawHeading("Select Line Ending", iL, sT + uH * 0, iW, tH);
                float tHnow = 1.0f;
                i = 0;
                while (i < this.lineEndingNames.length) {
                    ProcessingGrapherexp3.this.drawButton(this.lineEndingNames[i], ProcessingGrapherexp3.this.lineEnding == this.lineEndingList[i] ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * tHnow, iW, iH, tH);
                    tHnow += 1.0f;
                    ++i;
                }
                ProcessingGrapherexp3.this.drawButton("Cancel", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * (tHnow += 0.5f), iW, iH, tH);
            } else if (this.menuLevel == 3) {
                ProcessingGrapherexp3.this.drawHeading("Select Parity", iL, sT + uH * 0, iW, tH);
                float tHnow = 1.0f;
                i = 0;
                while (i < this.parityBitsNames.length) {
                    ProcessingGrapherexp3.this.drawButton(this.parityBitsNames[i], ProcessingGrapherexp3.this.serialParity == this.parityBitsList[i] ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * tHnow, iW, iH, tH);
                    tHnow += 1.0f;
                    ++i;
                }
                ProcessingGrapherexp3.this.drawButton("Cancel", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * (tHnow += 0.5f), iW, iH, tH);
            } else if (this.menuLevel == 4) {
                ProcessingGrapherexp3.this.drawHeading("Select Data Bits", iL, sT + uH * 0, iW, tH);
                float tHnow = 1.0f;
                i = 0;
                while (i < this.dataBitsNames.length) {
                    ProcessingGrapherexp3.this.drawButton(this.dataBitsNames[i], ProcessingGrapherexp3.this.serialDatabits == this.dataBitsList[i] ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * tHnow, iW, iH, tH);
                    tHnow += 1.0f;
                    ++i;
                }
                ProcessingGrapherexp3.this.drawButton("Cancel", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * (tHnow += 0.5f), iW, iH, tH);
            } else if (this.menuLevel == 5) {
                ProcessingGrapherexp3.this.drawHeading("Select Stop Bits", iL, sT + uH * 0, iW, tH);
                float tHnow = 1.0f;
                i = 0;
                while (i < this.stopBitsNames.length) {
                    ProcessingGrapherexp3.this.drawButton(this.stopBitsNames[i], ProcessingGrapherexp3.this.serialStopbits == this.stopBitsList[i] ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * tHnow, iW, iH, tH);
                    tHnow += 1.0f;
                    ++i;
                }
                ProcessingGrapherexp3.this.drawButton("Cancel", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * (tHnow += 0.5f), iW, iH, tH);
            } else if (this.menuLevel == 6) {
                ProcessingGrapherexp3.this.drawHeading("Select Separator", iL, sT + uH * 0, iW, tH);
                float tHnow = 1.0f;
                i = 0;
                while (i < this.separatorNames.length) {
                    ProcessingGrapherexp3.this.drawButton(this.separatorNames[i], ProcessingGrapherexp3.this.separator == this.separatorList[i] ? ProcessingGrapherexp3.this.c_sidebar_accent : ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * tHnow, iW, iH, tH);
                    tHnow += 1.0f;
                    ++i;
                }
                ProcessingGrapherexp3.this.drawButton("Cancel", ProcessingGrapherexp3.this.c_sidebar_button, iL, (float)sT + (float)uH * (tHnow += 0.5f), iW, iH, tH);
            }
        }

        @Override
        public void drawInfoBar() {
        }

        public boolean checkDefault() {
            if (ProcessingGrapherexp3.this.uimult != 1.0f) {
                return true;
            }
            if (!ProcessingGrapherexp3.this.showInstructions) {
                return true;
            }
            if (ProcessingGrapherexp3.this.drawFPS) {
                return true;
            }
            if (ProcessingGrapherexp3.this.colorScheme != 1) {
                return true;
            }
            if (!ProcessingGrapherexp3.this.serialConnected) {
                if (ProcessingGrapherexp3.this.baudRate != 9600) {
                    return true;
                }
                if (ProcessingGrapherexp3.this.lineEnding != '\n') {
                    return true;
                }
                if (ProcessingGrapherexp3.this.serialParity != 'N') {
                    return true;
                }
                if (ProcessingGrapherexp3.this.serialDatabits != 8) {
                    return true;
                }
                if (ProcessingGrapherexp3.this.serialStopbits != 1.0f) {
                    return true;
                }
                if (ProcessingGrapherexp3.this.separator != ',') {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void keyboardInput(char keyChar, int keyCodeInt, boolean codedKey) {
            if (keyChar == '\u001b') {
                if (this.menuLevel != 0) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                } else {
                    ProcessingGrapherexp3.this.settingsMenuActive = false;
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (codedKey) {
                switch (keyCodeInt) {
                    case 38: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll = (int)((float)this.menuScroll - 12.0f * ProcessingGrapherexp3.this.uimult);
                            if (this.menuScroll < 0) {
                                this.menuScroll = 0;
                            }
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 40: {
                        if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                            this.menuScroll = (int)((float)this.menuScroll + 12.0f * ProcessingGrapherexp3.this.uimult);
                            if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                                this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                            }
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 33: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll -= ProcessingGrapherexp3.this.height - this.cT;
                        if (this.menuScroll < 0) {
                            this.menuScroll = 0;
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 34: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll += ProcessingGrapherexp3.this.height - this.cT;
                        if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                            this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 35: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                        ProcessingGrapherexp3.this.redrawUI = true;
                        break;
                    }
                    case 36: {
                        if (ProcessingGrapherexp3.this.mouseX < this.cR || this.menuScroll == -1) break;
                        this.menuScroll = 0;
                        ProcessingGrapherexp3.this.redrawUI = true;
                    }
                }
            }
        }

        @Override
        public void contentClick(int xcoord, int ycoord) {
        }

        @Override
        public void scrollWheel(float amount) {
            if (ProcessingGrapherexp3.this.mouseX >= this.cR && this.menuScroll != -1) {
                this.menuScroll = (int)((float)this.menuScroll + 30.0f * amount * ProcessingGrapherexp3.this.uimult);
                if (this.menuScroll < 0) {
                    this.menuScroll = 0;
                } else if (this.menuScroll > this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT)) {
                    this.menuScroll = this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT);
                }
            }
            ProcessingGrapherexp3.this.redrawUI = true;
        }

        @Override
        public void scrollBarUpdate(int xcoord, int ycoord) {
            if (this.sidebarScroll.active()) {
                int previousScroll = this.menuScroll;
                this.menuScroll = this.sidebarScroll.move(xcoord, ycoord, this.menuScroll, 0, this.menuHeight - (ProcessingGrapherexp3.this.height - this.cT));
                if (previousScroll != this.menuScroll) {
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            }
        }

        @Override
        public void menuClick(int xcoord, int ycoord) {
            int sT = this.cT;
            int sL = this.cR;
            if (this.menuScroll > 0) {
                sT -= this.menuScroll;
            }
            if (this.menuScroll != -1) {
                sL -= ProcessingGrapherexp3.round((float)(15.0f * ProcessingGrapherexp3.this.uimult)) / 4;
            }
            int sW = ProcessingGrapherexp3.this.width - this.cR;
            int uH = ProcessingGrapherexp3.round((float)(30.0f * ProcessingGrapherexp3.this.uimult));
            ProcessingGrapherexp3.round((float)(22.0f * ProcessingGrapherexp3.this.uimult));
            int iH = ProcessingGrapherexp3.round((float)(25.0f * ProcessingGrapherexp3.this.uimult));
            int iL = ProcessingGrapherexp3.round((float)((float)sL + 10.0f * ProcessingGrapherexp3.this.uimult));
            int iW = ProcessingGrapherexp3.round((float)((float)sW - 20.0f * ProcessingGrapherexp3.this.uimult));
            if (this.menuScroll != -1 && this.sidebarScroll.click(xcoord, ycoord)) {
                ProcessingGrapherexp3.this.startScrolling(false);
            }
            if (this.menuLevel == 0) {
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 1.0f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 4)) {
                        if (ProcessingGrapherexp3.this.uimult > 0.5f) {
                            ProcessingGrapherexp3.this.uiResize(-0.1f);
                            this.unsavedChanges = true;
                        }
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW * 3 / 4, iW / 4) && ProcessingGrapherexp3.this.uimult < 2.0f) {
                        ProcessingGrapherexp3.this.uiResize(0.1f);
                        this.unsavedChanges = true;
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 3.5f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 4)) {
                        ProcessingGrapherexp3.println((String)"idle0-");
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.myPort.write("o");
                        }
                        for (TabAPI curTab : ProcessingGrapherexp3.this.tabObjects) {
                            curTab.connectionEvent(true);
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.drawNewData = true;
                        ProcessingGrapherexp3.this.redrawContent = true;
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW * 3 / 4, iW / 4)) {
                        ProcessingGrapherexp3.println((String)"idle0+");
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.myPort.write("O");
                        }
                        for (TabAPI curTab : ProcessingGrapherexp3.this.tabObjects) {
                            curTab.connectionEvent(true);
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                        ProcessingGrapherexp3.this.drawNewData = true;
                        ProcessingGrapherexp3.this.redrawContent = true;
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 4.5f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 4)) {
                        ProcessingGrapherexp3.println((String)"idle1-");
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.myPort.write("i");
                        }
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW * 3 / 4, iW / 4)) {
                        ProcessingGrapherexp3.println((String)"idle1+");
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.myPort.write("I");
                        }
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 5.5f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 4)) {
                        ProcessingGrapherexp3.println((String)"antil-");
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.myPort.write("a");
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW * 3 / 4, iW / 4)) {
                        ProcessingGrapherexp3.println((String)"antilag+");
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.myPort.write("A");
                        }
                        ProcessingGrapherexp3.this.redrawUI = true;
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 6.5f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 4)) {
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.myPort.write("p");
                        }
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW * 3 / 4, iW / 4) && ProcessingGrapherexp3.this.serialConnected) {
                        ProcessingGrapherexp3.this.myPort.write("P");
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 7.5f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 4)) {
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.myPort.write("[");
                        }
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW * 3 / 4, iW / 4) && ProcessingGrapherexp3.this.serialConnected) {
                        ProcessingGrapherexp3.this.myPort.write("{");
                    }
                } else if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, 8.5f, iL, iW)) {
                    if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL, iW / 4)) {
                        if (ProcessingGrapherexp3.this.serialConnected) {
                            ProcessingGrapherexp3.this.myPort.write("]");
                        }
                    } else if (ProcessingGrapherexp3.this.menuXclick(xcoord, iL + iW * 3 / 4, iW / 4) && ProcessingGrapherexp3.this.serialConnected) {
                        ProcessingGrapherexp3.this.myPort.write("}");
                    }
                }
            } else if (this.menuLevel == 1) {
                float tHnow = 1.0f;
                if (this.baudRateListFull.length == 0) {
                    tHnow += 1.0f;
                } else {
                    int i = 0;
                    while (i < this.baudRateListFull.length) {
                        if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                            if (ProcessingGrapherexp3.this.baudRate != this.baudRateListFull[i]) {
                                this.unsavedChanges = true;
                            }
                            ProcessingGrapherexp3.this.baudRate = this.baudRateListFull[i];
                            this.menuLevel = 0;
                            this.menuScroll = 0;
                            if (this.backExit) {
                                this.backExit = false;
                                ProcessingGrapherexp3.this.settingsMenuActive = false;
                            }
                            ProcessingGrapherexp3.this.redrawUI = true;
                        }
                        tHnow += 1.0f;
                        ++i;
                    }
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 0.5f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    if (this.backExit) {
                        this.backExit = false;
                        ProcessingGrapherexp3.this.settingsMenuActive = false;
                    }
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.menuLevel == 2) {
                float tHnow = 1.0f;
                if (this.lineEndingNames.length == 0) {
                    tHnow += 1.0f;
                } else {
                    int i = 0;
                    while (i < this.lineEndingNames.length) {
                        if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                            if (ProcessingGrapherexp3.this.lineEnding != this.lineEndingList[i]) {
                                this.unsavedChanges = true;
                            }
                            ProcessingGrapherexp3.this.lineEnding = this.lineEndingList[i];
                            this.menuLevel = 0;
                            this.menuScroll = 0;
                            ProcessingGrapherexp3.this.redrawUI = true;
                        }
                        tHnow += 1.0f;
                        ++i;
                    }
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 0.5f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.menuLevel == 3) {
                float tHnow = 1.0f;
                if (this.parityBitsNames.length == 0) {
                    tHnow += 1.0f;
                } else {
                    int i = 0;
                    while (i < this.parityBitsNames.length) {
                        if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                            if (ProcessingGrapherexp3.this.serialParity != this.parityBitsList[i]) {
                                this.unsavedChanges = true;
                            }
                            ProcessingGrapherexp3.this.serialParity = this.parityBitsList[i];
                            this.menuLevel = 0;
                            this.menuScroll = 0;
                            ProcessingGrapherexp3.this.redrawUI = true;
                        }
                        tHnow += 1.0f;
                        ++i;
                    }
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 0.5f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.menuLevel == 4) {
                float tHnow = 1.0f;
                if (this.dataBitsNames.length == 0) {
                    tHnow += 1.0f;
                } else {
                    int i = 0;
                    while (i < this.dataBitsNames.length) {
                        if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                            if (ProcessingGrapherexp3.this.serialDatabits != this.dataBitsList[i]) {
                                this.unsavedChanges = true;
                            }
                            ProcessingGrapherexp3.this.serialDatabits = this.dataBitsList[i];
                            this.menuLevel = 0;
                            this.menuScroll = 0;
                            ProcessingGrapherexp3.this.redrawUI = true;
                        }
                        tHnow += 1.0f;
                        ++i;
                    }
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 0.5f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.menuLevel == 5) {
                float tHnow = 1.0f;
                if (this.stopBitsNames.length == 0) {
                    tHnow += 1.0f;
                } else {
                    int i = 0;
                    while (i < this.stopBitsNames.length) {
                        if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                            if (ProcessingGrapherexp3.this.serialStopbits != this.stopBitsList[i]) {
                                this.unsavedChanges = true;
                            }
                            ProcessingGrapherexp3.this.serialStopbits = this.stopBitsList[i];
                            this.menuLevel = 0;
                            this.menuScroll = 0;
                            ProcessingGrapherexp3.this.redrawUI = true;
                        }
                        tHnow += 1.0f;
                        ++i;
                    }
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 0.5f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            } else if (this.menuLevel == 6) {
                float tHnow = 1.0f;
                if (this.separatorNames.length == 0) {
                    tHnow += 1.0f;
                } else {
                    int i = 0;
                    while (i < this.separatorNames.length) {
                        if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow, iL, iW)) {
                            if (ProcessingGrapherexp3.this.separator != this.separatorList[i]) {
                                this.unsavedChanges = true;
                            }
                            ProcessingGrapherexp3.this.separator = this.separatorList[i];
                            this.menuLevel = 0;
                            this.menuScroll = 0;
                            ProcessingGrapherexp3.this.redrawUI = true;
                        }
                        tHnow += 1.0f;
                        ++i;
                    }
                }
                if (ProcessingGrapherexp3.this.menuXYclick(xcoord, ycoord, sT, uH, iH, tHnow += 0.5f, iL, iW)) {
                    this.menuLevel = 0;
                    this.menuScroll = 0;
                    ProcessingGrapherexp3.this.redrawUI = true;
                }
            }
        }

        @Override
        public void parsePortData(String inputData, boolean graphable) {
        }

        @Override
        public void connectionEvent(boolean status) {
        }

        @Override
        public boolean checkSafeExit() {
            return true;
        }

        @Override
        public void performExit() {
        }
    }

    static interface TabAPI {
        public String getName();

        public void setVisibility(boolean var1);

        public void drawContent();

        public void drawNewData();

        public void drawSidebar();

        public void drawInfoBar();

        public void menuClick(int var1, int var2);

        public void contentClick(int var1, int var2);

        public void scrollWheel(float var1);

        public void scrollBarUpdate(int var1, int var2);

        public void keyboardInput(char var1, int var2, boolean var3);

        public void changeSize(int var1, int var2, int var3, int var4);

        public String getOutput();

        public void setOutput(String var1);

        public void connectionEvent(boolean var1);

        public void parsePortData(String var1, boolean var2);

        public void setMenuLevel(int var1);

        public boolean checkSafeExit();

        public void performExit();
    }

    public class ValidateInput {
        private String inputString;
        private String errorMessage;
        private int intValue;
        private double doubleValue;
        public static final int NONE = 0;
        public static final int GT = 1;
        public static final int GTE = 2;
        public static final int LT = 3;
        public static final int LTE = 4;

        public ValidateInput(String heading, String message, String defaultText) {
            this.inputString = ProcessingGrapherexp3.this.myShowInputDialog(heading, message, defaultText);
        }

        public boolean isEmpty() {
            return this.inputString == null || this.inputString.isEmpty() || this.inputString.trim().isEmpty();
        }

        public void setErrorMessage(String error) {
            this.errorMessage = error;
        }

        public boolean checkFloat() {
            return this.checkDouble(0, 0.0, 0, 0.0);
        }

        public boolean checkFloat(int operator1, float value1) {
            return this.checkDouble(operator1, value1, 0, 0.0);
        }

        public boolean checkFloat(int operator1, float value1, int operator2, float value2) {
            return this.checkDouble(operator1, value1, operator2, value2);
        }

        public boolean checkDouble() {
            return this.checkDouble(0, 0.0, 0, 0.0);
        }

        public boolean checkDouble(int operator1, double value1) {
            return this.checkDouble(operator1, value1, 0, 0.0);
        }

        public boolean checkDouble(int operator1, double value1, int operator2, double value2) {
            if (this.inputString != null) {
                try {
                    this.doubleValue = Double.parseDouble(this.inputString);
                    if (!this.doubleConstraint(operator1, value1) || !this.doubleConstraint(operator2, value2)) {
                        ProcessingGrapherexp3.this.alertMessage(this.errorMessage);
                        return false;
                    }
                    return true;
                }
                catch (Exception exception) {
                    ProcessingGrapherexp3.this.alertMessage(this.errorMessage);
                    return false;
                }
            }
            return false;
        }

        public boolean checkInt() {
            return this.checkInt(0, 0, 0, 0);
        }

        public boolean checkInt(int operator1, int value1) {
            return this.checkInt(operator1, value1, 0, 0);
        }

        public boolean checkInt(int operator1, int value1, int operator2, int value2) {
            if (this.inputString != null) {
                try {
                    this.intValue = Integer.parseInt(this.inputString);
                    if (!this.intConstraint(operator1, value1) || !this.intConstraint(operator2, value2)) {
                        ProcessingGrapherexp3.this.alertMessage(this.errorMessage);
                        return false;
                    }
                    return true;
                }
                catch (Exception exception) {
                    ProcessingGrapherexp3.this.alertMessage(this.errorMessage);
                    return false;
                }
            }
            return false;
        }

        private boolean doubleConstraint(int operators, double value1) {
            switch (operators) {
                case 1: {
                    if (!(this.doubleValue <= value1)) break;
                    return false;
                }
                case 2: {
                    if (!(this.doubleValue < value1)) break;
                    return false;
                }
                case 3: {
                    if (!(this.doubleValue >= value1)) break;
                    return false;
                }
                case 4: {
                    if (!(this.doubleValue > value1)) break;
                    return false;
                }
            }
            return true;
        }

        private boolean intConstraint(int operators, int value1) {
            switch (operators) {
                case 1: {
                    if (this.intValue > value1) break;
                    return false;
                }
                case 2: {
                    if (this.intValue >= value1) break;
                    return false;
                }
                case 3: {
                    if (this.intValue < value1) break;
                    return false;
                }
                case 4: {
                    if (this.intValue <= value1) break;
                    return false;
                }
            }
            return true;
        }

        public double getDouble() {
            return this.doubleValue;
        }

        public float getFloat() {
            return (float)this.doubleValue;
        }

        public int getInt() {
            return this.intValue;
        }
    }
}

